/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/
#include <stdio.h>
#include <aghdr.h>

#ifdef DMALLOC
#include "dmalloc.h"
#endif

static int iofread(void *chan, char *buf, int bufsize)
{
	return read(fileno((FILE*)chan), buf, bufsize);
	/* return fread(buf, 1, bufsize, (FILE*)chan); */
}

/* default IO methods */
static int ioputstr(void *chan, char *str)
{
	return fputs(str, (FILE*)chan);
}

static int ioflush(void *chan)
{
	return fflush((FILE*)chan);
}

Agiodisc_t AgIoDisc = { iofread, ioputstr, ioflush };
