#############################################################################
##
#A  polynom.tst    		GAP tests                        Frank Celler
##
#A  @(#)$Id: polynom.tst,v 1.1.1.1 1996/12/11 12:44:37 werner Exp $
##
#Y  Copyright 1990-1992,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file tests the functions that mainly deal with polynomials.
##
#H  $Log: polynom.tst,v $
#H  Revision 1.1.1.1  1996/12/11 12:44:37  werner
#H  Preparing 3.4.4 for release
#H
#H  Revision 3.3  1993/02/10  16:09:22  fceller
#H  changed printing of polynomials over the rationals
#H
#H  Revision 3.2  1992/11/25  13:16:52  fceller
#H  Initial GAP 3.2 revision
##

# set screen size to a sensible (known) value, save old value ###############
sizeScreen := SizeScreen();;
SizeScreen( [ 70, 24 ] );
#>[ 70, 24 ]
infoRead1 := InfoRead1;;
InfoRead1 := Ignore;;

# check display function ####################################################
Unbind(X(Integers).name);
Polynomial( Integers, [0] );  
#>0*X(Integers)^0

Polynomial( Integers, [1] );
#>X(Integers)^0

Polynomial( Integers, [-1] );
#>-X(Integers)^0

Polynomial( Integers, [2] ); 
#>2*X(Integers)^0
Polynomial( Integers, [-2] );
#>-2*X(Integers)^0

Polynomial( Integers, [0,1] );
#>X(Integers)

Polynomial( Integers, [0,-1] );
#>-X(Integers)

Polynomial( Integers, [0,2] ); 
#>2*X(Integers)

Polynomial( Integers, [0,1,-1,1] );
#>X(Integers)^3 - X(Integers)^2 + X(Integers)

Polynomial( Integers, [0,1,-1,-2] );
#>-2*X(Integers)^3 - X(Integers)^2 + X(Integers)

Polynomial( Integers, [0,1,-2,-2] );
#>-2*X(Integers)^3 - 2*X(Integers)^2 + X(Integers)

Polynomial( Integers, [2,-3,4,-5], -2 );   
#>-5*X(Integers) + 4 - 3*X(Integers)^(-1) + 2*X(Integers)^(-2)

f5 := GF(5);;
X(f5).name := "x";;
Polynomial( f5, [1,2,3,4]*Z(5)^0, -2 );
#>Z(5)^0*(4*x + 3 + 2*x^(-1) + x^(-2))

Polynomial( f5, [1]*Z(5)^0, -2 );      
#>x^(-2)

Polynomial( f5, [1]*Z(5)^0 );    
#>x^0

Polynomial( f5, [1]*Z(5)^0, 2 );
#>x^2

Polynomial( f5, [2]*Z(5)^0, 2 );
#>Z(5)*x^2

Polynomial( f5, [2]*Z(5)^0 );   
#>Z(5)*x^0

Polynomial( f5, [0]*Z(5)^0 );
#>0*x^0

# check arithmetic of polynomial over rings #################################
x := X(Integers);;
x.name := "x";;

g := x^3 + x^2 + x + 1;
#>x^3 + x^2 + x + 1

h := x^(-2) + x^(-3);
#>x^(-2) + x^(-3)

g * h;
#>x + 2 + 2*x^(-1) + 2*x^(-2) + x^(-3)

g + h;
#>x^3 + x^2 + x + 1 + x^(-2) + x^(-3)

g - h;
#>x^3 + x^2 + x + 1 - x^(-2) - x^(-3)

g ^ 5;
#>x^15 + 5*x^14 + 15*x^13 + 35*x^12 + 65*x^11 + 101*x^10 + 135*x^9 + 
#>155*x^8 + 155*x^7 + 135*x^6 + 101*x^5 + 65*x^4 + 35*x^3 + 15*x^2 + 
#>5*x + 1

k := x^3 + x + 1;
#>x^3 + x + 1

t := g^3 * k^4;  
#>x^21 + 3*x^20 + 10*x^19 + 26*x^18 + 54*x^17 + 106*x^16 + 180*x^15 + 
#>276*x^14 + 392*x^13 + 500*x^12 + 588*x^11 + 636*x^10 + 623*x^9 + 
#>561*x^8 + 458*x^7 + 334*x^6 + 219*x^5 + 125*x^4 + 60*x^3 + 24*x^2 + 
#>7*x + 1

Quotient( t, g^2 );
#>x^15 + x^14 + 5*x^13 + 9*x^12 + 14*x^11 + 26*x^10 + 32*x^9 + 40*x^
#>8 + 47*x^7 + 43*x^6 + 39*x^5 + 31*x^4 + 19*x^3 + 11*x^2 + 5*x + 1

g * k^4;
#>x^15 + x^14 + 5*x^13 + 9*x^12 + 14*x^11 + 26*x^10 + 32*x^9 + 40*x^
#>8 + 47*x^7 + 43*x^6 + 39*x^5 + 31*x^4 + 19*x^3 + 11*x^2 + 5*x + 1

StandardAssociate( -2*x^2 + 2*x );
#>2*x^2 - 2*x

LR := LaurentPolynomialRing(Integers);                          
#>LaurentPolynomialRing( Integers )

StandardAssociate( LR, -2*x^2 + 2*x );
#>2*x - 2

Quotient( x^2 - x - 1, x^3 );    
#>false

Quotient( LR, x^2 - x - 1, x^3 );
#>x^(-1) - x^(-2) - x^(-3)

Quotient( LR, x^2 - x - 1, 2*x^3 );       
#>false

# check arithmetic of polynomial over rationals #############################
x := X(Rationals);;
x.name := "x";;

g := 1/3*x^3 + x^2 + x + 1;
#>(1/3)*x^3 + x^2 + x + 1

h := x^(-2) + x^(-3);
#>x^(-2) + x^(-3)

g * h;
#>(1/3)*x + (4/3) + 2*x^(-1) + 2*x^(-2) + x^(-3)

g + h;
#>(1/3)*x^3 + x^2 + x + 1 + x^(-2) + x^(-3)

g - h;
#>(1/3)*x^3 + x^2 + x + 1 - x^(-2) - x^(-3)

g ^ 5;
#>(1/243)*x^15 + (5/81)*x^14 + (35/81)*x^13 + (155/81)*x^12 + (55/
#>9)*x^11 + (407/27)*x^10 + (805/27)*x^9 + (145/3)*x^8 + 65*x^7 + (
#>655/9)*x^6 + (203/3)*x^5 + (155/3)*x^4 + (95/3)*x^3 + 15*x^2 + 
#>5*x + 1

Mod( g^5, h );
#>32/243*x^0

Mod( g^5, h*x^4 );
#>(211/243)*x + 1

k := x^3 + x + 1;
#>x^3 + x + 1

t := g^3 * k^4;
#>(1/27)*x^21 + (1/3)*x^20 + (40/27)*x^19 + (130/27)*x^18 + (116/9)*x^
#>17 + (262/9)*x^16 + (1558/27)*x^15 + (916/9)*x^14 + (4342/27)*x^
#>13 + (6236/27)*x^12 + (2702/9)*x^11 + (9616/27)*x^10 + (10369/27)*x^
#>9 + (1127/3)*x^8 + (998/3)*x^7 + (790/3)*x^6 + 185*x^5 + 113*x^4 + 
#>58*x^3 + 24*x^2 + 7*x + 1

Quotient( t, g^2 );
#>(1/3)*x^15 + x^14 + (7/3)*x^13 + (19/3)*x^12 + 10*x^11 + 18*x^10 + (
#>76/3)*x^9 + 32*x^8 + (115/3)*x^7 + (113/3)*x^6 + 35*x^5 + (85/3)*x^
#>4 + (55/3)*x^3 + 11*x^2 + 5*x + 1

g * k^4;
#>(1/3)*x^15 + x^14 + (7/3)*x^13 + (19/3)*x^12 + 10*x^11 + 18*x^10 + (
#>76/3)*x^9 + 32*x^8 + (115/3)*x^7 + (113/3)*x^6 + 35*x^5 + (85/3)*x^
#>4 + (55/3)*x^3 + 11*x^2 + 5*x + 1

StandardAssociate( -2*x^2 + 2*x );
#>x^2 - x

LR := LaurentPolynomialRing(Rationals);
#>LaurentPolynomialRing( Rationals )

StandardAssociate( LR, -2*x^2 + 2*x );
#>x - 1

Quotient( x^2 - x - 1, x^3 );    
#>false

Quotient( LR, x^2 - x - 1, x^3 );
#>x^(-1) - x^(-2) - x^(-3)

Quotient( LR, x^2 - x - 1, 2*x^3 );
#>(1/2)*x^(-1) + (-1/2)*x^(-2) + (-1/2)*x^(-3)

# now some 'PowerMod' timinings #############################################
x := X(Rationals);;
x.name := "x";;
g := x^30 + x^29 - x^28 + x^27 + x^26 + x^24 + x^23 - x^22
     - x^21 - x^20 + x^19 - x^18 - x^17 + x^16 - x^15 + x^14
     + x^13 + x^12 + x^11 + x^10 - x^9 + x^7 + x^6 + x^5
     - x^4 + x^3 + x^2 - x + 1;;
h := -x^30 + x^29 + x^28 + x^26 - x^25 + x^23 + x^22
     + x^21 + x^20 - x^19 - x^18 + x^17 + x^16 - x^14 + x^12
     - x^11 - x^10 - x^9 - x^8 - x^7 + x^6 - x^5 + x^4 - x^3
     - x^2 - x - 1;;

PowerMod( g, 5, h );
#>429915071547552369643008903956*x^29 + 314698723536887703030000151091
#> *x^28 + 115143769952290509485690008680*x^27 + 
#>199429248237047256398504667303*x^26 - 84503200207285843512566251730
#> *x^25 + 283555353623200411801303621250*x^24 + 
#>491118460252742841520170938902*x^23 + 420703119641803675544413455498
#> *x^22 + 298743603740823117833937899840*x^21 + 
#>87509469392393874533737610586*x^20 - 278348489162945965223652560207
#> *x^19 - 52185088666803665500101586300*x^18 + 
#>339530389803012332574254627791*x^17 + 158152267398382422277981511607
#> *x^16 - 155995016582247080131017984585*x^15 - 
#>270183692080028145055539076639*x^14 - 38043643194512646818802347918
#> *x^13 - 65891668872955732431663006503*x^12 - 
#>544039578621298788313117568729*x^11 - 512362606355482866711832755487
#> *x^10 - 457498024728400255514513414423*x^9 - 
#>362472455622378960389392723042*x^8 - 197887972953766916352954740330
#> *x^7 + 87172692192812289001397164551*x^6 - 
#>278931787970721344798908251633*x^5 - 53195363410981397191297844718
#> *x^4 - 522049551243190605377563272541*x^3 - 
#>474275833353823265164685692429*x^2 - 391531654940062909713496213206
#> *x - 248218566408345254006591357195

x := X(f5);; 
x.name := "x";;
g := x^30 + x^29 - x^28 + x^27 + x^26 + x^24 + x^23 - x^22
     - x^21 - x^20 + x^19 - x^18 - x^17 + x^16 - x^15 + x^14
     + x^13 + x^12 + x^11 + x^10 - x^9 + x^7 + x^6 + x^5
     - x^4 + x^3 + x^2 - x + 1;;
h := -x^30 + x^29 + x^28 + x^26 - x^25 + x^23 + x^22
     + x^21 + x^20 - x^19 - x^18 + x^17 + x^16 - x^14 + x^12
     - x^11 - x^10 - x^9 - x^8 - x^7 + x^6 - x^5 + x^4 - x^3
     - x^2 - x - 1;;

n := Factorial(200);
#>78865786736479050355236321393218506229513597768717326329474253324435\
#>94499634033429203042840119846239041772121389196388302576427902426371\
#>05061926624952829931113462857270763317237396988943922445621451664240\
#>25403329186413122742829485327752424240757390324032125740557956866022\
#>60319041703240623517008587961789222227896237038973747200000000000000\
#>00000000000000000000000000000000000

PowerMod( g, n, h );             
#>Z(5)^0*(x^28 + x^27 + 3*x^25 + 3*x^21 + 3*x^20 + 2*x^19 + 4*x^18 + 
#>2*x^17 + 2*x^16 + x^15 + 3*x^14 + 3*x^13 + x^12 + 3*x^11 + 3*x^10 + 
#>2*x^9 + 3*x^8 + 4*x^7 + x^6 + 4*x^5 + 2*x^4 + 4*x^3 + x + 1)

# and now the factorization #################################################
f2 := GF(2);;
X(f2).name := "x";;
f := Polynomial( f2, [ Z(2)^0, 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0,
          0*Z(2), 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, 0*Z(2), 0*Z(2), 0*Z(2), 
          0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 
          0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, 
          Z(2)^0, 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), 
          0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), Z(2)^0, 
          0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 
          Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), 
          0*Z(2), 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 
          Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), 
          0*Z(2), 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, Z(2)^0, 
          0*Z(2), 0*Z(2), Z(2)^0, 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), 
          0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), 0*Z(2), Z(2)^0, 
          0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), 0*Z(2), 
          0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 
          0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), 
          0*Z(2), 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, Z(2)^0, 
          0*Z(2), 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), 
          Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 
          Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), 0*Z(2), 
          0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 0*Z(2), 0*Z(2), 
          Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 
          Z(2)^0, 0*Z(2), 0*Z(2), 0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), 
          0*Z(2), Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 
          Z(2)^0, Z(2)^0, Z(2)^0, Z(2)^0, 0*Z(2), Z(2)^0, 0*Z(2), Z(2)^0, 
          Z(2)^0, Z(2)^0 ] );;

r := Factors(f);
#>[ Z(2)^0*(x^3 + x + 1), Z(2)^0*(x^4 + x^3 + x^2 + x + 1), 
#>  Z(2)^0*(x^5 + x^3 + x^2 + x + 1), 
#>  Z(2)^0*(x^49 + x^48 + x^46 + x^45 + x^43 + x^42 + x^41 + x^39 + x^
#>    38 + x^34 + x^32 + x^29 + x^27 + x^24 + x^23 + x^16 + x^13 + x^
#>    12 + x^11 + x^10 + x^9 + x^7 + x^6 + x^5 + x^4 + x^2 + 1), 
#>  Z(2)^0*(x^59 + x^57 + x^55 + x^54 + x^50 + x^49 + x^48 + x^46 + x^
#>    42 + x^37 + x^36 + x^33 + x^32 + x^31 + x^30 + x^29 + x^28 + x^
#>    27 + x^25 + x^23 + x^22 + x^21 + x^18 + x^16 + x^13 + x^10 + x^
#>    8 + x^6 + x^2 + x + 1), Z(2)^0*(x^79 + x^78 + x^75 + x^74 + x^
#>    73 + x^72 + x^71 + x^64 + x^63 + x^57 + x^56 + x^55 + x^54 + x^
#>    53 + x^52 + x^50 + x^49 + x^47 + x^41 + x^39 + x^34 + x^32 + x^
#>    30 + x^29 + x^28 + x^26 + x^22 + x^21 + x^20 + x^18 + x^17 + x^
#>    10 + x^6 + x^5 + x^3 + x^2 + 1) ]

Product(r) = f;
#>true

Set(r) = Set(Factors(f^2));
#>true

g := r[1]^2 * r[2]^4 * r[3]^8;
#>Z(2)^0*(x^62 + x^56 + x^52 + x^48 + x^46 + x^44 + x^42 + x^38 + x^
#>36 + x^30 + x^26 + x^24 + x^22 + x^18 + x^16 + x^10 + x^4 + x^2 + 1)

r := Factors(g);
#>[ Z(2)^0*(x^3 + x + 1), Z(2)^0*(x^3 + x + 1), 
#>  Z(2)^0*(x^4 + x^3 + x^2 + x + 1), Z(2)^0*(x^4 + x^3 + x^2 + x + 1)
#>    , Z(2)^0*(x^4 + x^3 + x^2 + x + 1), 
#>  Z(2)^0*(x^4 + x^3 + x^2 + x + 1), Z(2)^0*(x^5 + x^3 + x^2 + x + 1)
#>    , Z(2)^0*(x^5 + x^3 + x^2 + x + 1), 
#>  Z(2)^0*(x^5 + x^3 + x^2 + x + 1), Z(2)^0*(x^5 + x^3 + x^2 + x + 1)
#>    , Z(2)^0*(x^5 + x^3 + x^2 + x + 1), 
#>  Z(2)^0*(x^5 + x^3 + x^2 + x + 1), Z(2)^0*(x^5 + x^3 + x^2 + x + 1)
#>    , Z(2)^0*(x^5 + x^3 + x^2 + x + 1) ]

Product(r) = g;
#>true

f5 := GF(5);;
X(f5).name := "x";;
f := Polynomial( f5, [ 0*Z(5), Z(5), Z(5)^2, Z(5), Z(5)^0, Z(5)^0, 
    Z(5)^3, Z(5)^3, Z(5)^2, Z(5), 0*Z(5), 0*Z(5), Z(5)^3, 0*Z(5), Z(5)^2,
    Z(5)^2, Z(5), 0*Z(5), 0*Z(5), Z(5)^0, Z(5), 0*Z(5), Z(5)^0, 
    0*Z(5), Z(5)^2, Z(5)^0, Z(5)^0, 0*Z(5), Z(5)^3, 0*Z(5), 0*Z(5), 
    0*Z(5), 0*Z(5), Z(5), Z(5)^3, Z(5), Z(5)^0, Z(5)^0, Z(5), 0*Z(5), 
    0*Z(5), Z(5)^0, Z(5), Z(5)^2, 0*Z(5), Z(5)^3, Z(5)^3, Z(5)^3, Z(5)^2,
    Z(5)^2, Z(5), Z(5)^0, Z(5), Z(5)^3, Z(5)^2, 0*Z(5), Z(5), Z(5)^3, 
    0*Z(5), 0*Z(5), Z(5)^3, Z(5)^2, Z(5)^0, Z(5)^3, Z(5)^2, 0*Z(5), 
    Z(5), Z(5), Z(5), Z(5), 0*Z(5), Z(5)^0, Z(5)^2, Z(5)^3, 0*Z(5), 
    Z(5), Z(5), Z(5)^3, Z(5)^2, Z(5)^3, Z(5), Z(5)^3, 0*Z(5), Z(5)^0, 
    Z(5)^0, Z(5)^3, 0*Z(5), Z(5)^0, Z(5)^3, Z(5)^0, Z(5)^2, 0*Z(5), 
    Z(5), Z(5)^2, 0*Z(5), 0*Z(5), Z(5)^2, Z(5)^0, Z(5)^3, Z(5)^2, 
    0*Z(5), Z(5), 0*Z(5), 0*Z(5), Z(5)^0, Z(5)^0, Z(5)^0, 0*Z(5), Z(5)^2, 
    Z(5), Z(5), Z(5), Z(5)^2, Z(5)^0, Z(5)^3, Z(5)^0, Z(5)^0, Z(5)^2, 
    Z(5)^0, Z(5)^2, Z(5)^2, 0*Z(5), 0*Z(5), Z(5)^3, Z(5), Z(5), 0*Z(5), 
    Z(5)^3, Z(5)^2, 0*Z(5), Z(5), Z(5)^2, Z(5), Z(5)^0, Z(5)^0, Z(5)^2, 
    0*Z(5), Z(5)^0, Z(5)^3, Z(5)^0, Z(5)^2, Z(5)^2, Z(5)^3, Z(5), Z(5), 
    Z(5)^3, Z(5), Z(5)^0, Z(5)^3, Z(5)^2, 0*Z(5), Z(5), Z(5)^2, Z(5)^0, 
    Z(5)^3, Z(5)^2, Z(5)^2, 0*Z(5), Z(5)^0, Z(5), 0*Z(5), Z(5)^0, Z(5)^3,
    Z(5), Z(5)^0, Z(5)^3, Z(5)^0, Z(5)^3, 0*Z(5), Z(5)^2, Z(5), Z(5)^0,
    0*Z(5), Z(5)^2, Z(5)^3, Z(5)^3, Z(5)^3, Z(5)^0, Z(5), Z(5)^3, 
    Z(5)^0, 0*Z(5), Z(5)^3, Z(5)^3, 0*Z(5), 0*Z(5), Z(5), Z(5)^3, Z(5)^3,
    Z(5)^3, Z(5), Z(5)^3, 0*Z(5), 0*Z(5), 0*Z(5), Z(5), Z(5)^3, 
    0*Z(5), Z(5)^0, 0*Z(5), Z(5) ] );;

r := Factors(f);
#>[ Z(5)^0*(2*x + 1), Z(5)^0*(x^3 + x + 1), 
#>  Z(5)^0*(x^3 + 2*x^2 + 2*x + 3), Z(5)^0*(x^6 + 3*x^3 + 4), 
#>  Z(5)^0*(x^11 + 2*x^10 + x^9 + 4*x^8 + 4*x^7 + x^6 + 3*x^5 + 3*x^
#>    4 + 3*x^3 + x^2 + 4*x + 4), 
#>  Z(5)^0*(x^175 + 3*x^174 + 2*x^173 + x^172 + x^171 + 3*x^170 + 4*x^
#>    168 + x^167 + 4*x^166 + 3*x^165 + x^164 + 2*x^161 + 3*x^160 + 
#>    3*x^159 + 3*x^157 + 2*x^156 + 3*x^155 + 2*x^154 + 4*x^151 + 2*x^
#>    150 + 4*x^148 + 3*x^146 + 2*x^145 + 3*x^144 + 3*x^143 + x^142 + 
#>    4*x^141 + x^139 + 4*x^138 + 2*x^137 + x^136 + x^135 + 4*x^134 + 
#>    2*x^133 + 3*x^131 + 3*x^130 + 4*x^129 + 2*x^128 + 2*x^127 + 2*x^
#>    126 + x^125 + 2*x^123 + 4*x^122 + x^121 + 3*x^120 + 2*x^119 + 
#>    4*x^118 + x^117 + x^116 + x^115 + 3*x^114 + 2*x^111 + 2*x^110 + 
#>    2*x^109 + 4*x^108 + 2*x^107 + 4*x^106 + 3*x^105 + 4*x^104 + x^
#>    103 + 2*x^102 + 3*x^101 + 2*x^100 + 2*x^98 + 4*x^97 + x^96 + 
#>    3*x^95 + 2*x^94 + 3*x^93 + 2*x^92 + 4*x^91 + 4*x^90 + 4*x^
#>    89 + x^88 + 3*x^85 + 3*x^83 + 3*x^82 + 4*x^81 + 4*x^80 + 2*x^
#>    79 + 2*x^78 + x^77 + 3*x^76 + 4*x^75 + 4*x^74 + x^73 + 2*x^71 + 
#>    3*x^70 + 4*x^69 + 4*x^68 + 4*x^67 + 4*x^66 + 2*x^65 + x^64 + x^
#>    63 + 3*x^62 + 2*x^61 + 4*x^59 + 4*x^58 + 2*x^57 + 3*x^56 + 3*x^
#>    55 + x^54 + 4*x^53 + x^51 + x^50 + x^47 + 2*x^45 + 4*x^44 + 2*x^
#>    43 + 2*x^42 + 4*x^41 + 2*x^40 + x^39 + x^37 + 4*x^36 + 3*x^35 + 
#>    2*x^34 + x^32 + 4*x^31 + 3*x^30 + 2*x^29 + x^28 + 3*x^27 + 4*x^
#>    26 + 2*x^25 + 2*x^23 + 4*x^22 + x^20 + 2*x^18 + x^17 + 4*x^
#>    16 + x^15 + 2*x^13 + 2*x^12 + 2*x^11 + 2*x^10 + x^9 + 2*x^8 + 
#>    3*x^7 + 3*x^6 + 4*x^5 + 3*x^4 + x^3 + x + 4), x ]

Product(r) = f;
#>true

g := Polynomial( f5, [ 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), Z(5)^0,
         0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), Z(5)^3, 0*Z(5), 0*Z(5), 0*Z(5), 
         0*Z(5), Z(5), 0*Z(5), 0*Z(5), 0*Z(5), 0*Z(5), Z(5)^0, 0*Z(5), 
         0*Z(5), 0*Z(5), 0*Z(5), Z(5) ] );;

r := Factors(g);
#>[ Z(5)^0*(2*x + 1), Z(5)^0*(x + 3), Z(5)^0*(x + 3), Z(5)^0*(x + 3), 
#>  Z(5)^0*(x + 3), Z(5)^0*(x^3 + x + 1), Z(5)^0*(x^3 + x + 1), 
#>  Z(5)^0*(x^3 + x + 1), Z(5)^0*(x^3 + x + 1), Z(5)^0*(x^3 + x + 1), 
#>  x, x, x, x, x ]

Set(r) = Set(Factors(g^25));
#>true

# some tests for embeddings #################################################
f7 := GF(7);;
x  := X(f7);;
x.name := "x";;
g := Z(7)^0*(x^36 + 6*x^34 + x^33 + 6*x^32 + 5*x^31 + 6*x^30 + 6*x^29 + 
     4*x^28 + 2*x^27 + 2*x^26 + 6*x^25 + 5*x^24 + x^23 + 3*x^22 + 4*x^
     21 + x^20 + x^19 + x^18 + x^16 + 6*x^13 + x^12 + 4*x^11 + 4*x^10 + 
     3*x^9 + 3*x^8 + 5*x^7 + 5*x^6 + x^5 + 2*x^4 + 4*x^3 + x^2 + 4*x + 3);;

Factors(g);
#>[ Z(7)^0*(x^36 + 6*x^34 + x^33 + 6*x^32 + 5*x^31 + 6*x^30 + 6*x^
#>    29 + 4*x^28 + 2*x^27 + 2*x^26 + 6*x^25 + 5*x^24 + x^23 + 3*x^
#>    22 + 4*x^21 + x^20 + x^19 + x^18 + x^16 + 6*x^13 + x^12 + 4*x^
#>    11 + 4*x^10 + 3*x^9 + 3*x^8 + 5*x^7 + 5*x^6 + x^5 + 2*x^4 + 4*x^
#>    3 + x^2 + 4*x + 3) ]

r := Factors( EmbeddedPolynomial(PolynomialRing(GF(7^2)),g) );
#>[ X(GF(7^2))^18 + Z(7^2)^12*X(GF(7^2))^17 + Z(7^2)^38*X(GF(7^2))^
#>    16 + Z(7^2)^6*X(GF(7^2))^15 + Z(7^2)^34*X(GF(7^2))^14 + Z(7^2)^
#>    26*X(GF(7^2))^13 + Z(7^2)^5*X(GF(7^2))^12 + Z(7^2)^45*X(GF(7^
#>    2))^11 + Z(7^2)^33*X(GF(7^2))^10 + Z(7^2)^19*X(GF(7^2))^9 + 
#>    Z(7^2)^22*X(GF(7^2))^8 + Z(7^2)^27*X(GF(7^2))^7 + Z(7^2)^
#>    47*X(GF(7^2))^6 + Z(7^2)^4*X(GF(7^2))^5 + Z(7^2)^4*X(GF(7^2))^
#>    4 + Z(7^2)^29*X(GF(7^2))^3 + Z(7^2)^14*X(GF(7^2))^2 + Z(7^2)^
#>    2*X(GF(7^2)) + Z(7^2)^19, X(GF(7^2))^18 + Z(7^2)^36*X(GF(7^2))^
#>    17 + Z(7^2)^26*X(GF(7^2))^16 + Z(7^2)^42*X(GF(7^2))^15 + Z(7^2)^
#>    46*X(GF(7^2))^14 + Z(7^2)^38*X(GF(7^2))^13 + Z(7^2)^35*X(GF(7^
#>    2))^12 + Z(7^2)^27*X(GF(7^2))^11 + Z(7^2)^39*X(GF(7^2))^10 + 
#>    Z(7^2)^37*X(GF(7^2))^9 + Z(7^2)^10*X(GF(7^2))^8 + Z(7^2)^
#>    45*X(GF(7^2))^7 + Z(7^2)^41*X(GF(7^2))^6 + Z(7^2)^28*X(GF(7^2))^
#>    5 + Z(7^2)^28*X(GF(7^2))^4 + Z(7^2)^11*X(GF(7^2))^3 + Z(7^2)^
#>    2*X(GF(7^2))^2 + Z(7^2)^14*X(GF(7^2)) + Z(7^2)^37 ]

EmbeddedPolynomial(PolynomialRing(f7),Product(r)) = g;
#>true

r := Factors( EmbeddedPolynomial(PolynomialRing(GF(7^3)),g) );       
#>[ X(GF(7^3))^12 + Z(7^3)^56*X(GF(7^3))^11 + Z(7^3)^82*X(GF(7^3))^
#>    10 + Z(7^3)^17*X(GF(7^3))^9 + Z(7^3)^155*X(GF(7^3))^8 + Z(7^3)^
#>    244*X(GF(7^3))^7 + Z(7^3)^28*X(GF(7^3))^6 + Z(7^3)^18*X(GF(7^
#>    3))^5 + Z(7^3)^183*X(GF(7^3))^4 + Z(7^3)^248*X(GF(7^3))^3 + 
#>    Z(7^3)^133*X(GF(7^3))^2 + Z(7^3)^266*X(GF(7^3)) + Z(7^3)^25, 
#>  X(GF(7^3))^12 + Z(7^3)^50*X(GF(7^3))^11 + Z(7^3)^232*X(GF(7^3))^
#>    10 + Z(7^3)^119*X(GF(7^3))^9 + Z(7^3)^59*X(GF(7^3))^8 + Z(7^3)^
#>    340*X(GF(7^3))^7 + Z(7^3)^196*X(GF(7^3))^6 + Z(7^3)^126*X(GF(7^
#>    3))^5 + Z(7^3)^255*X(GF(7^3))^4 + Z(7^3)^26*X(GF(7^3))^3 + 
#>    Z(7^3)^247*X(GF(7^3))^2 + Z(7^3)^152*X(GF(7^3)) + Z(7^3)^175, 
#>  X(GF(7^3))^12 + Z(7^3)^8*X(GF(7^3))^11 + Z(7^3)^256*X(GF(7^3))^
#>    10 + Z(7^3)^149*X(GF(7^3))^9 + Z(7^3)^71*X(GF(7^3))^8 + Z(7^3)^
#>    328*X(GF(7^3))^7 + Z(7^3)^4*X(GF(7^3))^6 + Z(7^3)^198*X(GF(7^
#>    3))^5 + Z(7^3)^75*X(GF(7^3))^4 + Z(7^3)^182*X(GF(7^3))^3 + 
#>    Z(7^3)^19*X(GF(7^3))^2 + Z(7^3)^38*X(GF(7^3)) + Z(7^3)^199 ]

EmbeddedPolynomial(PolynomialRing(f7),Product(r)) = g;
#>true

r := Factors( EmbeddedPolynomial(PolynomialRing(GF(7^4)),g) );
#>[ X(GF(7^4))^9 + Z(7^4)^30*X(GF(7^4))^8 + Z(7^4)^1384*X(GF(7^4))^
#>    7 + Z(7^4)^965*X(GF(7^4))^6 + Z(7^4)^701*X(GF(7^4))^5 + Z(7^4)^
#>    598*X(GF(7^4))^4 + Z(7^4)^48*X(GF(7^4))^3 + Z(7^4)^1506*X(GF(7^
#>    4))^2 + Z(7^4)^404*X(GF(7^4)) + Z(7^4)^115, 
#>  X(GF(7^4))^9 + Z(7^4)^210*X(GF(7^4))^8 + Z(7^4)^88*X(GF(7^4))^7 + 
#>    Z(7^4)^1955*X(GF(7^4))^6 + Z(7^4)^107*X(GF(7^4))^5 + Z(7^4)^
#>    1786*X(GF(7^4))^4 + Z(7^4)^336*X(GF(7^4))^3 + Z(7^4)^942*X(GF(7^
#>    4))^2 + Z(7^4)^428*X(GF(7^4)) + Z(7^4)^805, 
#>  X(GF(7^4))^9 + Z(7^4)^1470*X(GF(7^4))^8 + Z(7^4)^616*X(GF(7^4))^
#>    7 + Z(7^4)^1685*X(GF(7^4))^6 + Z(7^4)^749*X(GF(7^4))^5 + Z(7^4)^
#>    502*X(GF(7^4))^4 + Z(7^4)^2352*X(GF(7^4))^3 + Z(7^4)^1794*X(GF(
#>    7^4))^2 + Z(7^4)^596*X(GF(7^4)) + Z(7^4)^835, 
#>  X(GF(7^4))^9 + Z(7^4)^690*X(GF(7^4))^8 + Z(7^4)^1912*X(GF(7^4))^
#>    7 + Z(7^4)^2195*X(GF(7^4))^6 + Z(7^4)^443*X(GF(7^4))^5 + Z(7^4)^
#>    1114*X(GF(7^4))^4 + Z(7^4)^2064*X(GF(7^4))^3 + Z(7^4)^558*X(GF(
#>    7^4))^2 + Z(7^4)^1772*X(GF(7^4)) + Z(7^4)^1045 ]

EmbeddedPolynomial(PolynomialRing(f7),Product(r)) = g;
#>true

r :=  Factors( EmbeddedPolynomial(PolynomialRing(GF(7^5)),g) );
#>[ X(GF(7^5))^36 + Z(7)^3*X(GF(7^5))^34 + X(GF(7^5))^33 + Z(7)^
#>    3*X(GF(7^5))^32 + Z(7)^5*X(GF(7^5))^31 + Z(7)^3*X(GF(7^5))^30 + 
#>    Z(7)^3*X(GF(7^5))^29 + Z(7)^4*X(GF(7^5))^28 + Z(7)^2*X(GF(7^5))^
#>    27 + Z(7)^2*X(GF(7^5))^26 + Z(7)^3*X(GF(7^5))^25 + Z(7)^5*X(GF(
#>    7^5))^24 + X(GF(7^5))^23 + Z(7)*X(GF(7^5))^22 + Z(7)^4*X(GF(7^
#>    5))^21 + X(GF(7^5))^20 + X(GF(7^5))^19 + X(GF(7^5))^18 + X(GF(7^
#>    5))^16 + Z(7)^3*X(GF(7^5))^13 + X(GF(7^5))^12 + Z(7)^4*X(GF(7^
#>    5))^11 + Z(7)^4*X(GF(7^5))^10 + Z(7)*X(GF(7^5))^9 + Z(7)*X(GF(7^
#>    5))^8 + Z(7)^5*X(GF(7^5))^7 + Z(7)^5*X(GF(7^5))^6 + X(GF(7^5))^
#>    5 + Z(7)^2*X(GF(7^5))^4 + Z(7)^4*X(GF(7^5))^3 + X(GF(7^5))^2 + 
#>    Z(7)^4*X(GF(7^5)) + Z(7) ]

EmbeddedPolynomial(PolynomialRing(f7),Product(r)) = g;
#>true


# that's it for the polynomial package ######################################
SizeScreen( sizeScreen );;
InfoRead1 := infoRead1;;
Print( "$Id: polynom.tst,v 1.1.1.1 1996/12/11 12:44:37 werner Exp $  ",
       QuoInt( 1900000000, time ), " GAPstones\n" );
if IsBound( GAPSTONES )  then Add( GAPSTONES, QuoInt(1900000000,time) );  fi;
