/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */
#include <tcl.h>
#include <tk.h>
#include "floater.h"
#include "floatcmd.h"
#include "tickler.h"
#include "commandhash.h"
#include "br.h"
#include "comm.h"

bool debugprint = FALSE;

static char *talkmO, *talkmC;

semistatic char *fatal_error_message = NULL;

#if !TCL_IN_C
static bool check_library_path(char *env_var, char *compiled_in, char *guess, char *file)
{
  char *tcl_dir;
  FILE *f;
  char testfilename[500];
  char temp1[500];
  char *temp2;
  static int count = 0;
  bool ret;

  if (++count > 2) return FALSE;

  if ((tcl_dir = getenv(env_var)) == NULL)
    tcl_dir = compiled_in;
  
  sprintf(testfilename, "%s/%s", tcl_dir, file);
  if ((f = fopen(testfilename, "r")) == NULL) {
    fprintf(stderr, "WARNING! Unable to open %s---\n\t"
	    "does environment variable %s need to be set?\n",
	    testfilename, env_var);
    if (count == 1) {
#ifndef SRC_DIR
#define SRC_DIR "."
#endif
      sprintf(temp1, "%s/%s", SRC_DIR, guess);
      fprintf(stderr, "WARNING! Guessing to set %s to %s\n",
	      env_var, temp1);
      temp2 = salloc(sizeof(char) * (strlen(env_var) + strlen(temp1) + 5));
      sprintf(temp2, "%s=%s", env_var, temp1);
      putenv(temp2);
      ret = check_library_path(env_var, compiled_in, guess, file);
    } else ret = FALSE;
    --count;
    return ret;
  } else fclose(f);
  --count;
  return TRUE;
}

#define check_floater_library_path() \
    check_library_path("FLOATER_LIBRARY", FLOATER_LIBRARY, \
		       "tclcode", "floater.tcl")

void check_library_paths(void)
{
  if (!check_floater_library_path()) exit(-7);
}
#else /* TCL_IN_C */
void check_library_paths(void) {}
#endif

void inittickler(void)
{
  talkmO = STRDUP("talkmsg {");
  talkmC = STRDUP("}");
}

/* check for nasties embedded in text from outside */
char *safety_check(char *s)
{
  if (isin('[', s) || isin(']', s))
    fatal(TEMPCAT("Sabotage attempt from another player?!\n", s), -3);
  return s;
}

/* fatal error */
void fatal(char *msg, int exitcode)
{
  static int fatalerrs = 0;

  if (!hasWindows) endcurses();
  fprintf(stderr, "fatal error: %s\n", msg);
  fatal_error_message = msg;
#ifdef _WIN32
  {
    void WishPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));
    WishPanic(msg);
  }
#endif
  assert(0);
  floater_abort;
/*
  if (fatalerrs++ < 10) TclDo2("exit ", itoa(exitcode));
  exit(exitcode);
*/
}

/* error from tcl --- can we ignore it? */
static bool ignorable_error(void)
{
  char *msg;

  msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
  if (msg == NULL) msg = STRDUP(GET_INTERP_RESULT());
  return strneq(msg, "selection isn't in", strlen("selection isn't in"));
}

/* fatal error from tcl --- print error message and exit */
void error(void)
{
  char *msg;

  if (!hasWindows) endcurses();
  msg = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
  if (msg == NULL) msg = STRDUP(GET_INTERP_RESULT());
  fprintf(stderr, "%s\n", msg);
  fatal(msg, 1);
}

#if !TCL_IN_C
/* Source a Tcl file.  If TCL_IN_C is true then floatcl.c defines source(). */
void source(char *s)
{
  static char *tcl_dir = NULL;

  if (tcl_dir == NULL)
    if ((tcl_dir = getenv("FLOATER_LIBRARY")) == NULL)
      tcl_dir = FLOATER_LIBRARY;

  if (Tcl_VarEval(interp, "source ", tcl_dir, "/", s, ".tcl", NULL) != TCL_OK)
    error();
}    
#endif

/* Do a Tcl command */
char *TclDoIgnoreErrors(char *s)
{
  s = STRDUP(s);
  Tcl_Eval(interp, s);
  free(s);
  return TEMPCOPY(GET_INTERP_RESULT());
}    

#define TclTry(x) (((x) != TCL_OK && !ignorable_error()) ? (error(), 0) : 1)

/* Do a Tcl command */
char *TclDo(char *s)
{
  s = STRDUP(s);
  TclTry(Tcl_Eval(interp, s));
    
  free(s);
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo2(char *s, char *s2)
{
  TclTry(Tcl_VarEval(interp, s, s2, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo3(char *s, char *s2, char *s3)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo4(char *s, char *s2, char *s3, char *s4)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo5(char *s, char *s2, char *s3, char *s4, char *s5)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo6(char *s, char *s2, char *s3, char *s4, char *s5, char *s6)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, s6, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *TclDo7(char *s, char *s2, char *s3, char *s4, char *s5,
	     char *s6, char *s7)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, s6, s7, NULL));
  return TEMPCOPY(GET_INTERP_RESULT());
}    

#if DTCLDO
/* Debugging versions of TclDo() through TclDo7() */

/* Do a Tcl command */
char *dTclDo(char *s)
{
  s = STRDUP(s);
  TclTry(Tcl_Eval(interp, s));
  printf("%s: TclDo(%s) => %s\n", myoutputname, s, GET_INTERP_RESULT());
  free(s);
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo2(char *s, char *s2)
{
  TclTry(Tcl_VarEval(interp, s, s2, NULL));
  printf("%s: TclDo(%s%s) => %s\n", myoutputname, s, s2, GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo3(char *s, char *s2, char *s3)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, NULL));
  printf("%s: TclDo(%s%s%s) => %s\n", myoutputname,
	 s, s2, s3, GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo4(char *s, char *s2, char *s3, char *s4)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, NULL));
  printf("%s: TclDo(%s%s%s%s) => %s\n", myoutputname, s, s2, s3, s4,
	 GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo5(char *s, char *s2, char *s3, char *s4, char *s5)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, NULL));
  printf("%s: TclDo(%s%s%s%s%s) => %s\n", myoutputname, s, s2, s3, s4, s5,
	 GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo6(char *s, char *s2, char *s3, char *s4, char *s5, char *s6)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, s6, NULL));
  printf("%s: TclDo(%s%s%s%s%s%s) => %s\n", myoutputname,
	 s, s2, s3, s4, s5, s6, GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    

/* Do a Tcl command */
char *dTclDo7(char *s, char *s2, char *s3, char *s4, char *s5,
	      char *s6, char *s7)
{
  TclTry(Tcl_VarEval(interp, s, s2, s3, s4, s5, s6, s7, NULL));
  printf("%s: TclDo(%s%s%s%s%s%s%s) => %s\n", myoutputname,
	 s, s2, s3, s4, s5, s6, s7, GET_INTERP_RESULT());
  return TEMPCOPY(GET_INTERP_RESULT());
}    
#endif

/* clean out potentially special characters to prevent trouble with Tcl */
char *tclclean(char *s)
{
  char *t, *n, dirty;
  
  for (dirty=FALSE, t=n=TEMPCOPY(s); *t != '\0'; t++)
    if (!isalpha(*t) && !isdigit(*t) && !isspace(*t) &&
	!isin(*t, "$[]!@#%^&*()`';:,.<>/?-_=+|~\"")) {
      *t = '.';
      dirty = TRUE;
    }

#if DBG
  if (hasWindows && dirty) printf("dirty! %s => %s\n", s, n);
#endif

  return n;
}
    
/* replace { with \{ and } with \} */
char *braceclean(char *s)
{
  char *t, *n;
  
  n = t = markgarbage(salloc(strlen(s) * 2 * sizeof(char) + 1));
  while ((*t = *s++) != '\0')
    if (*t == '{' || *t == '}') {
      t[1] = t[0];
      t[0] = '\\';
      t += 2;
    } else t++;

  return n;
}

/* destuctively replace [ or ] with . */
char *destructivebracketclean(char *s)
{
  int i;

  for (i = 0; s[i] != '\0'; i++) if (s[i] == '[' || s[i] == ']') s[i] = '.';
  return s;
}
    
/* put a message in the talk window */
void talkm(char *s)
{
#if DBG
  if (debugprint && (hasWindows || SILENT)) puts(s);
#endif
  TclTry(Tcl_VarEval(interp, talkmO, tclclean(s), talkmC, NULL));
}

/* put a message in the talk window */
void talkm2(char *s, char *s2)
{
#if DBG
  if (debugprint && (hasWindows || SILENT)) printf("%s%s\n", s, s2);
#endif
  TclTry(Tcl_VarEval(interp, talkmO, tclclean(s), tclclean(s2),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm3(char *s, char *s2, char *s3)
{
#if DBG
  if (debugprint && (hasWindows || SILENT)) printf("%s%s%s\n", s, s2, s3);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm4(char *s, char *s2, char *s3, char *s4)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s\n", s, s2, s3, s4);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3), tclclean(s4),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm5(char *s, char *s2, char *s3, char *s4, char *s5)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s%s\n", s, s2, s3, s4, s5);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3),
		  tclclean(s4), tclclean(s5),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm6(char *s, char *s2, char *s3, char *s4, char *s5, char *s6)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s%s%s\n", s, s2, s3, s4, s5, s6);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3),
		  tclclean(s4), tclclean(s5), tclclean(s6),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm7(char *s, char *s2, char *s3, char *s4,
	    char *s5, char *s6, char *s7)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s%s%s%s\n", s, s2, s3, s4, s5, s6, s7);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3),
		  tclclean(s4), tclclean(s5), tclclean(s6), tclclean(s7),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm8(char *s, char *s2, char *s3, char *s4,
	    char *s5, char *s6, char *s7, char *s8)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s%s%s%s%s\n", s, s2, s3, s4, s5, s6, s7, s8);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3), tclclean(s4),
		  tclclean(s5), tclclean(s6), tclclean(s7), tclclean(s8),
		  talkmC, NULL));
}

/* put a message in the talk window */
void talkm9(char *s, char *s2, char *s3, char *s4,
	    char *s5, char *s6, char *s7, char *s8, char *s9)
{
#if DBG
  if (debugprint && (hasWindows || SILENT))
    printf("%s%s%s%s%s%s%s%s%s\n", s, s2, s3, s4, s5, s6, s7, s8, s9);
#endif
  TclTry(Tcl_VarEval(interp, talkmO,
		  tclclean(s), tclclean(s2), tclclean(s3), tclclean(s4),
		  tclclean(s5), tclclean(s6), tclclean(s7), tclclean(s8),
		  tclclean(s9),
		  talkmC, NULL));
}

/* C routine called by "command" (our homemade Tcl command) */
int cmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  if (argc == 1) return TCL_OK; /* null command */

  if (argc != 2) {
    SET_INTERP_RESULT("wrong # of arguments to `command'");
    return TCL_ERROR;
  }

/*  printf("command: %s\n", argv[1]);*/

  return docmd(argv[1]);
}


/* C routine called by "talk" (our homemade Tcl command) */
int talk(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  if (argc != 2) {
    SET_INTERP_RESULT("wrong # of arguments to `talk'");
    return TCL_ERROR;
  }

  if (*(argv[1]) != '/') return dosay(argv[1]);
  else return docmd(argv[1] + 1);
}
 
/* things that periodically need to be done */
void tasks(void)
{
  periodictablereannounce();
  checktablelisttimeouts();
  try_rejoin();
#ifndef SERVER
  UIupdate();
#if RANDOMPLAY
  {
    extern bool randomplay;
    extern char myname[];
    
    TclDo("gset showerrors 0");
    if (randomplay && (myturntobid() || myturntoplay())) {
      int i = 0;
      if (myturntobid()) makerandombid();
      while (myturntoplay() && randomplay && ++i < 100) makerandomplay();
    }
    TclDo("gset showerrors 1");
  }
#endif
#if 0
  {
    extern bool computerplay;
    extern char myname[];
    
    TclDo("gset showerrors 0");
    if (computerplay && (myturntobid() || myturntoplay())) {
      if (myturntobid()) makecomputerbid();
      while (myturntoplay() && computerplay) makecomputerplay();
    }
    TclDo("gset showerrors 1");
  }
#endif /* if 0 */
#endif /* ifndef SERVER */
}
