/* Copyright (c) 1996--1999 Geoff Pike. */
/* All rights reserved. */

/* Floater is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. */

/* This software is provided "as is" and comes with absolutely no */
/* warranties.  Geoff Pike is not liable for damages under any */
/* circumstances.  Support is not provided.  Use at your own risk. */

/* Personal, non-commercial use is allowed.  Attempting to make money */
/* from Floater or products or code derived from Floater is not allowed */
/* without prior written consent from Geoff Pike.  Anything that remotely */
/* involves commercialism, including (but not limited to) systems that */
/* show advertisements while being used and systems that collect */
/* information on users that is later sold or traded require prior */
/* written consent from Geoff Pike. */


int IMPtable[] =
    {0, 0, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4,
       5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 9, 9, 9,
       9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 11,
       11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
       13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14,
       14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
       14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
       15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
       16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
       17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18,
       18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18,
       18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19,
       19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 20, 20, 20,
       20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20,
       20, 20, 20, 20, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
       21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
       21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
       21, 21, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
       22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
       22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22, 22,
       22, 22, 22, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
       23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
       23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 23,
       23, 23};

static int IMP(int pointdiff)
{
  if (pointdiff >= 4000) return 24;
  else if (pointdiff <= -4000) return -24;
  else if (pointdiff < 0) return -IMPtable[-pointdiff / 10];
  else return IMPtable[pointdiff / 10];
}


/* size is the number of results; scores[] contain the results */
/* output is stored in fscores[] */
void IMPscore(int *scores, int size, float *fscores)
{
  int i, j, t;
  

  for (i=0; i<size; i++) fscores[i] = 0.0;

  for (i=0; i<size-1; i++)
    for (j=i+1; j<size; j++) {
      t = IMP(scores[i] - scores[j]);
      fscores[i] += t;
      fscores[j] -= t;
    }
      
  /* normalize by dividing by number of comparisons */
  if (size > 1) for (i=0; i<size; i++) fscores[i] /= (float)(size - 1);
}

/* size is the number of results, scores[] contain the results (sorted) */
/* output is stored in fscores[] */
void MPscore(int *scores, int size, float *fscores)
{
  int i, j, t;
  
  /* to first approximation, first guy gets size-1 matchpoints, etc. */
  for (i=0; i<size; i++) fscores[i] = size - i - 1;

  /* fixup for ties */
  for (i=0; i<size-1; ) {
    for (j=i+1; j < size && scores[i] == scores[j]; j++);
    /* i through j-1 are tied---give them all the average score of the group */
    t = (fscores[i] + fscores[j-1]) / 2.0;
    while (i < j) fscores[i++] = t;
  }
      
  /* convert to percentage */
  if (size > 1) for (i=0; i<size; i++) fscores[i] *= (100.0 / (size - 1));
  else fscores[0] = 50.0;
}

/* size is the number of results, scores[] contain the results */
/* output is stored in fscores[] */
void YUK3score(int *scores, int size, float *fscores)
{
  int i, j, t;
  return;

  for (i=0; i<size; i++) fscores[i] = 0.0;

  for (i=0; i<size-1; i++)
    for (j=i+1; j<size; j++) {
      t = IMP(scores[i] - scores[j]);
      fscores[i] += t;
      fscores[j] -= t;
    }
      
  /* normalize by dividing by number of comparisons */
  if (size > 1) for (i=0; i<size; i++) fscores[i] /= (float)(size - 1);
}




