static char qalter_rcsid[]="$Id: qalter.c,v 1.2 1998/10/26 19:24:09 green Exp $";

/*----------------------------------------------------
 * qalter.c Tom Green Thu Mar 31 15:16:42 EST 1994
 *
 * Copyright 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: qalter.c,v $
 * Revision 1.2  1998/10/26 19:24:09  green
 * use the DQS_EXIT macro to determine exit value of ancillaries
 *
 * Revision 1.1.1.1  1998/08/18 14:39:14  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.1.1.1  1997/04/10 15:10:35  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.7  1996/11/20 23:05:07  nrl
 * Several fixes submitted by or as a result of investigations by
 * Ron Lee, Bodo Bechenback, Guntram Wolski and Frank Dwyyer.
 *
 * Revision 3.6  1996/06/27  01:56:13  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.5  1996/03/22  04:21:45  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.4  1995/02/05  00:51:18  nrl
 * Changed meaning of "-clean" option to mean cleanout all
 * options potentially resettable by qalter. Added interactive
 * prompting.
 *
 * Revision 3.3  1995/02/01  23:17:52  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.2  1994/06/12  03:45:28  green
 * mods to dqs_send_receive_list() necessitated for the support of
 * moving dshd into dqs_execd required propagation to all ancillaries.
 * (eg: return value of dqs_send_receive_list() was modified...)
 *
 * Revision 3.1  1994/04/01  02:58:19  green
 * added "qalter" support
 *
 *--------------------------------------------------*/


#define MAINPROGRAM
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/************************************************************************/

main(argc, argv,envp)
     int argc;
     char **argv;
     char **envp;
     
{
  
  int              sfd;
  char             c;
  char             *tp;
  int              tpi;
  int              scriptline;
  string           str;
  FILE             *fp;
  dqs_list_type    *argv_list=(dqs_list_type *) NULL;
  dqs_list_type    *head=(dqs_list_type *) NULL;
  dqs_list_type    *resp=(dqs_list_type *) NULL;
  dqs_list_type    listel;
  dqs_list_type    *listel_ptr;
  dqs_list_type    *tmp_ptr=NULL;
  
  DENTER_MAIN((DQS_EVENT,"qalter"));   
  
  dqs_setup(QALTER,argv[0]);
  dqs_setup_sig_handlers();     
  
  bzero((char *)&listel,sizeof(listel));
  
  argv_list=dqs_args2list(++argv,argc);
  listel.job=dqs_parse_job(argv_list,envp);
  
  if (listel.job->script_file) 
    {
      fp=fopen(listel.job->script_file,"r");
      if (fp==NULL) 
	{
	  ERROR((DQS_EVENT,"DQS_ERROR_0553 error opening %s\n",listel.job->script_file));
	  exit(-1);
	}
    }
  else
    {
      fp=stdin;
    }
  
  if (!listel.job->directive_prefix)
    listel.job->directive_prefix=dqs_string_insert(NULL,"#$");
  
  bzero((char *)str,sizeof(str));
  scriptline=1;             
  if(fp == stdin)fprintf(stdout,"Enter Script, Precede DQS directives with \"%s\"terminate with ctl-D\n\nScript[%d] ",
			 listel.job->directive_prefix,scriptline);
  
  while (fgets(str,MAX_STRING_SIZE,fp))
    {
      listel.job->script_ptr=dqs_concat_buf(listel.job->script_ptr,str,&listel.job->script_size);
      if (strncmp(str,listel.job->directive_prefix,strlen(listel.job->directive_prefix)))
	{
	  if(fp ==stdin)fprintf(stdout,"Script[%d] ",scriptline);	  	  	
	  bzero((char *)str,sizeof(str));
	  continue;
	}
      tmp_ptr=dqs_string2list(str);
      tmp_ptr=dqs_delete_head(tmp_ptr);
      while (tmp_ptr) 
	{
	  argv_list=dqs_insert(DQS_STR0,TAIL,argv_list,tmp_ptr);
	  tmp_ptr=tmp_ptr->next;
	}
      scriptline++;
      
      bzero((char *)str,sizeof(str));
    }
  
  DPRINTF((DQS_EVENT,"\n=========================================\n"));
  DPRINTF((DQS_EVENT,"%s",listel.job->script_ptr));
  DPRINTF((DQS_EVENT,"\n=========================================\n"));
  
  tp=listel.job->script_ptr;
  tpi=listel.job->script_size;
  listel.job=dqs_parse_job(argv_list,envp);
  listel.job->script_ptr=tp;
  listel.job->script_size=tpi;
  
  if (!listel.job->script_file)
    {
      listel.job->script_file=dqs_string_insert(NULL,"STDIN");
    }
  
  if (!listel.job->job_name)
    {
      sprintf(str,"%s",listel.job->script_file);
      listel.job->job_name=dqs_string_insert(NULL,str);
    }
  
  if (listel.job->hold)
    listel.job->state=HELD;
  
  if (listel.job->verify)
    {
      dqs_show_job(listel.job);
      exit(0);
    }
  
  dqs_get_passwd_info(listel.job);
  
  listel.type=QALTER;
  listel.int0=QALTER;
  
  /* THIS IS A LAST MINUTE HACK!
     need to push default_q/default_group
  */
  
  if ((!listel.job->hard_resource_list)&&(!listel.job->soft_resource_list)
      && (!listel.job->hard_master_list)&&(!listel.job->soft_master_list)
      && (!listel.job->hard_queue_list)&&(!listel.job->soft_queue_list))
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0554 You must request some form or resources"));
      DEXITE;
      exit(-1);
    }
  
  if (!listel.job->job_identifier_list)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0555 You must request a jid"));
      DEXITE;
      exit(-1);
    }
  
  if (!listel.job->job_identifier_list->str0)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0556 You must request a jid"));
      DEXITE;
      exit(-1);
    }
  
  
  if (dqs_send_receive_list(me.default_cell,conf.qmaster_service,&listel,&resp)<0)
    {
      DEXITE;
      exit(DQS_EAGAIN);
    }
  
  dqs_show_acknak_list(resp);
  
  DEXIT;
  DQS_EXIT(resp->status);
  
} 

