/****************************************************************************
**
** Implementation of crossvc' diff tool.
**
** Based on code created by Bernd Gehrmann
** Copyright (C) 1999 Bernd Gehrmann
** bernd@physik.hu-berlin.de
**
**
**
** Copyright (C) 2000-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Wim Delvaux <wim.delvaux@chello.be>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef DIFFVIEW_H_20010626
#define DIFFVIEW_H_20010626

#include "config.h"

#include "qttableview.h"

#include <qvaluelist.h>

class DiffViewItem;
class DiffViewItemList;

class DiffView : public QtTableView
{
   Q_OBJECT
    
 friend class DiffViewItem; 
 public:
   enum DiffType { Change, Insert, Delete, Neutral, Unchanged };

   struct Diff {
      int pos;
      int len;
      DiffType type;
   };

   typedef QValueList<Diff> DiffList;

   DiffView(QWidget *parent=0, const char *name=0, WFlags f=0);
   ~DiffView();
    
   void setLineNumbers(bool On);
   void setMarkers(bool On);
   void setPartner(DiffView *other);

   void addLine(QString line, DiffList diffList, DiffType type, int no=-1);
   int count();

   void setCenterLine(int lineno);
   void setCenterOffset(int offset);
   void setInverted(int lineno, bool inverted);
   virtual int cellWidth(int col);
   virtual QSize sizeHint() const;
   virtual void paintCell(QPainter *p, int row, int col);
   void adjustScrollBarOffsets(int &from, int &to);

   void setFont(const QFont&);

   
 protected:
   void wheelEvent( QWheelEvent *e);
   void resizeEvent( QResizeEvent *e);
   void keyPressEvent ( QKeyEvent *);

 protected slots:
   void xPositionChanged(int val);
   void yPositionChanged(int val);
   void findPrevDiff ();
   void findNextDiff ();
  
 private:

   struct DiffInfo {
      QString txt;
      int fmSize;
      DiffType type;
   };
   typedef QValueList<DiffInfo> DiffInfoList;

   void recalcTableSize( DiffViewItem * It = 0 );
   void adjustLeftMargin();
   void adjustCellHeight();
   
   int findLine(int lineno);
   DiffViewItemList * items;
   bool linenos;
   bool marker;
   DiffView *partner;
   int TableSize;
   int m_ScrollBarMinPos;
   int m_ScrollBarMaxPos;

   int  m_markerTypeWidth;
   int  m_lineNbTypeWidth;

   bool m_blockScrollPos;
};

#endif  //DIFFVIEW_H_20010626

