// Copyright (c) 2004  Utrecht University (The Netherlands),
// ETH Zurich (Switzerland), Freie Universitaet Berlin (Germany),
// INRIA Sophia-Antipolis (France), Martin-Luther-University Halle-Wittenberg
// (Germany), Max-Planck-Institute Saarbruecken (Germany), RISC Linz (Austria),
// and Tel-Aviv University (Israel).  All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; version 2.1 of the License.
// See the file LICENSE.LGPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $URL: svn+ssh://scm.gforge.inria.fr/svn/cgal/branches/CGAL-3.2-branch/Installation/config/support/test_CORE.C $
// $Id: test_CORE.C 30642 2006-04-18 12:42:52Z lsaboret $
// 
//
// Author(s)     : various

// CGAL_CFG_NO_CORE.C
// ---------------------------------------------------------------------
// A short test program to evaluate a machine architecture.
// This program is used by cgal_configure.
// The following documentation will be pasted in the generated configfile.
// ---------------------------------------------------------------------

//| Tests if CORE is available.

#ifdef CGAL_USE_CGAL_CORE

// We haven't compiled it yet, so no way to test...
int main() { return 0; }

#else

#include <CORE/CORE.h>
#include <iostream>

int main()
{
  Expr x = 2, y = 3;
  std::cout << x << " * " << y  << " = " << x*y << std::endl;

  // CORE does not have VERSION macros yet (as of december 2005).
  std::cout << "version=unknown" << std::endl;

  return 0;
}

#endif // CGAL_USE_CGAL_CORE
