from Products.PortalTransforms.interfaces import itransform
from DocumentTemplate.DT_Util import html_quote

__revision__ = '$Id: text_pre_to_html.py 2543 2004-04-07 10:49:10Z tiran $'

class TextPreToHTML:
    """simple transform which wraps raw text into a <pre> tag"""

    __implements__ = itransform

    __name__ = "text-pre_to_html"
    inputs   = ('text/plain-pre',)
    output = "text/html"

    def __init__(self, name=None):
        self.config_metadata = {
            'inputs' : ('list', 'Inputs', 'Input(s) MIME type. Change with care.'),
            }
        if name:
            self.__name__ = name

    def name(self):
        return self.__name__

    def __getattr__(self, attr):
        if attr == 'inputs':
            return self.config['inputs']
        if attr == 'output':
            return self.config['output']
        raise AttributeError(attr)

    def convert(self, orig, data, **kwargs):
        data.setData('<pre class="data">%s</pre>' % orig)
        #data.setData(html_quote(orig.strip()).replace('\n', '<br />'))
        return data

def register():
    return TextPreToHTML()
