import simpletestrunner
import unittest
from Products.ZWiki.ZWikiWeb import *

class ZWikiWebsTests(simpletestrunner.TestCase):

    WIKI_TEMPLATES = (
#        ('basic',
#         (('FrontPage',           'structuredtext'),
#          ('HelpPage',            'structuredtext'),
#          ('JumpSearch',          'htmldtml'),
#          ('RecentChanges',       'htmldtml'),
#          ('RemoteWikiURL',       'structuredtext'),
#          ('SearchPage',          'htmldtml'),
#          ('StructuredTextRules', 'structuredtext'),
#          ('TextFormattingRules', 'structuredtext'),
#          ('UserOptions',         'structuredtextdtml'),
#          ('ZWiki',               'structuredtext'),
#          )),
#        ('classic',
#         (('FrontPage',           'classicwiki'),
#          ('HelpPage',            'classicwiki'),
#          ('RecentChanges',       'htmldtml'),
#          ('SearchPage',          'htmldtml'),
#          ('UserOptions',         'structuredtextdtml'),
#          ('ZWiki',               'classicwiki'),
#          )),
        ('zwikidotorg',
         (('AnnoyingQuote',       'structuredtext'),
          ('BookMarks',           'structuredtext'),
          ('FrontPage',           'structuredtext'),
          ('HelpPage',            'structuredtext'),
          ('HierarchalStructure', 'structuredtext'),
          ('JumpSearch',          'htmldtml'),
          ('RecentChanges',       'htmldtml'),
          ('RemoteWikiLinks',     'structuredtext'),
          ('RemoteWikiURL',       'structuredtext'),
          ('SearchPage',          'htmldtml'),
          ('StructuredTextRules', 'structuredtext'),
          ('TextFormattingRules', 'structuredtext'),
          ('TimeZone',            'structuredtext'),
          ('UserName',            'structuredtext'),
          ('UserOptions',         'structuredtextdtml'),
          ('WikiName',            'structuredtext'),
          ('WikiWikiWeb',         'structuredtext'),
          ('ZWiki',               'structuredtext'),
          ('ZopeDotOrg',          'structuredtext'),
          )),
        )                               # add parents

#    def setUp( self ):
#        pass

#    def tearDown( self ):
#        pass

# the form can't see listWiki in this test.. how come ?
#    def testAddZwikiWebForm(self):
#        "test the 'add zwiki web' form"
#
#        # the old zunit test simulated a user coming in through the web
#        # this should work now
#        zc = self.ZopeContext
#        root = zc.getPhysicalRoot()
#        PARENTS = [root]
#        manage_addZWikiWebForm(client=zc,
#                               REQUEST=zc.REQUEST,
#                               PARENTS=PARENTS)
#
#        # this one assumes direct zodb manipulation, bypassing zpublisher
#        # is it possible/meaningful to test the form in this case ?
#        # fake REQUEST because the form expects it
#        #req = {}
#        #wikitype = 'basic'
#        #req['new_id'] = wikitype
#        #req['new_title'] = wikitype + ' wiki'
#        #req['wiki_type'] = wikitype
#        ## req['SERVER_URL'] required
#        #self.root.manage_addProduct['ZWikiWebs'].ZWikiWebAddForm(
#        #    client=self.root,\
#        #    REQUEST=req)

    def SKIPtestWikiTemplates(self):
        """
        test the sample wikis' content.

        #>>> ZWiki.manage_addZWikiWeb('test')
        #>>> zc['test'].RecentChanges.page_type
        #'htmldtml'
        #>>> zc['test'].RecentChanges.parents
        #['HelpPage']
        """

        # how would this look as a doctest ? as follows:
        #(would it give us a global report of all errors more easily ? no)
        #
        #>>> DEFAULT_PAGES = (
        #...     ('basic', 
        #...     (('JumpSearch','htmldtml'),
        #...      ('SearchPage','spam'),
        #...      )),
        #...     )
        #>>> product=zc.manage_addProduct['ZWikiWebs']
        #>>> for wikitype, pages in DEFAULT_PAGES:
        #...     zc.REQUEST['new_id'] = wikitype
        #...     zc.REQUEST['new_title'] = wikitype + ' wiki'
        #...     zc.REQUEST['wiki_type'] = wikitype
        #...     product.ZWikiWebAdd(client=product,REQUEST=zc.REQUEST)
        #...     assert hasattr(zc, wikitype), \
        #               wikitype+" wiki was not created"
        #...     for page, type in pages:
        #...         assert hasattr(zc[wikitype],page), \
        #                   wikitype+"/"+page+" does not exist"
        #...         assert zc[wikitype][page].page_type == type, \
        #                   wikitype+"/"+page+"'s type is not "+type
        #...
        
        zc = self.ZopeContext

        # for each sample wikiweb,
        for wikitype, pages in self.WIKI_TEMPLATES:

            # create one
            # fake form input
            zc.REQUEST['new_id'] = wikitype
            zc.REQUEST['new_title'] = wikitype + ' wiki'
            zc.REQUEST['wiki_type'] = wikitype
            manage_addZWikiWeb(zc,
                               wikitype,
                               new_title=wikitype+' wiki',
                               wiki_type=wikitype,
                               REQUEST=zc.REQUEST)
#Traceback (most recent call last):
#  File "/var/lib/zope/Products/ZWiki/tests/testZWikiWeb.py", line 124, in testWikiTemplates
#  File "/var/lib/zope/Products/ZWiki/ZWikiWeb.py", line 27, in manage_addZWikiWeb
#    self.addZWikiWebFromFs(new_id,new_title,wiki_type,REQUEST)
#AttributeError: listFsWikis
            
            # verify that it exists and that all pages listed above
            # are present and correct
            assert hasattr(zc, wikitype), \
                   wikitype+" wiki was not created"
            for page, type in pages:
                assert hasattr(zc[wikitype],page), \
                       wikitype+"/"+page+" does not exist"
                assert zc[wikitype][page].page_type == type, \
                       wikitype+"/"+page+"'s type is not "+type


            # also:
            # XXX check dtml methods

            # XXX check for extraneous stuff that's not listed above

            # XXX other stuff on http://zwiki.org/ZWikiWebs checklist



#def test_suite():
#    suite = simpletestrunner.TestSuite()
#    suite.addTest(simpletestrunner.makeSuite(ZWikiWebsTests))
#    return suite
def test_suite():
    ts = (
        simpletestrunner.makeSuite(ZWikiWebsTests),
    )
    return simpletestrunner.TestSuite(ts)

def run():
    unittest.TextTestRunner().run(test_suite())

if __name__ == '__main__':
    run()
