## Script (Python) "plonearticle_toggle_lock"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=
##title=Toggle Article Lock

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)

can_toggle = context.canToggleLock()
locked = context.isLocked()

if can_toggle and not locked:
  action = context.lock(1)
  message = context.translate(
              domain='plonearticle', msgid='message_article_locked',
              mapping={},
              default = 'Article has been locked.'
            )

if can_toggle and locked:
  action = context.lock(0)
  message = context.translate(
              domain='plonearticle', msgid='message_article_unlocked',
              mapping={},
              default = 'Article has been unlocked.'
            )

msg = 'portal_status_message=' + message

return context.REQUEST.RESPONSE.redirect('%s/%s?%s' % ( context.absolute_url()
                                                      , context.getTypeInfo().getActionById('view')
                                                      , msg ))