##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################

import unittest

from Products.ParsedXML import DOM
from Products.ParsedXML.DOM import ExpatBuilder
from Products.ParsedXML.StrIO import StringIO
from domapi import DOMImplementationTestSuite

def DOMParseString(xml):
    file = StringIO(xml)
    return ExpatBuilder.parse(file)

def get_element_ids(node):
    result = []
    if node.nodeType == node.ELEMENT_NODE:
        result.append(node.elementId)
    for child in node.childNodes:
        result.extend(get_element_ids(child))
    return result

def check_unique_ids(node):
    element_ids = get_element_ids(node)
    element_ids.sort()
    last = element_ids[0]
    for element_id in element_ids[1:]:
        assert last != element_id,\
               'Found at least one double element_id: %s' % element_id
        last = element_id

class ElementIdTestCase(unittest.TestCase):
    def setUp(self):
        self.doc = DOMParseString('''
        <doc>
        <p>Test</p>
        <p>Another test</p>
        <p>Foo<sub/><sub2>hey</sub2></p>
        </doc>
        ''')

    def checkElementIdsAfterParse(self):
        element_ids = get_element_ids(self.doc)
        for i in xrange(len(element_ids)):
            assert i == element_ids[i]
            
    def checkElementIdsAfterAppend(self):
        element = self.doc.createElement('foo')
        self.doc.documentElement.appendChild(element)
        check_unique_ids(self.doc)

    def checkElementIdsAfterAppend2(self):
        element = self.doc.createElement('foo')
        self.doc.documentElement.insertBefore(
            element, self.doc.documentElement.childNodes[0])
        check_unique_ids(self.doc)

    def checkCloneNodeShallow(self):
        cloned = self.doc.documentElement.cloneNode(0)
        self.doc.documentElement.appendChild(cloned)
        check_unique_ids(self.doc)

    def checkCloneNodeDeep(self):
        cloned = self.doc.documentElement.cloneNode(1)
        self.doc.documentElement.appendChild(cloned)
        check_unique_ids(self.doc)

    def checkImportNodeShallow(self):
        otherdoc = DOMParseString('''
        <hey><some></some></hey>
        ''')
        imported = self.doc.importNode(
            otherdoc.documentElement, 0)
        self.doc.documentElement.appendChild(imported)
        check_unique_ids(self.doc)
        
    def checkImportNodeDeep(self):
        otherdoc = DOMParseString('''
        <hey><some></some></hey>
        ''')
        imported = self.doc.importNode(
            otherdoc.documentElement, 1)
        self.doc.documentElement.appendChild(imported)
        check_unique_ids(self.doc)
        
    
def test_suite():
    suite = unittest.TestSuite()
    suite.addTest(unittest.makeSuite(ElementIdTestCase, 'check'))
    return suite

def main():
    unittest.TextTestRunner().run(test_suite())

if __name__ == "__main__":
    main()
