__doc__='''Transaction  product implementation'''

__version__='$Revision: 1.1 $'[11:-2]

from Globals import HTMLFile, MessageDialog, Persistent, DateTime
import OFS.SimpleItem, Acquisition, AccessControl.Role
import OFS.Folder
import time, string

class Transaction(
    OFS.SimpleItem.Item,
    Persistent,
    Acquisition.Implicit,
    AccessControl.Role.RoleManager,
    ):

    """ A Transaction """

    # Specify a name for the item type:
    meta_type='Transaction'

    # Specify a relative URL for the icon used to display icons:
    icon='misc_/EMarket/marketItem'

    # Specify definitions for tabs:
    manage_options=(
	{'label':'Properties', 'action':'manage_main'},
	{'label':'View',       'action':''},
	{'label':'Security',   'action':'manage_access'},
	)
 
    # Specify how individual operations add up to "permissions":
    __ac_permissions__=(
	('View management screens', ('manage_tabs','manage_main')),
	('Change permissions',      ('manage_access',)           ),
	('View',                    ('',)      ),
	)

    # Setup default class values....
    
    id = 'default'
    buyerID = None
    sellerID = None
    sku = None
    quantity = None
    offer = None
    addTime = DateTime('est')

    def __init__(self, id, sellerID=None, buyerID=None, sku=None, quantity=0, offer=0):
        """
        Create a new complete transaction instance.
        """
        #
	self.id=id
        self.buyerID = buyerID
        self.sellerID = sellerID
        self.sku=sku
        self.quantity=quantity
        self.offer = offer
        self.addTime = DateTime('est')  # yes.. we need to do something with timezones!

    # Provide interface for changing properties:


    manage_main=HTMLFile('transactionEdit', globals())

    def manage_edit(self, REQUEST=None, origURL=None):
        """
        Edit the transaction...
        """

        result = "OK!"

        self.buyerID = REQUEST.get('buyerID',self.buyerID)
        self.sellerID = REQUEST.get('sellerID',self.sellerID)
        self.sku = REQUEST.get('sku',self.sku)
        self.quantity = REQUEST.get('quantity',self.quantity)
        self.offer = REQUEST.get('offer',self.offer)
        
        if REQUEST is not None:
            if origURL is None:
                origURL = './manage_main'

            result = MessageDialog(
                title='Edited',
                message='<strong>%s</strong> has been edited.' % self.id,
                action = origURL
                )
                        
        return result

