__doc__='''MarketItem product implementation'''

__version__='$Revision: 1.5 $'[11:-2]

from Globals import HTMLFile, MessageDialog, Persistent, DateTime
from Products import ZPatterns
import OFS.Folder
import time, string

addMarketItemForm=HTMLFile('marketItemAdd',globals())

class MarketItemManager(ZPatterns.Specialists.Specialist):
    """A Market Item Manager"""

    # Specify a name for the item type:

    meta_type='MarketItemManager'

    def initMarketItemProperties(self, theMarketItem, REQUEST=None):
        """ setup market item properties...."""

        if REQUEST is None:
            REQUEST = {}
            
        theMarketItem.name = REQUEST.get('name','no name')
        theMarketItem.price = REQUEST.get('price',0)
        theMarketItem.available = REQUEST.get('available',1)
        theMarketItem.description = REQUEST.get('description','no description')


    def calcPrice(self, theBasketItem):
        """ Calculate the price of a single item with the given optionDict....

        This is admittedly a kludge... but we needed something quick and easy.
        The option dict is a dict of optional features of MarketItems. These
        features might affect the price. The "price" attribute of a MarketItem
        is a 'base' price. If there is an optional feature, say color we add a
        property to the market item called 'colors' and list the possibility.
        If this property affects the price """

        #
        theItem = self.getItem( theBasketItem.marketItemId )
        if theItem:
            return theItem.price
        else:
            return 0.0

class Dummy:

    def checkOffer(self, shopper, offer, quantity, firmOffer=None):
        """ check to see if an offer is valid...

            returns  (errorStatus, statusCode)

            where:  errorStatus = 0 OK, 1 fatal error

                    statusCodes
                       1  attempt to drop quantity
                       2  not enough product remaining
                       3  attempt to drop offer
                       4  offer is below minPrice, or it's an auction
            

        """

        NO_ERROR, FATAL_ERROR = 0,1
        NO_STATUS, DROP_QUANTITY, NO_PRODUCT, DROP_OFFER, BELOW_MIN_OR_AUCTION = range(5)
        
        fatalErr = NO_ERROR
        statusCode = NO_STATUS
        basketKey = self.id + '()'
        
        if self.buyers.has_key(shopper.id) and (shopper.basket.items.has_key(basketKey) or
                                                shopper.pendingBasket.items.has_key(basketKey)):
            #
            #  This is an updated offer....
            #
            if shopper.basket.items.has_key(basketKey):
                item = shopper.basket.items[basketKey]
            else:
                item = shopper.pendingBasket.items[basketKey]

            if item.counterQuantity is not None:  # quantity can drop if it is countered with lower..
                oldQuantity = min([item.quantity,item.counterQuantity])
            else:
                oldQuantity = item.quantity

            if item.counterOffer is not None:     # price can drop if it is countered with lower...
                oldPrice = min([item.offer, item.counterOffer])
            else:
                oldPrice = item.offer

            if (quantity >= oldQuantity) and \
               (quantity <= self.quantityAvailable) and \
               (offer >= oldPrice):
                pass
            elif firmOffer is None:
                pass
            else:
                if quantity < oldQuantity:
                    statusCode = DROP_QUANTITY

                if quantity > self.quantityAvailable:
                    statusCode = NO_PRODUCT
                    
                if offer < oldPrice:
                    statusCode = DROP_OFFER

                fatalErr = FATAL_ERROR

        else:
            
            if quantity <= self.quantityAvailable:
                if offer < self.minPrice or self.enableAuction:
                    statusCode = BELOW_MIN_OR_AUCTION
            else:
                statusCode = NO_PRODUCT
                fatalErr = FATAL_ERROR
                
        if not fatalErr:
            if firmOffer is not None:
                b = self.buyers
                b[shopper.id] = 1
                self.buyers = b

        return fatalErr, statusCode


    def isAvailable(self):
        """ Is this item avaialble for purchase?  If this returns false,
            the item should not appear in any lists of items presented
            to the customer.  This means catalog search need to check this."""
        if self.shopperID:
            if self.expired(): return 0
        if not self.enabled: return 0
        if (self.quantityAvailable<>None) and self.quantityAvailable<=0:
          return 0
        return 1

    def expired(self):
        """ is this item expired? """

        isExpired = 0
        
        if self.offersAccepted() or self.enableAuction:
            isExpired = DateTime().greaterThan(self.closeTime)

        return isExpired


