##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Preprint reference main class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.CMFCore.utils import getToolByName
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, SelectionWidget
from Products.Archetypes.public import DisplayList, registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema


SourceSchema = Schema((
    StringField('preprint_server',
        searchable=1,
        required=0,
        vocabulary="PreprintServers",
        widget=SelectionWidget(label="Preprint server",
                label_msgid="label_source_preprint_server",
                description="If the preprint is available from one of the following preprint servers, you can indicate that here. Contact the site's admin if you want a server to be added to the list.",
                description_msgid="help_source_preprint_server",
                i18n_domain="plone",),
                ),
    ))

PreprintSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
                 SourceSchema + TrailingSchema


class PreprintReference(BaseEntry):
    """ content type to make reference to a preprint
    """
    security = ClassSecurityInfo()
    archetype_name = "Preprint Reference"
    source_fields = ('preprint_server', )

    schema = PreprintSchema
    
    security.declareProtected(View, 'PreprintServers')
    def PreprintServers(self):
        """ return a display list of the preprint servers as
            defined in the tool properties.
        """
        bib_tool = getToolByName(self, 'portal_bibliography')
        servers = bib_tool.getProperty('preprint_servers', [])
        values = []
        for server in servers:
            if ':' in server:
                text = server.split(':')[0]
            else:
                text = server
            values.append([server, text])
        return DisplayList(tuple(values))
    
    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default preprint server source format
        """
        try:
            return self.PreprintSource()
        except AttributeError:
            source = "Preprint"
            preprint_server = self.getPreprint_server()
            if preprint_server:
                if ':' in preprint_server:
                    text, link = preprint_server.split(':', 1)
                    if text != 'None':
                        source += ' at <a href="%s">%s</a>' % (link, text)
                else:
                    source += " at %s" % preprint_server
            return source + "."

registerType(PreprintReference)
