(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(** Interface to include Zoggy in other apps. *)

(** This class takes a file name 
   and create an object which represents a zoggy app. The class
   has some methods, in order to be used by Cameleon.*)
class zoggy_app : string -> 
  object
    (** The box, to pack it in something. *)
    method box : GPack.box

    (** The method to call to close the app.*)
    method close : unit

    (** The method to call to reload the information from the file.*)
    method reload : unit

    (** The method to call to save the information in the file.*)
    method save : unit

    (** Indicate whether the description has changed, 
       i.e. if the file must be saved. *)
    method changed : bool

    (** To perform some initializations with a window. *)
    method init_window : GWindow.window -> unit
  end
