(***********************************************************************)
(*                               Zoggy                                 *)
(*                                                                     *)
(*            Maxence Guesdon, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  All rights reserved.  This file is distributed    *)
(*  under the terms of the Q Public License version 1.0.               *)
(*                                                                     *)
(***********************************************************************)

(** Analysis of command line arguments. *)

(** The report file. *)
let file = ref None

let options  = ref ([] : (string * Arg.spec * string) list)

(** Parse the command line and fill the arguments variables. *)
let parse () =
  try
    let _ = Arg.parse !options
	(fun s -> 
	  match !file with
	    None -> file := Some s;
	  | Some f -> raise (Failure (Zog_messages.usage^Zog_messages.options_are))
	)
	(Zog_messages.usage^Zog_messages.options_are)
    in
    ()
  with
    Failure s ->
      prerr_endline s ;
      exit 1
