/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.AdapterDescriptor;
import IceGrid.DbEnvDescriptor;
import IceGridGUI.Application.AdapterEditor;
import IceGridGUI.Application.Communicator;
import IceGridGUI.Application.DescriptorHolder;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.Service;
import IceGridGUI.Application.ServiceTemplate;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class Adapter
extends TreeNode
implements DescriptorHolder {
    private final boolean _ephemeral;
    private final Map _parentProperties;
    private AdapterDescriptor _descriptor;
    private AdapterEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static AdapterDescriptor copyDescriptor(AdapterDescriptor d) {
        return (AdapterDescriptor)d.clone();
    }

    public static List copyDescriptors(List descriptors) {
        LinkedList<AdapterDescriptor> copy = new LinkedList<AdapterDescriptor>();
        Iterator p = descriptors.iterator();
        while (p.hasNext()) {
            copy.add(Adapter.copyDescriptor((AdapterDescriptor)p.next()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = !this._ephemeral;
        Object clipboard = this.getCoordinator().getClipboard();
        actions[14] = clipboard != null && (clipboard instanceof AdapterCopy || clipboard instanceof DbEnvDescriptor);
        actions[15] = true;
        if (!this._ephemeral) {
            boolean[] parentActions = ((TreeNode)this._parent).getAvailableActions();
            actions[16] = parentActions[16];
            actions[17] = parentActions[17];
        }
        return actions;
    }

    public void copy() {
        AdapterCopy copy = new AdapterCopy();
        copy.descriptor = Adapter.copyDescriptor(this._descriptor);
        copy.parentProperties = ((Communicator)this._parent).propertiesMap();
        this.getCoordinator().setClipboard(copy);
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/adapter_inactive.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (AdapterEditor)this.getRoot().getEditor(AdapterEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new AdapterEditor();
    }

    public void destroy() {
        this.removeProperty(this._descriptor.name + ".Endpoints");
        this.removeProperty(this._descriptor.name + ".PublishedEndpoints");
        ((Communicator)this._parent).getAdapters().destroyChild(this);
    }

    Object getDescriptor() {
        return this._descriptor;
    }

    public Object saveDescriptor() {
        return Adapter.copyDescriptor(this._descriptor);
    }

    public void restoreDescriptor(Object savedDescriptor) {
        AdapterDescriptor ad = (AdapterDescriptor)savedDescriptor;
        this._descriptor.name = ad.name;
        this._descriptor.id = ad.id;
        this._descriptor.replicaGroupId = ad.replicaGroupId;
        this._descriptor.description = ad.description;
        this._descriptor.registerProcess = ad.registerProcess;
        this._descriptor.serverLifetime = ad.serverLifetime;
        this._descriptor.objects = ad.objects;
    }

    Adapter(Communicator parent, String adapterName, AdapterDescriptor descriptor, Map parentProperties, boolean ephemeral) {
        super(parent, adapterName);
        this._descriptor = descriptor;
        this._ephemeral = ephemeral;
        this._parentProperties = parentProperties;
    }

    void write(XMLWriter writer) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    void write(XMLWriter writer, List properties) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(Adapter.createAttribute("name", this._descriptor.name));
            String oaPrefix = this._descriptor.name + ".";
            attributes.add(Adapter.createAttribute("endpoints", this.getProperty(oaPrefix + "Endpoints")));
            attributes.add(Adapter.createAttribute("id", this._descriptor.id));
            if (this._descriptor.registerProcess) {
                attributes.add(Adapter.createAttribute("register-process", "true"));
            }
            if (this._descriptor.replicaGroupId.length() > 0) {
                attributes.add(Adapter.createAttribute("replica-group", this._descriptor.replicaGroupId));
            }
            if (this._descriptor.priority != null && this._descriptor.priority.length() > 0) {
                attributes.add(Adapter.createAttribute("priority", this._descriptor.priority));
            }
            if (!this._descriptor.serverLifetime) {
                attributes.add(Adapter.createAttribute("server-lifetime", "false"));
            }
            if (this._descriptor.description.length() == 0 && this._descriptor.objects.isEmpty() && this._descriptor.allocatables.isEmpty()) {
                writer.writeElement("adapter", attributes);
            } else {
                writer.writeStartTag("adapter", attributes);
                if (this._descriptor.description.length() > 0) {
                    writer.writeElement("description", this._descriptor.description);
                }
                Adapter.writeObjects("object", writer, this._descriptor.objects, properties);
                Adapter.writeObjects("allocatable", writer, this._descriptor.allocatables, properties);
                writer.writeEndTag("adapter");
            }
        }
    }

    String getProperty(String property) {
        if (this._parentProperties != null) {
            return (String)this._parentProperties.get(property);
        }
        return ((Communicator)this._parent).getProperty(property);
    }

    String lookupPropertyValue(String val) {
        if (this._parentProperties != null) {
            Iterator p = this._parentProperties.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                if (!entry.getValue().equals(val)) continue;
                return (String)entry.getKey();
            }
            return "";
        }
        return ((Communicator)this._parent).lookupPropertyValue(val);
    }

    void setProperty(String property, String newValue) {
        ((Communicator)this._parent).setProperty(property, newValue);
    }

    void removeProperty(String property) {
        ((Communicator)this._parent).removeProperty(property);
    }

    String getDefaultAdapterId() {
        return this.getDefaultAdapterId(this._id);
    }

    String getDefaultAdapterId(String name) {
        return this._parent instanceof Service || this._parent instanceof ServiceTemplate ? "${server}.${service}." + name : "${server}." + name;
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    static {
        $assertionsDisabled = !Adapter.class.desiredAssertionStatus();
    }

    static class AdapterCopy {
        AdapterDescriptor descriptor;
        Map parentProperties;

        AdapterCopy() {
        }
    }
}

