/* ipinput.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "ipinput.hh"

ipinput::ipinput (QWidget * parent):QFrame (parent)
{
  v = new QIntValidator (0, 10, this);
  setFrameStyle (QFrame::Panel | QFrame::Sunken);
  setBackgroundColor (QColor ("white"));
  setLineWidth (2);
  box = new QHBoxLayout (this);
  box->setMargin (2);
  ed1 = new QLineEdit (this);
  ed1->setFrameStyle (QFrame::NoFrame);
  ed1->setFixedSize (27, 16);
  box->addWidget (ed1);
  lb1 = new QLabel (this);
  lb1->setText (".");
  lb1->setFixedSize (5, 16);
  lb1->setBackgroundColor (QColor ("white"));
  box->addWidget (lb1);
  ed2 = new QLineEdit (this);
  ed2->setFixedSize (27, 16);
  ed2->setFrameStyle (QFrame::NoFrame);
  box->addWidget (ed2);
  lb2 = new QLabel (this);
  lb2->setText (".");
  lb2->setFixedSize (5, 16);
  lb2->setBackgroundColor (QColor ("white"));
  box->addWidget (lb2);
  ed3 = new QLineEdit (this);
  ed3->setFixedSize (27, 16);
  ed3->setFrameStyle (QFrame::NoFrame);
  box->addWidget (ed3);
  lb3 = new QLabel (this);
  lb3->setText (".");
  lb3->setFixedSize (5, 16);
  lb3->setBackgroundColor (QColor ("white"));
  box->addWidget (lb3);
  ed4 = new QLineEdit (this);
  ed4->setFixedSize (27, 16);
  ed4->setFrameStyle (QFrame::NoFrame);
  box->addWidget (ed4);
  setFixedSize (128, 20);
  ed1->setValidator (v);
  ed2->setValidator (v);
  ed3->setValidator (v);
  ed4->setValidator (v);
  ed1->setMaxLength (3);
  ed2->setMaxLength (3);
  ed3->setMaxLength (3);
  ed4->setMaxLength (3);
  connect (ed1, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEd1Change (const QString &)));
  connect (ed2, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEd2Change (const QString &)));
  connect (ed3, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEd3Change (const QString &)));
  connect (ed4, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotEd4Change (const QString &)));
  ed1->setFocus ();
}

ipinput::~ipinput ()
{
}

bool
ipinput::setAddress (const QString addr)
{
  QStringList l = QStringList::split (".", addr);
  if (l.count () != 4)
    return false;
  for (unsigned int i = 0; i < l.count (); i++)
    if (l[i].toInt () < 0 || l[i].toInt () > 255)
      return false;
  ed1->setText (l[0]);
  ed2->setText (l[1]);
  ed3->setText (l[2]);
  ed4->setText (l[3]);
  return true;
}

QString
ipinput::address ()
{
  if (ed1->text ().isNull ())
    return NULL;
  if (ed2->text ().isNull ())
    return NULL;
  if (ed3->text ().isNull ())
    return NULL;
  if (ed4->text ().isNull ())
    return NULL;
  QString p = ".";
  return (ed1->text () + p + ed2->text () + p + ed3->text () + p +
	  ed4->text ());
}

void
ipinput::clear ()
{
  ed1->clear ();
  ed2->clear ();
  ed3->clear ();
  ed4->clear ();
}

void
ipinput::slotEd1Change (const QString & s)
{
  if (s.length () == 3)
    ed2->setFocus ();
  emit textChanged (address ());
}

void
ipinput::slotEd2Change (const QString & s)
{
  int i;
  if ((i = s.length ()) == 3)
    ed3->setFocus ();
  else if (i == 0)
    ed1->setFocus ();
  emit textChanged (address ());
}

void
ipinput::slotEd3Change (const QString & s)
{
  int i;
  if ((i = s.length ()) == 3)
    ed4->setFocus ();
  else if (i == 0)
    ed2->setFocus ();
  emit textChanged (address ());
}

void
ipinput::slotEd4Change (const QString & s)
{
  if (s.length () == 0)
    ed3->setFocus ();
  emit textChanged (address ());
}
