/* cfg_tf.hh
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CFG_TF_H
#define CFG_TF_H

#include <qwidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qdatetimeedit.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qcheckbox.h>
#include <qmessagebox.h>
#include <qvalidator.h>
#include <qregexp.h>
#include "zbuser.hh"
#include "zbconfig.hh"

class cfg_tf:public QWidget
{
Q_OBJECT public:
    cfg_tf (QWidget * parent, tarifList * tf, groupList * gList, bool write,
	    QString * cur);
   ~cfg_tf ();
  void setEnabled (bool write);
private:
  void initView ();
  void initData ();
  void clear ();
  void happyOff ();
  void happyOn (int i);
private:
    bool CfgWrite;
  tarifList *tarife;
  groupList *groups;
  QString *curency;
  int currentItem;
  QGridLayout *tfGrid;
  // box 1
  QListBox *tfList;
  QWidget *listWidget;
  QVBoxLayout *listBox;
  // box 2
  QGroupBox *tfGrp1;
  QWidget *tfGrp1Widget;
  QGridLayout *tfGrid1;

  QRegExp rxFloat;
  QRegExpValidator *vlFloat;

  QLabel *tfLbName;
  QLineEdit *tfEdName;

  QWidget *wgCur;
  QLabel *tfLbCur;
  QComboBox *tfEdCur;

  QLabel *tfLbFullHour;
  QLineEdit *tfEdFullHour;
  QLabel *tfCur1;

  QLabel *tfLbHalfHour;
  QLineEdit *tfEdHalfHour;
  QLabel *tfCur2;

  QLabel *tfLbQuartHour;
  QLineEdit *tfEdQuartHour;
  QLabel *tfCur3;

  QLabel *tfLbFullDay;
  QLineEdit *tfEdFullDay;
  QLabel *tfCur4;

  QLabel *tfLbHalfDay;
  QLineEdit *tfEdHalfDay;
  QLabel *tfCur5;
  QSpacerItem *tfSpacer1;

  QLabel *tfLbFullDayHours;
  QSpinBox *tfEdFullDayHours;
  QLabel *tfLbFullDayHours2;

  QLabel *tfLbHalfDayHours;
  QSpinBox *tfEdHalfDayHours;
  QLabel *tfLbHalfDayHours2;

  QLabel *tfLbHappyEnabled;
  QCheckBox *tfEdHappyEnabled;

  QLabel *tfLbTax;
  QLineEdit *tfEdTax;
  QLabel *tfTaxCur;

  QLabel *tfLbVorlauf;
  QSpinBox *tfEdVorlauf;
  QLabel *tfVorlCur;
  // box 3
  QGroupBox *tfGrp2;
  QWidget *tfGrp2Widget;
  QGridLayout *tfGrid2;
  QLabel *tfLbHappyFullHour;
  QLineEdit *tfEdHappyFullHour;
  QLabel *tfCur6;
  QLabel *tfLbHappyHalfHour;
  QLineEdit *tfEdHappyHalfHour;
  QLabel *tfCur7;
  QLabel *tfLbHappyQuartHour;
  QLineEdit *tfEdHappyQuartHour;
  QLabel *tfCur8;
  QLabel *tfLbHappyStart;
  QTimeEdit *tfEdHappyStart;
  QLabel *tfLbHappyStop;
  QTimeEdit *tfEdHappyStop;
  QSpacerItem *tfSpacer2;
  QCheckBox *tfDayMo;
  QCheckBox *tfDayDi;
  QCheckBox *tfDayMi;
  QCheckBox *tfDayDo;
  QCheckBox *tfDayFr;
  QCheckBox *tfDaySa;
  QCheckBox *tfDaySo;
  // buttons
  QHBoxLayout *tfBtnBox;
  QPushButton *tfBtnNew;
  QPushButton *tfBtnSave;
  QSpacerItem *tfBtnSpace;
  QPushButton *tfBtnDel;
  // spacer
  QSpacerItem *tfSpacer3;
  QSpacerItem *tfSpacer4;

  private slots:void slotTfListSelected (int i);
  void slotTfBtnNew ();
  void slotTfBtnSave ();
  void slotTfBtnDel ();
  void slotCurChanged (int i);
  void slotCurChanged (const QString & s);
  void slotName (const QString & s);
  void slotFullHour (const QString & s);
  void slotHalfHour (const QString & s);
  void slotQuartHour (const QString & s);
  void slotFullDay (const QString & s);
  void slotHalfDay (const QString & s);
  void slotFullDayHours (int i);
  void slotHalfDayHours (int i);
  void slotHappyEnabled (bool on);
  void slotTax (const QString & s);
  void slotVorlauf (int i);
  void slotHappyFullHour (const QString & s);
  void slotHappyHalfHour (const QString & s);
  void slotHappyQuartHour (const QString & s);
  void slotHappyStart (const QTime & t);
  void slotHappyStop (const QTime & t);
  void slotDayMo (bool on);
  void slotDayDi (bool on);
  void slotDayMi (bool on);
  void slotDayDo (bool on);
  void slotDayFr (bool on);
  void slotDaySa (bool on);
  void slotDaySo (bool on);
    signals:void configChanged ();
  void curencyChanged (QString);
};

#endif
