/* cfg_prod.cc
 * (c) 2002 Christian Tpp <c.toepp@gmx.de>
 */

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "cfg_prod.hh"
#include "printprice.hh"

cfg_prod::cfg_prod (QWidget * parent, productList * pList, printInfo * prints, bool write, QString * cur):QWidget
  (parent)
{
  pInfo = prints;
  CfgWrite = write;
  prods = pList;
  curency = cur;
  initView ();
  initData ();
  clear ();
}

cfg_prod::~cfg_prod ()
{
}

void
cfg_prod::initView ()
{
  prodGrid = new QGridLayout (this, 2, 3, 3, 3);
  // liste
  prodList = new QListBox (this);
  connect (prodList, SIGNAL (highlighted (int)), this,
	   SLOT (slotListSelected (int)));
  prodGrid->addMultiCellWidget (prodList, 0, 1, 0, 0);
  //groupbox
  adiGroup =
    new QGroupBox (100, Qt::Vertical, tr ("Additional Items"), this,
		   "products");
  adiWidget = new QWidget (adiGroup);
  adiGrid = new QGridLayout (adiWidget, 5, 3, 3, 3);
  // name
  lbName = new QLabel (adiWidget);
  lbName->setText (tr ("Name"));
  edName = new QLineEdit (adiWidget);
  edName->setEnabled (CfgWrite);
  connect (edName, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotName (const QString &)));
  adiGrid->addWidget (lbName, 0, 0);
  adiGrid->addMultiCellWidget (edName, 0, 0, 1, 2);
  // price
  lbPrice = new QLabel (adiWidget);
  lbPrice->setText (tr ("Price"));
  edPrice = new QLineEdit (adiWidget);
  edPrice->setEnabled (CfgWrite);
  connect (edPrice, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotName (const QString &)));
  lbCur1 = new QLabel (adiWidget);
  lbCur1->setText (*curency);
  adiGrid->addWidget (lbPrice, 1, 0);
  adiGrid->addWidget (edPrice, 1, 1);
  adiGrid->addWidget (lbCur1, 1, 2);
  // tax
  lbTax = new QLabel (adiWidget);
  lbTax->setText (tr ("Tax"));
  edTax = new QLineEdit (adiWidget);
  edTax->setEnabled (CfgWrite);
  connect (edTax, SIGNAL (textChanged (const QString &)), this,
	   SLOT (slotTax (const QString &)));
  lbCur2 = new QLabel (adiWidget);
  lbCur2->setText ("%");
  adiGrid->addWidget (lbTax, 2, 0);
  adiGrid->addWidget (edTax, 2, 1);
  adiGrid->addWidget (lbCur2, 2, 2);
  // description
  lbDesc = new QLabel (adiWidget);
  lbDesc->setText (tr ("Description"));
  spDesc =
    new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  edDesc = new QMultiLineEdit (adiWidget);
  adiGrid->addWidget (lbDesc, 3, 0);
  adiGrid->addItem (spDesc, 4, 0);
  adiGrid->addMultiCellWidget (edDesc, 3, 4, 1, 2);
  // groupbox end
  prodGrid->addWidget (adiGroup, 0, 1);
  // buttons
  btnWidget = new QWidget (this);
  btnBox = new QHBoxLayout (btnWidget);
  btnNew = new QPushButton (btnWidget);
  btnNew->setText (tr ("New"));
  btnNew->setEnabled (CfgWrite);
  connect (btnNew, SIGNAL (clicked ()), this, SLOT (slotBtnNew ()));
  btnBox->addWidget (btnNew);
  btnSave = new QPushButton (btnWidget);
  btnSave->setText (tr ("Save"));
  btnSave->setEnabled (false);
  connect (btnSave, SIGNAL (clicked ()), this, SLOT (slotBtnSave ()));
  btnBox->addWidget (btnSave);
  btnSpace =
    new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  btnBox->addItem (btnSpace);
  btnDel = new QPushButton (btnWidget);
  btnDel->setText (tr ("Delete"));
  btnDel->setEnabled (false);
  connect (btnDel, SIGNAL (clicked ()), this, SLOT (slotBtnDel ()));
  btnBox->addWidget (btnDel);
  prodGrid->addWidget (btnWidget, 1, 1);
  // spacer
  sp1 = new QSpacerItem (0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
  sp2 = new QSpacerItem (0, 0, QSizePolicy::Expanding, QSizePolicy::Minimum);
  prodGrid->addItem (sp1, 2, 0);
  prodGrid->addItem (sp2, 0, 2);
}

void
cfg_prod::initData ()
{
  prodList->clear ();
  prodList->insertItem (tr ("Printout"));
  for (productList::iterator pi = prods->begin (); pi != prods->end (); ++pi)
    prodList->insertItem ((*pi).name);
}

void
cfg_prod::slotListSelected (int i)
{
  if (i == 0)
    {
      printprice *prn =
	new printprice (this, "prints", true, pInfo, *curency, CfgWrite);
      if (prn->exec () == QDialog::Accepted)
	{
	  pInfo->tax = prn->edTax->text ().toFloat ();
	  pInfo->color = prn->edColor->text ().toFloat ();
	  pInfo->gray = prn->edGray->text ().toFloat ();
	  emit configChanged ();
	}
      prn->~printprice ();
    }
  else
    {
      i--;
      currentItem = i;
      QString buf;
      edName->setText ((*prods)[i].name);
      buf.setNum ((*prods)[i].price);
      edPrice->setText (buf);
      buf.setNum ((*prods)[i].tax);
      edTax->setText (buf);
      btnDel->setEnabled (CfgWrite);
    }
}

void
cfg_prod::clear ()
{
  prodList->clearSelection ();
  edName->clear ();
  edPrice->clear ();
  edTax->clear ();
  btnSave->setEnabled (false);
  btnDel->setEnabled (false);
}

void
cfg_prod::setEnabled (bool write)
{
  if (CfgWrite == write)
    return;
  CfgWrite = write;
  edName->setEnabled (CfgWrite);
  edPrice->setEnabled (CfgWrite);
  edTax->setEnabled (CfgWrite);
}

void
cfg_prod::slotBtnNew ()
{
  currentItem = -1;
  clear ();
}

void
cfg_prod::slotBtnSave ()
{
  if (currentItem < 0)
    {
      // new product
      productInfo p;
      p.name = edName->text ();
      p.price = edPrice->text ().toFloat ();
      p.tax = edTax->text ().toFloat ();
      (*prods).append (p);
    }
  else
    {
      (*prods)[currentItem].name = edName->text ();
      (*prods)[currentItem].price = edPrice->text ().toFloat ();
      (*prods)[currentItem].tax = edTax->text ().toFloat ();
    }
  initData ();
  clear ();
  emit configChanged ();
}

void
cfg_prod::slotBtnDel ()
{
  productList::iterator pi;
  bool found = false;
  for (pi = prods->begin (); pi != prods->end (); ++pi)
    if ((*pi).name == prodList->text (currentItem))
      {
	found = true;
	break;
      }
  if (found == true)
    prods->erase (pi);
  initData ();
  clear ();
  emit configChanged ();
}

void
cfg_prod::slotName (const QString & s)
{
  if (currentItem < 0 || (*prods)[currentItem].name != s)
    btnSave->setEnabled (CfgWrite);
}

void
cfg_prod::slotPrice (const QString & s)
{
  if (currentItem < 0 || (*prods)[currentItem].price != s.toFloat ())
    btnSave->setEnabled (CfgWrite);
}

void
cfg_prod::slotTax (const QString & s)
{
  if (currentItem < 0 || (*prods)[currentItem].tax != s.toFloat ())
    btnSave->setEnabled (CfgWrite);
}

void
cfg_prod::setCurency (QString s)
{
  lbCur1->setText (s);
}
