/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __GAME_H__
#define __GAME_H__

#include "common.h"
#include "scene.h"
#include "bezier.h"
#include "player.h"
#include "sample.h"
#include "ballpath.h"
#include "level.h"

using namespace Scenes;

#define NBALLCOLORS 8

extern Sample *sfx_pull;
extern Sample *sfx_push;
extern Sample *sfx_eliminate;
extern Sample *sfx_ouch;
extern Sample *sfx_combo;
extern Sample *sfx_roll;
extern Sample *sfx_bonus;
extern Sample *sfx_extraball;
extern Sample *sfx_extralife;

extern Mixer *mix;
extern AudioBuffer *rollSoundBuff;
extern int sfxVol;
extern int musicVol;

class Game : public Scene
{
        friend class GameLoop;

        static const int levelNameDisplayTimeout=500;
        static const int waitAfterFinished=300;
        static const int pointsForNewLife = 10000;
        static const int extraLifeDisplayTimeout=250;
        static const int timeBonusScorePerSecond = 50;

        Settings *settings;
        SDL_Surface *surface;
        void CleanupSounds();

        Player *pl;
        BallPath **ballPaths;
        int nPaths;

        GLuint ballText[NBALLCOLORS + BONUS_BOMB + 2];

        bool dying;

        uint randomSeed;
        bool randomSeedSet;

        int levelNameDisplayTime;
        bool displayLevelName;

        int finishedTimer;
        bool finishCountdown;
        Sample *music;
        AudioBuffer *mbuff;

        double vwidth;
        double vleft;
        double vheight;
        Level &level;

        bool editor;
        bool ownTextures;
        const string getRandomMusic();

        uint lives;

        bool displayExtraLife;
        int extraLifeDisplayTime;
        uint extraLifeLastScore;

        uint levelSeconds;
        bool stopTimer;
        bool timeBonus;
        int timeBonusSecondsAdded;

    public:
        Game(Scenes::Settings *settings, SDL_Surface *surf,  Level &level, GLuint *textures, uint randomSeed, uint lives, int score = 0, bool fromEditor = false);
        ~Game();
        void Render(ulong frame);
        void Logic(ulong frame);
        void GLSetup();

        int score;
        bool gameOver;
        bool escaped;
};


#endif //__GAME_H__
