#include <sys/param.h>
#include <netinet/in.h>
#include <pwd.h>
#ifdef SHADOW
#include <shadow.h>
#endif 
#include <netdb.h>    
#include "youbin.h"
#include "server.h"
#include <stdio.h>

extern char *NAK_reason;

/*
 * Authentification.
 */

int check_pass( StateP sp, char *passwd, int head )
{    
    struct passwd *pw;
#ifdef SHADOW
    struct spwd *spw;
#endif
    char *pw_passwd;
    char *crypted_passwd;
                                 /* Check user name with reading passwd file. */

    if((pw = getpwnam( sp->parent->name )) == NULL) {        /* Invalid user. */  
      warn_log("Invalid user name: %s\n", sp->parent->name);
      return FAIL;
    }
    switch( sp->mode.auth_mode ){
    case NONE:
      return ( head == 0 );
    case PLAIN:
#ifdef SHADOW
     if((spw = getspnam( sp->parent->name )) == NULL) {  /* Invalid user. */  
         warn_log("Invalid user name: %s\n", sp->parent->name);
        return FAIL;
      }
	  pw_passwd = spw->sp_pwdp;
#else
	  pw_passwd = pw->pw_passwd;
#endif
      return !(strcmp( pw_passwd, (char *)crypt( passwd, pw_passwd )));
    case ROK:
      return ( is_trusted_user( sp->parent->name ));
    default:
      return FAIL;
    }
}

int
is_trusted_user(user_name)
char    *user_name;
{
    int             saved_uid, ruserok_result;
    struct hostent  *hp;
    
    if ((hp = gethostbyaddr((char *)&ca.sin_addr,
                            sizeof(ca.sin_addr), ca.sin_family)) == NULL) {
        sys_error_log("gethostbyaddr");
        return (FAIL);
    }

#ifdef BUGGY_RUSEROK
    saved_uid = getuid();
#endif

    ruserok_result = ruserok(hp->h_name, 0, user_name, user_name);

#ifdef BUGGY_RUSEROK
    setuid(saved_uid);
#endif

    return ((IPPORT_RESERVED / 2) <= ntohs(ca.sin_port) &&
            ntohs(ca.sin_port) < IPPORT_RESERVED &&
            ruserok_result == 0);
}

struct h_f {
    int   size;
    char *pattern;
    } header_field[33];
char head_buff[MESS_LEN];

void init_header_list( char *mess )
{
    char  *cptr;
    int   i;

    strncpy( head_buff, mess, MESS_LEN );
    head_buff[MESS_LEN - 1 ] = 0;
    for( i = 0, cptr = head_buff; ( i < 32 ) && *cptr; i++ ){
	header_field[i].pattern = cptr;
	if(( cptr = index( cptr, ',' )) == NULL ){
	    header_field[i].size = strlen( header_field[i].pattern );
	    i++;
	    break;
	} else {
	    *cptr++ = 0;
	    header_field[i].size = strlen( header_field[i].pattern );
	}
    }
    for( ; i < 33; i++ ) {       /* 33 rd is a sentinel */
	header_field[i].size = 0;
	header_field[i].pattern = NULL;
    }
}

int headers( char *header_list )
{
  int  i, header_req, length;
  char *cptr;

  for( header_req=0; *header_list; header_list += length ){
    if( *header_list == ',' ) header_list++;
    if(( cptr = index( header_list, ',' )) != NULL ){
      length = cptr - header_list;
    } else {
      length = strlen( header_list );
    }
    for( i = 0; i < 32 ; i++ ){
      if( header_field[i].size == 0 ) break;    /* usually less than 32 field */
      if( header_field[i].size == length ) {
	if( strncasecmp( header_field[i].pattern, header_list, length ) == 0 ) {
	  header_req |= ( 1 << i );
	}
      }
    }
  }
  return header_req;
}

isPrintHead( char *line, unsigned int req )
{
   struct h_f *hfp;
   for( req >>= 1, hfp = header_field + 1 ; req; hfp++, req >>= 1 ){
       if( req & 1 ){
	   if( strncasecmp( line, hfp->pattern, hfp->size ) == 0 ) return TRUE;
       }
   }
   return FALSE;
}
	
struct auth_list {
  enum a_mode am;
  char        *mode_name;
  } a_l[5] = {{NONE, "none"}, { PLAIN, "plain"}, { ROK, "rok" },
	      {PGP, "pgp"}, {(enum a_mode) -1, "" }};

enum a_mode conv_a_mode( char *auth )
{ struct auth_list *alp;
  for( alp = a_l; alp->am != (enum a_mode) -1; alp++ ){
    if( strcmp( alp->mode_name, auth ) == 0 ) break;
  }
  return alp->am;
}

void    put6bit( char*, int, int );

int mimedecode( source, dest )
char *source, *dest;
{
    int   pos, data;

    for( pos = 0; ( data = get6bit( *source )) < 64; source++, pos += 6 ){
	put6bit( dest, pos, data );
    }
}

void    put6bit( buffer, pos, data )
char *buffer;
int  pos, data;
{
    char *byte_pos;
    int  bit_pos;

    byte_pos = buffer + ( pos / 8 );
    bit_pos = pos % 8;
    data &= 0x3f;                    /* Mask 6 bits */
    if( bit_pos > 2 ) {
    *byte_pos &= ~( 0x3f >> ( bit_pos - 2 ));
    *byte_pos++ |= data >> ( bit_pos - 2 );
    }
    *byte_pos &= ~( 0x3f << (( 10 - bit_pos ) % 8 ));
    *byte_pos |= data << (( 10 - bit_pos ) % 8 );
}

int get6bit( data )
    int data;
{
    static char *base64 =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    char   *pos;

    return (pos = index( base64, data ))== NULL ? 64 : pos - base64;
}
