/*
 * Program:     $RCSfile: base.c,v $  $Revision: 4.3 $
 *
 * Purpose:     Basic routines of internet "youbin" service.
 *
 * Author:      K.Agusa     agusa@nuie.nagoya-u.ac.jp
 *              S.Yamamoto  yamamoto@nuie.nagoya-u.ac.jp
 *
 * Date:        1993/07/27
 * Modified:    $Date: 1995/03/26 11:56:18 $
 *
 * Copyright:   K.Agusa and S.Yamamoto  1993 - 1995
 *
 * The X Consortium, and any party obtaining a copy of these files from
 * the X Consortium, directly or indirectly, is granted, free of charge,
 * a full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons who receive copies from any such
 * party to do so. This license includes without limitation a license to do
 * the foregoing actions under any patents of the party supplying this
 * software to the X Consortium.
 */

#ifndef lint
static char rcsid[] =
    "$Id: base.c,v 4.3 1995/03/26 11:56:18 yamamoto Exp $";
#endif

#include <stdio.h>

#include "youbin.h"

/*
 * Variable argument list.
 *
 * USE_STDARG:  Use ANSI routines.
 * USE_VARARGS  Use UNIX's native routines.
 */

#ifdef USE_STDARG 

#include <stdarg.h>
#define VARARGS_PROTO(func, firstArg, type)     func(type firstArg, ...)
#define VA_START(argsPtr, firstArg)             va_start(argsPtr, firstArg)
#define VA_1ST_ARG(argsPtr, firstArg, type)     firstArg

#else /* USE_VARARGS */

#include <varargs.h>
#define VARARGS_PROTO(func, firstArg, type)     func(va_alist) va_dcl
#define VA_START(argsPtr, firstArg)             va_start(argsPtr)
#define VA_1ST_ARG(argsPtr, firstArg, type)     va_arg(argsPtr, type)

#endif /* USE_VARARGS */

void
print_usage(usage)
char    **usage;
{
    while (*usage != NULL) {
        fprintf(stderr, "%s\n", *usage++);
    }
    fprintf(stderr, "VERSION\n");
    fprintf(stderr, "    Version           %s\n", VERSION);
    fprintf(stderr, "    Patch level       %s\n", PATCH_LEVEL);
    fprintf(stderr, "    Protocol version  %s\n", PROTOCOL_VERSION);
}

void
VARARGS_PROTO(debug, va_args, char *)
{
    va_list     args;
    
    if (debug_mode) {
        VA_START(args, va_args);
        vfprintf(stderr, VA_1ST_ARG(args, va_args, char *), args);
        va_end(args);
    }
}
