/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#include "sigcx/tunnel.h"

#include "yehia/plugin.h"

#include "yehia/script/class-builder.h"
#include "yehia/script/slot-convert.h"

namespace Yehia
{

namespace Script
{

LangConvertSlotNode::LangConvertSlotNode(SigC::FuncPtr proxy, 
                                         const SigC::Node& s, 
                                         Language& lang)
    : SigC::AdaptorSlotNode(proxy, s), lang_(lang)
{
}

LangConvertSlotNode::~LangConvertSlotNode()
{
}

// This function is always invoked from inside the scripting language
// thread (if multithreaded)
Object& LangConvertSlotNode::from_script_proxy(const ParamList& params, 
                                               void *data)
{
  LangConvertSlotNode& node = *(LangConvertSlotNode*)(data);
  Slot& slot_ = (Slot&)(node.slot_);
  Language& lang = node.lang_;
  
  std::list<Any> anylist;
  Any retval;
  
  for (ParamList::const_iterator it = params.begin(); it != params.end(); ++it)
    anylist.push_back((*it)->value());
  
  if (!lang.tunnel() || lang.tunnel()->in_sync_callback())
    retval = slot_(anylist);
  else
  {
    retval = SigCX::tunnel<Any, const std::list<Any>&>(
            slot_, anylist, LanguageManager::instance().main_tunnel(), true);
  }
  return lang.factory().create_value(retval);
}

namespace
{

Any slot_invoke(Language& lang, ObjectSlot& slot_, const std::list<Any>& anylist)
{
  ParamList params;
  for (std::list<Any>::const_iterator it = anylist.begin(); 
       it != anylist.end(); ++it)
    params.push_back(&lang.factory().create_value((*it)));
  
  Object *retval = slot_(params);
  Any anyval = retval->value();
  retval->unreference();
  return anyval;
}

}

// This is always invoked from the main thread (e.g. virtual script
// method)
Any LangConvertSlotNode::to_script_proxy(const std::list<Any>& anylist, 
                                         void *data)
{
  LangConvertSlotNode& node = *(LangConvertSlotNode*)(data);
  ObjectSlot& slot_ = (ObjectSlot&)(node.slot_);
  Language& lang = node.lang_;

  if (!lang.tunnel() || lang.tunnel()->in_sync_callback())
    return slot_invoke(lang, slot_, anylist);
  else
    // we must do the conversion Any -> Object * inside the scripting thread
    return SigCX::tunnel<Any, Language&, ObjectSlot&, const std::list<Any>&>(
            SigC::slot(&slot_invoke), lang, slot_, anylist,
            lang.tunnel(), true);
}

ObjectSlot lang_convert(const Slot& s, Language& l) 
{
  return new LangConvertSlotNode((SigC::FuncPtr)(&LangConvertSlotNode::from_script_proxy),
	                     s, l);
}

Slot lang_convert(const ObjectSlot& s, Language& l)
{
  return new LangConvertSlotNode((SigC::FuncPtr)(&LangConvertSlotNode::to_script_proxy),
	                     s, l);
}

}

}
