/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_UCXX_ANY_H)
#define __INC_UCXY_ANY_H

#include <string>

enum TypeCode
{
  TC_NULL,

  TC_LONG,
  TC_ULONG,
  
  TC_STRING,

  TC_OBJECT
};

class Any
{
  public:
    Any() { tc_ = TC_NULL; }
    ~Any() { clear(); }

    TypeCode typecode() const { return tc_; }
    
    // output
    bool operator >>=(SigC::Object *& obj) const {
      return(tc_ == TC_OBJECT ? obj = obj_, true : false);
    }
    
    // Numeric types
    bool operator >>=(long& l) const {
      return(tc_ == TC_LONG ? l = long_, true : false);
    }
    bool operator >>=(unsigned long& ul) const {
      return(tc_ == TC_ULONG ? ul = ulong_, true : false);
    }

    // string types
    bool operator >>=(std::string& s) const {
      return(tc_ == TC_STRING ? s = string_, true : false);
    }
    
    bool operator >>=(const char *& s) const {
      return(tc_ == TC_STRING ? s = string_, true : false);
    }

    // input
    void operator <<=(const std::string& s) {
      clear();
      tc_ = TC_STRING;
      string_ = new char[s.size() + 1];
      strcpy(string_, s.c_str());
    }
    void operator <<=(long l) { clear(); tc_ = TC_LONG; short_ = l; }
    void operator <<=(unsigned long l) { 
      clear(); tc_ = TC_ULONG; ushort_ = l; 
    }
  protected:
    void clear();
  private:
    TypeCode tc_;
    union
    {
        short short_;
        unsigned short ushort_;
        long long_;
        unsigned long ulong_;

        char *string_;

        SigC::Object *obj_;
    };
};


#endif
