/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_PYTHON_SCRIPT_H)
#define __INC_PYTHON_SCRIPT_H

#include <glib.h>

#include <string>

#include <Python.h>

#include <uc++/script.h>

namespace uC
{

namespace Script
{

class pythonObject;

class pythonObjectFactory : public ObjectFactory
{
  public:
    pythonObjectFactory();
    virtual ~pythonObjectFactory();
    
    virtual Object& create_value(const Any& v);
    virtual Object& create_method(const Slot& slot, const Signature& sig);
    virtual Object& create_class(const ClassObject& c,
                                 const Signature& supers);
    virtual Object& wrap_instance(const Object& klass, SigC::Object& obj);
    virtual Object& create_namespace();

    virtual Object& null_object();
    
    pythonObject& create_object(PyObject *pyobj);
  private:
    virtual void destroy(Object& obj);
    
    GMemChunk *memchunk_;
    pythonObject *null_obj_;
};

class pythonObject : public Object,
                     protected Instance, protected Callable,
                     protected Namespace
{
  public:
    pythonObject(pythonObjectFactory& factory, PyObject *pyobj = 0);
    virtual ~pythonObject();
    
    pythonObjectFactory& factory() {
      return dynamic_cast<pythonObjectFactory&>(uC::Script::Object::factory());
    }
    
    virtual Namespace& namespace_interface();
    virtual Callable& callable_interface();
    virtual Instance& instance_interface();
    
    // Value
    virtual Any value() const;
    
    // Instance interface
    virtual SigC::Object& object();
    virtual Object& get_attribute(const std::string& name);
    virtual void set_attribute(const std::string& name, Object& value);

    // Callable interface
    virtual uC::Script::Object& call(const ObjectContainer& args);
    
    // Namespace interface
    virtual uC::Script::Object& member(const std::string& name);
    virtual void insert(const std::string& name, uC::Script::Object& object);

    // Utilities
    void ensure(bool cond);
    bool is_null();
    pythonObject& operator=(PyObject *pyobj);
    PyObject *pyobj() const;
  private:
    unsigned state_ : 2;
    PyObject *pyobj_;
};

}

}

#endif
