/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(__INC_GUILE_SCRIPT_H)
#define __INC_GUILE_SCRIPT_H

#include <glib.h>

#include <string>

#include <guile/gh.h>

#include <sigc++/thread.h>
#include <sigc++/slot.h>
#include <sigc++/object_slot.h>
#include <sigc++/thread_tunnel.h>

#include "uc++/script.h"

namespace uC
{

namespace Script
{

class guileObject;

class guileObjectFactory : public ObjectFactory
{
  public:
    guileObjectFactory();
    virtual ~guileObjectFactory();
    
    virtual Object& create_value(const Any& v);    
    virtual Object& create_method(const Slot& slot, const Signature& sig);
    virtual Object& create_class(const ClassObject& c,
                                 const Signature& supers);
    virtual Object& wrap_instance(const Object& klass, SigC::Object& obj);
    virtual Object& create_namespace();

    virtual Object& null_object();
    
    guileObject& create_object(SCM sobj);
  private:
    virtual void destroy(Object& obj);
    
    GMemChunk *memchunk_;
    guileObject *null_obj_;
};

class guileObject : public Object,
		    protected Instance, protected Callable,
		    protected Namespace
{
  public:
    guileObject(guileObjectFactory& factory, SCM sobj = SCM_UNSPECIFIED);
    virtual ~guileObject();
    
    guileObjectFactory& factory() {
      return dynamic_cast<guileObjectFactory&>(uC::Script::Object::factory());
    }
    
    virtual Namespace& namespace_interface();
    virtual Callable& callable_interface();
    virtual Instance& instance_interface();
    
    // Value
    virtual Any value() const;

    // Instance interface
    virtual SigC::Object& object();
    virtual Object& get_attribute(const std::string& name);
    virtual void set_attribute(const std::string& name, Object& value);

    // Callable interface
    virtual uC::Script::Object& call(const ObjectContainer& args);
    
    // Namespace interface
    virtual uC::Script::Object& member(const std::string& name);
    virtual void insert(const std::string& name, uC::Script::Object& object);

    // Utilities
    void ensure(bool cond);
    bool is_null();
    guileObject& operator=(SCM sobj);
    SCM sobj();
  private:
    SCM sobj_;
};

}

}

#endif
