#!/bin/sh
#
# File: builddocs.sh
#
# $Id: builddocs.sh,v 1.5 2005/09/06 21:25:09 chessing Exp $
# $Date: 2005/09/06 21:25:09 $
# $Log: builddocs.sh,v $
# Revision 1.5  2005/09/06 21:25:09  chessing
# Patch to builddocs.sh from Carsten Grohmann.
#

SGML_CATALOG_FILES=/usr/sgml-tools/dtd/catalog:/etc/sgml/catalog:/usr/share/doc/openjade-1.3.2/catalog:/home/chris/t/docbook-dsssl-1.97/catalog

JADE_DIRS="/usr/share/doc/openjade-1.3/pubtext \
           /usr/share/sgml/declaration/ \
	   /usr/share/xml/declaration/ \
           /usr/share/sgml/ \
           /usr/share/xml/ \
           /usr/share/sgml/opensp/ \
           /usr/share/sgml/openjade/xml.dcl "

# print usage message
function usage {
  echo "Usage: $(basename $0) [-f <directory>]"
  echo "Create the Xsupplicant documentation in PDF, HTML and TXT format."
  echo " "
  echo "If the sgml declaration file will not found automatically, specify"
  echo "the directory manually with the \"-f <Directory>\" option."
  echo "This directory have to contain \"xml.dcl\"."
  exit $1
}

case $1 in
  "-f")
    if [ -d "$2" ]; then
      JADE_DIRS="$2 $JADE_DIRS"
    else
      echo "ERROR: \"$2\" isn't a directory."
      usage 1
    fi
    ;;
  "--help"|"-h")
    usage
    ;;
esac

# search sgml declaration file
for DIR in $JADE_DIRS; do
  if [ -e $DIR/xml.dcl ]; then
    JADE_PUB=$DIR
    break
  fi
done
if [ -z "$JADE_PUB" ]; then
  echo "ERROR: SGML declaration file \"xml.dcl\" not found."
  exit 1
fi

# make sure that jade is in the user's path
JADE_PATH=`which jade 2> /dev/null`
if [ x$JADE_PATH == x ]
then
    echo "jade not found in your path...exiting!"
    exit 1
fi

# create destination directories
mkdir -p html
mkdir -p txt
mkdir -p pdf

# create the html docs
echo -n "Building the HTML docs..."
$JADE_PATH -V nochunks -t sgml -i html -d ./ldp-dsssl/ldp.dsl\#html \
    $JADE_PUB/xml.dcl xml-userguide/userguide.xml > html/Open1x-UserGuide.html
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
else
    echo "Done."
fi

# create the txt docs
echo -n "Building the TXT docs..."
lynx -dump -nolist html/Open1x-UserGuide.html > txt/Open1x-UserGuide.txt
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
else
    echo "Done."
fi

# create the pdf docs
echo -n "Building the PDF docs..."
cd pdf/
$JADE_PATH -t tex -d ../ldp-dsssl/ldp.dsl\#print $JADE_PUB/xml.dcl \
    ../xml-userguide/userguide.xml > /dev/null
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
fi
mv ../xml-userguide/userguide.tex .
pdfjadetex userguide.tex > /dev/null
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
fi
pdfjadetex userguide.tex > /dev/null
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
fi
pdfjadetex userguide.tex > /dev/null
if [ $? -ne 0 ]
then
    echo "Error!  Build failed!"
    exit 1
fi
rm -f userguide.tex userguide.log userguide.aux userguide.out
mv userguide.pdf Open1x-UserGuide.pdf
cd ../
echo "Done."
