/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef SID_WITH_SIDPLAY2
// Write a big-endian 16-bit word to two bytes in memory.
inline void writeLEword(unsigned char ptr[2], int someWord)
{
	ptr[0] = (someWord & 0xFF);
	ptr[1] = (someWord >> 8);
}
#else
# include <sidplay/myendian.h>
#endif

#include "SidTuneMod.h"
#include "MD5.h"

#ifndef SID_WITH_SIDPLAY2
const char sidtune_text_songNumberExceed[] = "WARNING: Selected song number was too high";
const char sidtune_text_PAL_VBI[] = "50 Hz VBI (PAL)";
const char sidtune_text_PAL_CIA[] = "CIA 1 Timer A (PAL)";
const char sidtune_text_NTSC_VBI[] = "60 Hz VBI (NTSC)";
const char sidtune_text_NTSC_CIA[] = "CIA 1 Timer A (NTSC)";
#endif

void SidTuneMod::createMD5(MD5& myMD5)
{
#ifdef SID_WITH_SIDPLAY2
    if (status)
#else
    if (isCached && status)
#endif
    {
        // Include C64 data.
#ifdef SID_WITH_SIDPLAY2
        myMD5.append(cache.get()+fileOffset,info.c64dataLen);
        unsigned char tmp[2];
#else
        myMD5.append(cachePtr+fileOffset,info.c64dataLen);
        ubyte tmp[2];
#endif
        // Include INIT and PLAY address.
        writeLEword(tmp,info.initAddr);
        myMD5.append(tmp,sizeof(tmp));
        writeLEword(tmp,info.playAddr);
        myMD5.append(tmp,sizeof(tmp));
        // Include number of songs.
        writeLEword(tmp,info.songs);
        myMD5.append(tmp,sizeof(tmp));
        // Include song speed for each song.
#ifdef SID_WITH_SIDPLAY2
        for (unsigned int s = 1; s <= info.songs; s++)
#else
        for (uword s = 1; s <= info.songs; s++)
#endif
        {
#ifdef SID_WITH_SIDPLAY2
            selectSong(s);
#else
            selectSongPublic(s);
#endif
            myMD5.append(&info.songSpeed,sizeof(info.songSpeed));
        }
        // Deal with PSID v2NG clock speed flags: Let only NTSC
        // clock speed change the MD5 fingerprint. That way the
        // fingerprint of a PAL-speed sidtune in PSID v1, v2, and
        // PSID v2NG format is the same.
#ifdef SID_WITH_SIDPLAY2
        if ( info.clockSpeed == SIDTUNE_CLOCK_NTSC )
            myMD5.append(&info.clockSpeed,sizeof(info.clockSpeed));
#else
        if ( info.clock == SIDTUNE_CLOCK_NTSC )
            myMD5.append(&info.clock,sizeof(info.clock));
#endif
        // NB! If the fingerprint is used as an index into a
        // song-lengths database or cache, modify above code to
        // allow for PSID v2NG files which have clock speed set to
        // SIDTUNE_CLOCK_ANY. If the SID player program fully
        // supports the SIDTUNE_CLOCK_ANY setting, a sidtune could
        // either create two different fingerprints depending on
        // the clock speed chosen by the player, or there could be
        // two different values stored in the database/cache.
    }
}

#ifndef SID_WITH_SIDPLAY2
// Bypass the wrong member protection in libsidplay1.

// First check, whether a song is valid. Then copy any song-specific
// variable information such a speed/clock setting to the info structure.
//
// This is a private member function. It is used only by player.cpp.
uword SidTuneMod::selectSongPublic(uword selectedSong)
{
    // Determine and set starting song number.
    if (selectedSong == 0)
    {
        selectedSong = info.startSong;
    }
    else if ((selectedSong > info.songs) || (selectedSong > classMaxSongs))
    {
        info.statusString = sidtune_text_songNumberExceed;
        selectedSong = info.startSong;
    }
    info.lengthInSeconds = songLength[selectedSong-1];
    // Retrieve song speed definition.
    info.songSpeed = songSpeed[selectedSong-1];
    info.clockSpeed = clockSpeed[selectedSong-1];
    // Assign song speed description string depending on clock speed.
    // Final description will be available after song init only.
    if (info.clockSpeed == SIDTUNE_CLOCK_PAL ||
        info.clockSpeed == SIDTUNE_CLOCK_UNKNOWN )
    {
        if (info.songSpeed == SIDTUNE_SPEED_VBI)
        {
            info.speedString = sidtune_text_PAL_VBI;
        }
        else
        {
            info.speedString = sidtune_text_PAL_CIA;
        }
    }
    else  //if (info.clockSpeed == SIDTUNE_CLOCK_NTSC)
    {
        if (info.songSpeed == SIDTUNE_SPEED_VBI)
        {
            info.speedString = sidtune_text_NTSC_VBI;
        }
        else
        {
            info.speedString = sidtune_text_NTSC_CIA;
        }
    }
    return (info.currentSong=selectedSong);
}
#else

    const unsigned char *SidTuneMod::getDataBuffer() { return cache.get(); }
    int SidTuneMod::getDataLength() { return cache.len(); }
#endif  /* !SID_WITH_SIDPLAY2 */

