/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef MIXERCONFIG_H
#define MIXERCONFIG_H

#include "wrapper/emucfg.h"  // where we take constants from
#include "wrapper/TypeWrapper.h"

class voiceVol
{
 public:
    unsigned short int l, r;  // left/right volume/panning level
    voiceVol() { l = 255; r = 0; }
};

class MixerConfig
{
 public:

    int channels;     // basically the same as in emuConfig
    int mixingMode;   //
    int panningMode;  //
        
    voiceVol volFP[4];           // high quality mixing mode
    voiceVol volHQ[4];           // full panning mixing mode
    
    // These always reflect the volume slider position.
    // Max=256, Min=0. Map to slider values: 0=top=max, 100=bottom=min
    int volTotal[4];
    
    int muteMask[4];  // binary mask, 0=off, 65535=on
    
    MixerConfig()
    {
        channels = SIDEMU_MONO;
        mixingMode = SIDEMU_NONE;
        panningMode = SIDEMU_NONE;
        
        volHQ[0].l = volHQ[1].r = volHQ[2].l = volHQ[3].r = 255;
        volHQ[0].r = volHQ[1].l = volHQ[2].r = volHQ[3].l = 0;
        volFP[0].l = volFP[1].r = volFP[2].l = volFP[3].r = 255;
        volFP[0].r = volFP[1].l = volFP[2].r = volFP[3].l = 0;
        volTotal[0] = volTotal[1] = volTotal[2] = volTotal[3] = 256;
        muteMask[0] = muteMask[1] = muteMask[2] = muteMask[3] = 65535;
    }
    
    void readMergedPanPosLeft(voiceVol panLevels[4], const udword_emuwt allPanPosLeft)
    {
        panLevels[0].l = (allPanPosLeft>>24)&255;
        panLevels[1].l = (allPanPosLeft>>16)&255;
        panLevels[2].l = (allPanPosLeft>>8)&255;
        panLevels[3].l = allPanPosLeft&255;
    }

    void readMergedPanPosRight(voiceVol panLevels[4], const udword_emuwt allPanPosRight)
    {
        panLevels[0].r = (allPanPosRight>>24)&255;
        panLevels[1].r = (allPanPosRight>>16)&255;
        panLevels[2].r = (allPanPosRight>>8)&255;
        panLevels[3].r = allPanPosRight&255;
    }

    long int mergePanPosLeft(const voiceVol panLevels[4])
    {
        return (panLevels[0].l<<24)+(panLevels[1].l<<16)+
               (panLevels[2].l<<8)+(panLevels[3].l);
    }

    long int mergePanPosRight(const voiceVol panLevels[4])
    {
        return (panLevels[0].r<<24)+(panLevels[1].r<<16)+
                (panLevels[2].r<<8)+(panLevels[3].r);
    }
};

#endif  /* MIXERCONFIG_H */
