/* $Header: /fridge/cvs/xscorch/sgame/seconomy.c,v 1.6 2001/07/31 02:29:30 jacob Exp $ */
/*
   
   xscorch - seconomy.c       Copyright(c) 2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorched economy
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <seconomy.h>      /* Economy header */
#include <sconfig.h>       /* Need to init player moneys */
#include <splayer.h>       /* .. same as above */
#include <sutil/srand.h>   /* Random interest rate */



sc_economy *sc_economy_new(void) {

   sc_economy *ec;
   
   ec = (sc_economy *)malloc(sizeof(sc_economy));
   if(ec == NULL) return(NULL);
   
   ec->interestrate = SC_ECONOMY_DEF_INTEREST;
   ec->dynamicinterest = false;
   ec->initialcash = SC_ECONOMY_DEF_CASH;
   ec->computersbuy = true;
   ec->computersaggressive = false;
   ec->freemarket = false;
   ec->lottery = false;
   ec->scoring = SC_ECONOMY_SCORING_STANDARD;
   
   return(ec);
   

}



void sc_economy_init(sc_economy *ec) {

   double ratio = ec->initialcash / 100000.0;

   ec->currentinterest = ec->interestrate;

   switch(ec->scoring) {
      case SC_ECONOMY_SCORING_BASIC:
         ec->survivalbonus = 100000 * ratio;
         ec->damagebonus   = 0      * ratio;
         ec->killbonus     = 40000  * ratio;
         ec->damageloss    = 0      * ratio;
         ec->deathloss     = 20000  * ratio;
         ec->suicideloss   = 100000 * ratio;
         break;

      case SC_ECONOMY_SCORING_STANDARD:
         ec->survivalbonus = 70000  * ratio;
         ec->damagebonus   = 500    * ratio;
         ec->killbonus     = 30000  * ratio;
         ec->damageloss    = 250    * ratio;
         ec->deathloss     = 20000  * ratio;
         ec->suicideloss   = 100000 * ratio;
         break;

      case SC_ECONOMY_SCORING_GREEDY:
         ec->survivalbonus = 70000  * ratio;
         ec->damagebonus   = 500    * ratio;
         ec->killbonus     = 30000  * ratio;
         ec->damageloss    = 250    * ratio;
         ec->deathloss     = 20000  * ratio;
         ec->suicideloss   = 100000 * ratio;
         break;

   }

}



void sc_economy_free(sc_economy **ec) {

   if(ec == NULL || *ec == NULL) return;
   free(*ec);
   *ec = NULL;

}



void sc_economy_interest(sc_config *c, sc_economy *ec) {

   int i;
   
   for(i = 0; i < c->numplayers; ++i) {
      c->players[i]->money *= (1 + ec->currentinterest);
   }
   if(ec->dynamicinterest) {
      ec->currentinterest += ((game_lrand(7) - 3) / 100.0);
      if(ec->currentinterest < 0) ec->currentinterest = 0;
      if(ec->currentinterest > SC_ECONOMY_MAX_INTEREST) ec->currentinterest = SC_ECONOMY_MAX_INTEREST;
   }

}



static const char *_sc_economy_scoring_names[] = {
   "Basic",
   "Standard",
   "Greedy",
   NULL
};
static const int _sc_economy_scoring_types[] = {
   SC_ECONOMY_SCORING_BASIC,
   SC_ECONOMY_SCORING_STANDARD,
   SC_ECONOMY_SCORING_GREEDY,
   0
};



const char **sc_economy_scoring_names(void) {

   return(_sc_economy_scoring_names);

}



const int *sc_economy_scoring_types(void) {

   return(_sc_economy_scoring_types);

}
