/*-
# X-BASED MASTERBALL(tm)
#
#  Mball.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Mball */

#ifndef _XtMball_h
#define _XtMball_h

/***********************************************************************
 *
 * Mball Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNwedgeColor0 ((char *) "wedgeColor0")
#define XtNwedgeColor1 ((char *) "wedgeColor1")
#define XtNwedgeColor2 ((char *) "wedgeColor2")
#define XtNwedgeColor3 ((char *) "wedgeColor3")
#define XtNwedgeColor4 ((char *) "wedgeColor4")
#define XtNwedgeColor5 ((char *) "wedgeColor5")
#define XtNwedgeColor6 ((char *) "wedgeColor6")
#define XtNwedgeColor7 ((char *) "wedgeColor7")
#define XtNwedgeColor8 ((char *) "wedgeColor8")
#define XtNwedgeColor9 ((char *) "wedgeColor9")
#define XtNwedgeColor10 ((char *) "wedgeColor10")
#define XtNwedgeColor11 ((char *) "wedgeColor11")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNwedges ((char *) "wedges")
#define XtNrings ((char *) "rings")
#define XtNorient ((char *) "orient")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCWedges ((char *) "Wedges")
#define XtCRings ((char *) "Rings")
#define XtCOrient ((char *) "Orient")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _MballClassRec *MballWidgetClass;

extern WidgetClass mballWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} mballCallbackStruct;
#endif

#define PUZZLE_HIDE (-9)
#define PUZZLE_PRACTICE_QUERY (-8)
#define PUZZLE_RANDOMIZE_QUERY (-7)
#define PUZZLE_SOLVE_MESSAGE (-6)
#define PUZZLE_RESTORE (-5)
#define PUZZLE_RESET (-4)
#define PUZZLE_AMBIGUOUS (-3)
#define PUZZLE_ILLEGAL (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_CONTROL 1
#define PUZZLE_SOLVED 2
#define PUZZLE_PRACTICE 3
#define PUZZLE_RANDOMIZE 4
#define PUZZLE_DEC 5
#define PUZZLE_ORIENTIZE 6
#define PUZZLE_INC 7
#define PUZZLE_WEDGE2 8
#define PUZZLE_WEDGE4 9
#define PUZZLE_WEDGE6 10
#define PUZZLE_WEDGE8 11
#define PUZZLE_WEDGE10 12
#define PUZZLE_WEDGE12 13
#define PUZZLE_COMPUTED 14
#define PUZZLE_UNDO 15
#define PUZZLE_REDO 16

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_RANDOMIZE 6
#define MENU_PRACTICE 7
#define MENU_SOLVE 8
#define MENU_ORIENTIZE 9
#define MENU_INCREMENT 10
#define MENU_DECREMENT 11

#define MINWEDGES 2
#define MAXWEDGES 12
#define MINRINGS 1
#define DEFAULTWEDGES 8
#define DEFAULTRINGS 4
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 16 /* works good for 12 wedges */

typedef struct _MballRec *MballWidget;

#endif /* _XtMball_h */
/* DON'T ADD STUFF AFTER THIS #endif */
