/*

    xpuyopuyo - pgame.h       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header for game control code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pgame_h_defined
#define __pgame_h_defined


#include <pconfig.h>
#include <pplayer.h>
#include <pai.h>


/* Game is over if both players have a "win/lose" status. */
/* Note, if player 1 is disabled, then it has pseudolose status */
#define P_GAME_IDLE(c)     (P_PLAYER_0(c)->state == P_STATE_DISABLED && P_PLAYER_1(c)->state == P_STATE_DISABLED)
#define P_GAME_OVER(c)     (P_PLAYER_WINLOSE(P_PLAYER_0(c)) && P_PLAYER_WINLOSE(P_PLAYER_1(c)) && !P_GAME_IDLE(c))
#define P_GAME_INACTIVE(c) (P_GAME_IDLE(c) || P_GAME_OVER(c))


/* Player state's time has elapsed yet? */
#define P_STATE_READY(p,tmp)   (p_game_time(&tmp), TV_GREATER(tmp, (p)->statetime))


/* Functions for managing a game */
void p_game_new(pconfig *c);
void p_game_set_new_state(pplayer *p, int state);
void p_game_resync_timers(pconfig *c);


/* Advance the game */
int p_game_advance(pconfig *c, pplayer *p);
int p_game_advance_all(pconfig *c);
void p_game_while_paused(pconfig *c);


/* End the game or pause it */
void p_game_end(pconfig *c);
void p_game_end_(pconfig *c);                /* (no network communication) */
void p_game_pause(pconfig *c, int paused);
void p_game_pause_(pconfig *c, int paused);  /* (no network communication) */


#endif
