/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_copies.cc,v 1.3 2000/11/05 00:38:30 bbarrett Exp $
 *
 *	Function:	- widgets for setting number of application copies
 */


#include <Xm/ArrowBG.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#include "xmpi_copies.h"
#include "xmpi_error.h"
#include "xmpi_run.h"
#include "lam.h"
#include "stoi.h"

/*
 * local definitions
 */
#define XMPI_UPARROW	((XtPointer) 1)
#define XMPI_DOWNARROW	((XtPointer) 2)

/*
 * local functions
 */
static void do_arrow(Widget, XtPointer,
		     XmArrowButtonCallbackStruct*);

static void verify(Widget, XtPointer, 
		   XmTextVerifyCallbackStruct*);

static void change(Widget, XtPointer, 
		   XmTextVerifyCallbackStruct*);

/*
 * local variables
 */
static int copies = 0;		       /* counter as value */

static Widget text_w;		       /* counter as text */

static Widget sc_w = 0;		       /* container */

/*
 *	xmpi_copies_get
 *
 *	Function:	- copy counter accessor
 *	Returns:	- copy counter text
 */
char *
xmpi_copies_get()
{
  char *s;

  XtVaGetValues(text_w, XmNvalue, &s, NULL);
  return (s);
}


//
// xmpi_copies_set
//
// Function:  - set the copy counter
// Input;     - copies
// Returns:   - void
// 
void
xmpi_copies_set(int numb)
{
  char *numb_text = NULL;
  numb_text = (char*) malloc(sizeof(char) * (sizeof(int) * 8 + 1));
  if (numb_text == NULL) {
    xmpi_error(0, (char*) "Error: malloc()");
    return;
  }

  if (numb > 0)
    sprintf(numb_text, "%d", numb);
  else
    numb_text[0] = 0;

  XtVaSetValues(text_w, XmNvalue, numb_text, NULL);
  copies = numb;
}

/*
 *	xmpi_copies_create
 *
 *	Function:	- create the widget for setting the copy counter
 *	Accepts:	- parent widget
 *	Returns:	- copy counter setting widget
 */
Widget
xmpi_copies_create(Widget parent_w)
{
  Widget up_w;			       /* up arrow */

  Widget down_w;		       /* down arrow */

  Dimension height;

  if (sc_w != 0)
    return (sc_w);

  sc_w = XtVaCreateWidget("setcopies",
			  xmFormWidgetClass, parent_w, NULL);

/*
 * Create the text field.
 */
  text_w = XtVaCreateManagedWidget("text",
				   xmTextFieldWidgetClass, sc_w,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNleftAttachment, XmATTACH_FORM,
				   NULL);
  XtVaGetValues(text_w, XmNheight, &height, NULL);
  XtAddCallback(text_w, XmNmodifyVerifyCallback, 
		(XtCallbackProc) verify, NULL);
  XtAddCallback(text_w, XmNvalueChangedCallback, 
		(XtCallbackProc) change, NULL);

/*
 * Create the up arrow.
 */
  up_w = XtVaCreateManagedWidget("uparrow",
				 xmArrowButtonGadgetClass, sc_w,
				 XmNarrowDirection, XmARROW_UP,
				 XmNtopAttachment, XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNrightAttachment, XmATTACH_FORM,
				 XmNborderWidth, 0,
				 NULL);
  XtAddCallback(up_w, XmNactivateCallback, 
		(XtCallbackProc) do_arrow, XMPI_UPARROW);

/*
 * Create the down arrow.
 */
  down_w = XtVaCreateManagedWidget("downarrow",
				   xmArrowButtonGadgetClass, sc_w,
				   XmNarrowDirection, XmARROW_DOWN,
				   XmNtopAttachment, XmATTACH_FORM,
				   XmNbottomAttachment, XmATTACH_FORM,
				   XmNrightAttachment, XmATTACH_WIDGET,
				   XmNrightWidget, up_w,
				   NULL);

  XtAddCallback(down_w, XmNactivateCallback, 
		(XtCallbackProc) do_arrow, XMPI_DOWNARROW);

  XtVaSetValues(text_w,
		XmNrightAttachment, XmATTACH_WIDGET,
		XmNrightWidget, down_w,
		NULL);

  return (sc_w);
}

/*
 *	do_arrow
 *
 *	Function:	- manage arrows of copy counter
 *			- increment/decrement copy counter
 *	Accepts:	- callback parameters
 */
static void
do_arrow(Widget, XtPointer data,
	 XmArrowButtonCallbackStruct *cbs)
{
  char fbuf[16];		       /* small formatting buffer */
  int inc;

  inc = (cbs->event->xbutton.state & ShiftMask) ? 10 : 1;

  if (data == XMPI_UPARROW) {
    copies += inc;
  } else {
    copies -= inc;
  }
  if (copies < 0)
    copies = 0;

  if (copies > 0) {
    sprintf(fbuf, "%d", copies);
  } else {
    fbuf[0] = 0;
  }
  XtVaSetValues(text_w, XmNvalue, fbuf, NULL);
}

/*
 *	verify
 *
 *	Function:	- verify numeric input for copy counter
 *	Accepts:	- callback parameters
 */
static void
verify(Widget, XtPointer, 
       XmTextVerifyCallbackStruct *cbs)
{
  int i;

  if (cbs->event == NULL || cbs->text->ptr == NULL)
    return;

  for (i = 0; i < cbs->text->length; i++) {
    if (!isdigit((int) cbs->text->ptr[i])) {
      cbs->doit = False;
      return;
    }
  }
}

/*
 *	change
 *
 *	Function:	- update counter to reflect text change
 *	Accepts:	- callback parameters
 */
static void
change(Widget, XtPointer,
       XmTextVerifyCallbackStruct *cbs)
{
  char *s;

  if (cbs->event != NULL) {
    XtVaGetValues(text_w, XmNvalue, &s, NULL);
    
    if (s == 0 || *s == 0) {
      copies = 0;
    } else {
      copies = (int) stoi((unsigned char *) s);
    }
  }

  xmpi_run_update();
}
