/*
 * $COPYRIGHT$
 *
 *	$Id: all_list.h,v 1.5 2000/02/09 13:51:54 bbarrett Exp $
 * 
 *	Function:	- constants and templates associated with all_list
 */

#ifndef _ALLLIST
#define _ALLLIST

#include "lam.h"

/*
 * templates
 */
struct al_head {
	struct al_head	*al_next;		/* next list element */
	struct al_head	*al_prev;		/* previous list element */
};

struct al_desc {
	int4		al_elemsize;		/* element size */
	int4		al_nelem;		/* # of elements */
	struct al_head	*al_ltop;		/* top of list ptr */
	struct al_head	*al_lbottom;		/* bottom of list ptr */
	struct al_head	*al_ftop;		/* top of free list ptr */
	int4		(*al_comp)(void*, void*);  /* comparison function */
};

typedef struct al_desc	LIST;

#define al_body(x) ((x) ? (((char *) (x)) + sizeof(struct al_head)) : 0)
#define al_count(x) ((x) ? (x)->al_nelem : 0)
#define al_top(x) ((al_count(x) > 0) ? (void *) al_body((x)->al_ltop) : 0)
#define al_bottom(x) ((al_count(x) > 0) ? (void *) al_body((x)->al_lbottom) : 0)


extern "C" {
extern LIST		*al_init __ARGS((int4 elemsize, int4 (*comp)(void*, void*)));
extern void		*al_append __ARGS((LIST *ald, void *unew));
extern void		*al_find __ARGS((LIST *ald, void *key));
extern void		*al_insert __ARGS((LIST *ald, void *unew));
extern void		*al_next __ARGS((LIST *ald, void *old));
extern void		*al_prev __ARGS((LIST *ald, void *old));
extern int4		al_delete __ARGS((LIST *ald, void *old));
extern int4		al_free __ARGS((LIST *ald));
}


extern "C" {
typedef int (*compare_funct) (void*, void*);
}


#endif


