dnl -*- shell-script -*-
dnl
dnl $Id: mpi_find_depdirs.m4,v 1.1 2000/09/08 01:46:54 bbarrett Exp $
dnl

define([LSC_MPI_FIND_DEPDIRS],[
#
# Arguments: prefix (optional)
#
# Dependencies: os_find_depdirs.m4
#
# Looks for the include directories necessary for MPI
# Will call AC_PROG_CPP or AC_PROG_CXXCPP if it has not been 
# called already (depending on autoconf's current language)
#
# Sets prefix_MPI_DEPDIRS to "-Idir1 -Idir2..." or blank
# Need to call AC_SUBST manually
#

# Figure out what prefix to use
lsc_mpi_prefix="$1"
if test "$lsc_mpi_prefix" = ""; then
    lsc_mpi_prefix="LSC"
fi

AC_MSG_CHECKING([for MPI include directories])
LSC_OS_FIND_DEPDIRS(mpi.h, lsc_internal)
AC_MSG_RESULT([$lsc_internal_OS_DEPDIRS])

# Save results
lsc_name="${lsc_mpi_prefix}_MPI_DEPDIRS"
lsc_str="${lsc_name}=\"$lsc_internal_OS_DEPDIRS\""
eval $lsc_str

# Clean up
unset lsc_mpi_prefix lsc_name lsc_internal_OS_DEPDIRS lsc_str])dnl
