/* Extended Module Player
 * Copyright (C) 1996-2001 Claudio Matsuoka and Hipolito Carraro Jr
 *
 * This file is part of the Extended Module Player and is distributed
 * under the terms of the GNU General Public License. See doc/COPYING
 * for more information.
 *
 * $Id: nas.c,v 1.1 2001/01/14 23:41:03 claudio Exp $
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <audio/audiolib.h>
#include <audio/soundlib.h>
#include "xmpi.h"
#include "driver.h"
#include "mixer.h"

static AuServer *aud;
static char *auservername = NULL;

static int init (struct xmp_control *);
static void bufdump (int);
static void myshutdown ();
static void sync ();

static void dummy () { }

struct xmp_drv_info drv_esd = {
    "nas",		/* driver ID */
    "NAS driver",	/* driver description */
    NULL,		/* help */
    init,		/* init */
    myshutdown,		/* shutdown */
    xmp_smix_numvoices,	/* numvoices */
    dummy,		/* voicepos */
    xmp_smix_echoback,	/* echoback */
    dummy,		/* setpatch */
    xmp_smix_setvol,	/* setvol */
    dummy,		/* setnote */
    xmp_smix_setpan,	/* setpan */
    dummy,		/* setbend */
    xmp_smix_seteffect,	/* seteffect */
    dummy,		/* starttimer */
    dummy,		/* stctlimer */
    dummy,		/* resetvoices */
    bufdump,		/* bufdump */
    dummy,		/* bufwipe */
    dummy,		/* clearmem */
    sync,		/* sync */
    xmp_smix_writepatch,/* writepatch */
    xmp_smix_getmsg,	/* getmsg */
    NULL
};

static int init (struct xmp_control *ctl)
{
    aud = AuOpenServer(auservername, 0, NULL, 0, NULL, NULL);
    if (!aud)
	return XMP_ERR_DINIT;

    return xmp_smix_on (ctl);
}


static void bufdump (int i)
{
    int j;
    void *b;

    b = xmp_smix_buffer ();
    do {
	AuSoundPlayFromData (aud, ...);
	if ((j = write (audio_fd, b, i)) > 0) {
	    i -= j;
	    b += j;
	} else
	    break;
    } while (i);
}


static void myshutdown ()
{
    xmp_smix_off ();
    AuCloseServer (aud)
}


static void sync ()
{
    AuSync (aud, TRUE);
    AuFlush (aud);
}

