
#include "WhiteCapWorld.h"

// Praise Jesus! I can't keep quiet...Ye-haw!

#include "Sample.h"
#include "CEgIFile.h"
#include "ArgList.h"
#include "R3Matrix.h"
#include "RectUtils.h"

#if EG_MAC
#include <Dialogs.h>
#endif


#include "PixPort.h"
#include "EgOSUtils.h"
#include "CEgFileSpec.h"
#include "WhiteCap.h"

UtilStr		WhiteCapWorld::sPtBuf;

WhiteCapWorld::WhiteCapWorld( float* inTransition_I, Expression* inTransitionExpr )  {

	mSamples	= nil;
	mRecentSample	= nil;
	mWave		= nil;
	mTransitionTime	= -1;
	mPi		= 3.1415926535897;
	mBackColor	= -1;		// This will cause an update to mCurBackClr in Render()
	mMaxBinsRecorded = 0;
	mNum_FFT_Bins	= 1;
	mLastSampleTime	= 0;

	mTransition_I	= inTransition_I;
	mTransitionExpr	= inTransitionExpr;

	mDict.AddVar( "S", &mS );
	mDict.AddVar( "T", &mLastSampleTime );
	mDict.AddVar( "ST", &mST );
	mDict.AddVar( "DT", &mDT );
	mDict.AddVar( "PI", &mPi );
	mDict.AddVar( "NUM_S_STEPS", &mNum_S_Steps );
	mDict.AddVar( "NUM_FFT_BINS", &mNum_FFT_Bins );
	mDict.AddVar( "BASS", &mBass );
	mDict.AddVar( "BASS1", &mBass );
	mDict.AddVar( "BASS2", &mBass );
	mDict.AddVar( "BASS3", &mBass );
	mDict.AddFcn( "FFT", &mFFTPtr );

	SetRect( &mPaneRect, 5000, 5000, -5000, -5000 );
}

WhiteCapWorld::~WhiteCapWorld() {

	Sample *sample;

	// Move all the sample to the mFreeList
	ExpireSamples();

	// Delete all the sample from the free list
	while ( mFreeList.FetchLast( (void**) &sample ) ) {
		delete sample;
		mFreeList.RemoveLast();
	}
}

#define __FACTORY	"\
Durn=\".8\",\
CamX=\"59*cos(t/5)\",\
CamY=\"50*sin(t/6)\",\
CamZ=\"25 + 10*cos(t/11)\",\
CmLX=\"40\",CmLY=\"0\",CmLZ=\"0\",\
CUpX=\"0\",CUpY=\"0\",CUpZ=\"1\",\
R=\"0\",G=\"1-dt\",B=\"0\",\
LvlR=\"1\",LvlG=\"0\",LvlB=\"0\",\
widt=320,heig=300,\
ConL=1,ConB=1,\
X=\"100*dt\",Y=\"150*s-75\",Z=\"28*abs( fft( s ) )\",\
Scal=\"600\",\
ScSz=1,\
Vers=40,\
Pers=\"350\""

void WhiteCapWorld::Init( const UtilStr* inConfig, float inT, long inNum_FFT_Bins, float inMorphDur ) {

	int ok, vers;
	ArgList		args;

	mNum_FFT_Bins	= inNum_FFT_Bins;
	mNum_S_Steps	= inNum_FFT_Bins;
	mLastSampleTime	= inT;

	args.SetArgs( inConfig );
	vers = args.GetArg( MCC4_TO_INT("Vers") );
	ok = vers == 40;

	// If something went wrong or we have an earlier version, default to the factory config
	if ( ! ok || ! inConfig ) {
		args.Clear();
		args.SetArgs( __FACTORY );
	}

	// If first time load or already in a transition, don't do any transition--switch to the new config immediately
	if ( mWave == nil || mTransitionTime > 0 || inMorphDur <= .05 ) {
		mWave = &mWave1;
		mNextWave = &mWave2;
		mWave -> Assign( args, mDict );
		mTransitionTime = -1;    }
	else {
		mTransitionTime = inMorphDur;
		mTransitionEnd = mLastSampleTime + inMorphDur;
		mNextWave -> Assign( args, mDict );
		mWave -> SetupTransition( mNextWave, &mTransitionT, nil );
	}
}

void WhiteCapWorld::SetPaneRect( const Rect& inRect ) {

	int width = inRect.right - inRect.left;
	int heigt = inRect.bottom - inRect.top;

	mPaneRect = inRect;

	// Besure we erase the new rect are next time
	mDirtyRect = mPaneRect;

	// If the scale changes with window size
	mWave -> SetScaleToFit( width, heigt );
	mNextWave -> SetScaleToFit( width, heigt );
}

void WhiteCapWorld::CalcForeground( float inIntensity, RGBColor& outRGB ) {

	if ( inIntensity > 1 )
		inIntensity = 1;
	if ( inIntensity < 0 )
		inIntensity = 0;

	float i = 1 - inIntensity;

	outRGB.red		= inIntensity * mForeColorRGB.red	+ i * mBackColorRGB.red;
	outRGB.green	= inIntensity * mForeColorRGB.green	+ i * mBackColorRGB.green;
	outRGB.blue		= inIntensity * mForeColorRGB.blue	+ i * mBackColorRGB.blue;
}

#define __Chk( x, y ) \
	if ( x >= extents.right )		\
		extents.right = x+1;		\
	if ( x <= extents.left )		\
		extents.left = x-1;			\
	if ( y >= extents.bottom )		\
		extents.bottom = y+1;		\
	if ( y <= extents.top )			\
		extents.top = y-1;

#define _evalClr( var, clr ) \
do { \
	clrTemp = 65535.0 * mWave -> clr.Evaluate(); \
	if ( clrTemp < 0 ) var = 0; \
	else if ( clrTemp <= 0xFFFF ) var = clrTemp; \
	else var = 0xFFFF; \
} while (0)


/*
// Pre: Render() was called before this
void WhiteCapWorld::DrawConfigName( void* inPort, long inXOffset, long inYOffset ) {
	RGBColor clr;
	float w;
	unsigned char* str;

	// Save the current mac port.  Even if Win9X/NT is crap, it's APIs/Interfaces are pretty decent, namely the GDI stuff.
	// But sure, then again, if an OS designed for 1984ish cpus can compete w/ a 'modern' OS, i'd be damned
	// ashamed if i was on the Win implementation team...
	#if EG_MAC
 	GrafPtr	savePort;
	::GetPort( &savePort );
	::SetPort( (GrafPtr) inPort );
	::TextFont( 20 );
	::TextSize( 12 );
	#endif

	#if EG_WIN
	HDC hdc = (HDC) inPort;
	#endif

	#if SONIQUE
	return;
	#endif

	mTitleRect.left = mPaneRect.left + inXOffset;
	mTitleRect.bottom = mPaneRect.bottom + inYOffset;
	mTitleRect.top = mPaneRect.bottom - 20;

	if ( mTransitionTime > 0 ) {

		// Calc interpolate color if there's two configs currently morphed
		if ( mTransitionT > .5 ) {
			w = 2 * mTransitionT - 1;
			str = mWave -> mTitle.getPasStr(); }
		else {
			w = 1 - 2 * mTransitionT;
			str = mNextWave -> mTitle.getPasStr();
		}

		// Calc the interpolated color
		clr.red   = mCurBackClrRGB.red		+ w * ( mTextColor.red - mCurBackClrRGB.red );
		clr.green = mCurBackClrRGB.green	+ w * ( mTextColor.green - mCurBackClrRGB.green );
		clr.blue  = mCurBackClrRGB.blue		+ w * ( mTextColor.blue - mCurBackClrRGB.blue );

		#if EG_MAC
		::RGBForeColor( &clr );
		::MoveTo( mTitleRect.left + 4, mTitleRect.bottom - 4 );
		::DrawString( str );
		#else
		::SetTextColor( hdc, __winRGB( clr.red, clr.green, clr.blue ) );
		::SetBkMode( hdc, TRANSPARENT );
		::TextOut( hdc, mTitleRect.left + 4, mTitleRect.top, (char*) &str[ 1 ], str[ 0 ] );
		#endif
	}
	else {
		#if EG_MAC
		::RGBForeColor( &mTextColor );
		::MoveTo( mTitleRect.left + 4, mTitleRect.bottom - 4 );
		::DrawString( mWave -> mTitle.getPasStr() );
		#else
		::SetTextColor( hdc, __winRGB( mTextColor.red, mTextColor.green, mTextColor.blue ) );
		::SetBkMode( hdc, TRANSPARENT );
		::TextOut( hdc, mTitleRect.left + 4, mTitleRect.top, mWave -> mTitle.getCStr(), mWave -> mTitle.length() );
		#endif
	}

	#if EG_MAC
	// Don't screw up future calls to copybits. Wtf--someone tell my my copyBits() freaks out when
	// the fore color isn't black
	clr.red = clr.green = clr.blue = 0;
	::RGBForeColor( &clr );
	Point pt;
	::GetPen( &pt );
	mTitleRect.right = pt.h;

	// Restore the prev mac port
	::SetPort( savePort );
	#endif

	#if WINAMP
	mTitleRect.right = 250; //!!!  ##*
	#endif

}
*/

#define __applySampleToGlobals( s ) \
	mFFTPtr = (ExprUserFcn*) s -> mSample;																				\
	mST = ( (float) s -> mSampleTime );																		\
	mDT = ( (float) (( mLastSampleTime - s -> mSampleTime )) ) / ( (float) mWave -> mSampleDuration );					\
	mBass = s -> mBass;


void WhiteCapWorld::Render( PixPort& inPort, Rect& outDirtyRect ) {

	V3 pt;
	long curBlurNum, x, y, i, clrTemp;
	short xorg	= ( mPaneRect.right + mPaneRect.left ) / 2;
	short yorg	= ( mPaneRect.bottom + mPaneRect.top ) / 2;
	R3Matrix T;
	float f_x, f_y, f_z;
	Sample* sample;
	LongRect extents;
	long borderXtra;
	RGBColor			curClr;
	long				curWidth, prevWidth;
	bool				transition;

	// Don't draw outside this world's pane
	inPort.SetClipRect( &mPaneRect );

	transition = mTransitionTime > 0;
	if ( transition ) {
		*mTransition_I = ( mTransitionEnd - mLastSampleTime ) / mTransitionTime;
		*mTransition_I = _MIN( *mTransition_I, 1.0 );
		*mTransition_I = _MAX( *mTransition_I, 0.0 );
		mTransitionT = mTransitionExpr -> Evaluate();
		mWave -> SetupFrame( mNextWave, mTransitionT, mNum_FFT_Bins ); }
	else {
		if ( mWave -> mNum_S_StepsOrig < 1 )
			mWave -> mNum_S_Steps = mNum_FFT_Bins;
	}

	// Transfer the number of s steps to the float that's shared/accessable in mDict
	// This is how many pieces we chop up s's interval from 0 to 1
	mNum_S_Steps = mWave -> mNum_S_Steps;

	// Before we eval all the "B" exprs, it's possiblle they use the mag() fcn--in B vars,
	// it references the most recent sample.  If there's no samples available, make mag() = 0
	if ( mSamples ) {
		__applySampleToGlobals( mSamples ) }
	else {
		mFFTPtr = &ExprVirtualMachine::sZeroFcn;
		mBass = 0;
	}

	// Eval all the "B" exprs
	mWave -> mB_Var.Evaluate();
	if ( transition )
		mNextWave -> mB_Var.Evaluate();

	// Evaluate the current background color
	_evalClr( mBackColorRGB.red,	mBackR );
	_evalClr( mBackColorRGB.green,	mBackG );
	_evalClr( mBackColorRGB.blue,	mBackB );

	clrTemp = inPort.SetBackColor( mBackColorRGB );
	if ( clrTemp != mBackColor ) {
		mBackColor = clrTemp;
		mDirtyRect = mPaneRect;
	}

	// The Camera pos
	mCamera.mPos.mX = mWave -> mCamX.Evaluate();
	mCamera.mPos.mY = mWave -> mCamY.Evaluate();
	mCamera.mPos.mZ = mWave -> mCamZ.Evaluate();

	// The Camera look direction
	mCamera.mDir.mX = mWave -> mCamLX.Evaluate();
	mCamera.mDir.mY = mWave -> mCamLY.Evaluate();
	mCamera.mDir.mZ = mWave -> mCamLZ.Evaluate();
	mCamera.mDir.subtract( mCamera.mPos );

	// The Camera "up" direction
	mCamera.mUpDir.mX = mWave -> mCamUpX.Evaluate();
	mCamera.mUpDir.mY = mWave -> mCamUpY.Evaluate();
	mCamera.mUpDir.mZ = mWave -> mCamUpZ.Evaluate();
	mCamera.mXYScale = mWave -> mXYScale;

	// Calc the main transformation matrix, T
	mCamera.CalcTransMatrix( T );

	// Erase the area that has stuff drawn on it
	outDirtyRect = mDirtyRect;
	inPort.EraseRect( &mDirtyRect );
	extents.top = 300000;		extents.left = 300000;
	extents.bottom = -300000;	extents.right = -300000;

	/*
	// Line diagnostic
	for ( float ang = 0; ang < 2*PI; ang += .3 ) {
		x = xorg + 50 * cos( ang + .05 * mT );
		y = yorg - 50 * sin( ang + .05 * mT );
		p_x = xorg + 150 * cos( ang + .05 * mT );
		p_y = yorg - 150 * sin( ang + .05 * mT );
		inPort.SetLineWidth( ang * 2 );
		inPort.Line( x, y, p_x, p_y, 0x000A0A0A );
		inPort.SetLineWidth( 1 );
		inPort.Line( x, y, p_x, p_y, 0x000A000A );
	}
	outDirtyRect.left = xorg - 160;
	outDirtyRect.right = xorg + 160;
	outDirtyRect.top = yorg - 160;
	outDirtyRect.bottom = yorg + 160;
	mRenderedRect = outDirtyRect;
	return;  */


	// Draw each sample to the screen, starting from the oldest sample
	curBlurNum = mWave -> mNumBlurs;

	// This gets bigger when the linewidth gets bigger
	borderXtra = 0;

	// Make sure t will never be > 1.0
	discardExpiredRows();

	// Draw the old samples to the new ones
	for ( sample = mSamples; sample; sample = sample -> mNext ) {

		// Link mWave.mDict1 to the sample's wave data
		// Assign the delta-time index (in secs) for this sample
		__applySampleToGlobals( sample )

		// Evaluate all the "C" expressions
		mWave -> mC_Var.Evaluate();
		if ( transition )
			mNextWave -> mC_Var.Evaluate();

		// Calc how wide this sample's linewidth is (round up if > .5)
		prevWidth = curWidth;
		curWidth = ( mWave -> mLineWidth.Evaluate() + 0.5 );
		if ( curWidth > borderXtra )
			borderXtra = curWidth;
		inPort.SetLineWidth( curWidth );

		// Evaluate vars that are indep of S (or D)
		if ( ! mWave -> mX_Dep_S )	f_x = mWave -> mX.Evaluate() - mCamera.mPos.mX;
		if ( ! mWave -> mY_Dep_S )	f_y = mWave -> mY.Evaluate() - mCamera.mPos.mY;
		if ( ! mWave -> mZ_Dep_S )	f_z = mWave -> mZ.Evaluate() - mCamera.mPos.mZ;
		if ( ! mWave -> mR_Dep_S )	_evalClr( curClr.red, mR );
		if ( ! mWave -> mG_Dep_S )	_evalClr( curClr.green, mG );
		if ( ! mWave -> mB_Dep_S )	_evalClr( curClr.blue, mB );

		for ( i = 0; i < mWave -> mNum_S_Steps; i++ ) {
			mS = ( (float) i ) / mNum_S_Steps;

			// Evaluate all the "D" expressions
			mWave -> mD_Var.Evaluate();
			if ( transition )
				mNextWave -> mD_Var.Evaluate();

			// Only evaluate expressions that are dependent on S
			pt.mX = ( mWave -> mX_Dep_S ) ? mWave -> mX.Evaluate() - mCamera.mPos.mX : f_x;
			pt.mY = ( mWave -> mY_Dep_S ) ? mWave -> mY.Evaluate() - mCamera.mPos.mY : f_y;
			pt.mZ = ( mWave -> mZ_Dep_S ) ? mWave -> mZ.Evaluate() - mCamera.mPos.mZ : f_z;
			pt.transform( T, mWave -> mPerspectiveInt );
			x = xorg + pt.mX;
			y = yorg - pt.mY;

			// Calc the screen pt and update out bounds rectangle
			__Chk( x, y );

			// Calculate the color for this point
			if ( mWave -> mR_Dep_S )	_evalClr( curClr.red, 	mR );
			if ( mWave -> mG_Dep_S )	_evalClr( curClr.green,	mG );
			if ( mWave -> mB_Dep_S )	_evalClr( curClr.blue,	mB );

			// Are we supposed to connect to the prev sample?  Also catch when we're drawin the first sample
			if ( mWave -> mConnectSamples ) {
				if ( sample != mSamples ) {
					if ( sample -> mNext )
						inPort.Line( mPt[ i ].x, mPt[ i ].y, x, y, mPt[ i ].color, curClr );
					else {
						inPort.SetLineWidth( prevWidth );
						inPort.Line( mPt[ i ].x, mPt[ i ].y, x, y, mPt[ i ].color, curClr );
						inPort.SetLineWidth( curWidth );
					}
				}
			}

			// Record key scrn info for current sample
			mPt[ i ].x = x;
			mPt[ i ].y = y;

			// Evaluate the level color (if it was given)
			if ( sample -> mNext )
				mPt[ i ].color = curClr;
			else {
				_evalClr( mPt[ i ].color.red,	mLvlR );
				_evalClr( mPt[ i ].color.green,	mLvlG );
				_evalClr( mPt[ i ].color.blue,	mLvlB );
			}

			// If we're connecting bins...
			if ( mWave -> mConnectBins && i > 0 )
				inPort.Line( x, y, mPt[ i - 1 ].x, mPt[ i - 1 ].y, mPt[ i ].color, mPt[ i - 1 ].color );

			// If we're just drawing dots...	(we can skip drawing dots if samples are already connected)
			else if ( ! mWave -> mConnectSamples || ! sample -> mNext )
				inPort.Line( x, y, x, y, mPt[ i ].color, mPt[ i ].color );
		}

		// If we're on the oldest sample, remember a color it used as backup foreground color
		if ( sample == mSamples )
			mForeColorRGB = mPt[ 0 ].color;

		// Connect bin 0 and bin N is user wants it
		if ( mWave -> mConnectFirstLast ) {
			curClr = mPt[ mWave -> mNum_S_Steps - 1 ].color;
			inPort.Line( x, y, mPt[ 0 ].x, mPt[ 0 ].y, curClr, curClr );
		}

		// Do the blur if the number of blurs is valid
		if ( mWave -> mNumBlurs > 0 ) {
			float t_scale = 1000.0 * mDT / mWave -> mSampleDuration;
			if ( t_scale <= ( (float) curBlurNum - 1.0) / mWave -> mNumBlurs ) {
				InsetRect( &extents, - borderXtra - 3, - borderXtra - 3 );
				SetRect( &mDirtyRect, &extents );
				inPort.GaussBlur( mWave -> mBlurVal, mDirtyRect, nil );
				curBlurNum--;
			}
		}
	}


	// Find a text/fore color that has an acceptable contrast with the background
	if ( mSamples ) {
		int contrast 		= EgOSUtils::CalcContrast( mBackColorRGB, mPt[ 0 ].color );
		int backupContrast	= EgOSUtils::CalcContrast( mBackColorRGB, mForeColorRGB ) ;
		if ( contrast > 40 || contrast > backupContrast )
			mForeColorRGB = mPt[ 0 ].color;
		else
			contrast = backupContrast;

		// At this point, mForeColorRGB and mBackColorRGB are set to valid values, so we can use
		if ( contrast <= 30 ) {
			RGBColor inverted;
			float ip, i = ( (float) contrast ) / 30.0;
			ip = 1.0 - i;

			EgOSUtils::CalcInverted( mBackColorRGB, inverted );

			mForeColorRGB.red	= i * mForeColorRGB.red   + ip * inverted.red;
			mForeColorRGB.green	= i * mForeColorRGB.green + ip * inverted.green;
			mForeColorRGB.blue	= i * mForeColorRGB.blue  + ip * inverted.blue;
		} }
	else {
		// cosmetic prob: when we don't have any samples, we don't have a clr for the text.
		// What do we do?  for now, we'll just invert the color
		EgOSUtils::CalcInverted( mBackColorRGB, mForeColorRGB );
	}

	// extents is a LongRect and is used in place of a Rect b/c of overflow on > 16 bit coord values
	SetRect( &mDirtyRect, &extents );

	// If we've just finished a transition, end it
	if ( transition && mLastSampleTime > mTransitionEnd ) {
		WC_WaveShape* temp = mWave;
		mWave = mNextWave;
		mNextWave = temp;
		mTransitionTime = -1;
		mDirtyRect = mPaneRect;		// Refresh everthing
	}

	// Things like line widths > 1 may have drawn a little outside our bounds rect
	::InsetRect( &mDirtyRect, -borderXtra - 1, -borderXtra - 1 );

	// The area we have to refresh either has new bits or old bits
	::UnionRect( &mDirtyRect, &outDirtyRect, &outDirtyRect );

	// The dirty area cant exceed the pane rect, so clip the dirty rect
	::IntersectRect( &mPaneRect, &outDirtyRect, &outDirtyRect );
}


/*
RGBColor* WhiteCapWorld::FindBestContrast() {
	int contrast, i;
	int bestIndex = 0;
	int backIntensity = PixPort::CalcIntensity( mBackColorRGB );
	int bestContrast = PixPort::CalcIntensity( mPt[ 0 ].color ) - backIntensity;
	bestContrast = _ABS( bestContrast );

	if ( bestContrast < 100 ) {
		for ( i = 1; i < mWave -> mNum_S_Steps; i++ ) {
			contrast = PixPort::CalcIntensity( mPt[ i ].color ) - backIntensity;
			contrast = _ABS( contrast );
			if ( contrast > bestContrast ) {
				bestIndex = i;
				bestContrast = contrast;
			}
		}
	}

	return &mPt[ bestIndex ].color;
}*/




void WhiteCapWorld::Refresh( Rect* inRect ) {
	Rect r;

	if ( ! inRect )
		inRect = &mPaneRect;

	// This world doesn't need to update anything if inRect isn't in this pane
	if ( IntersectRect( inRect, &mPaneRect, &r ) ) {

		// Make sure we erase that part of the window next time
		UnionRect( &mDirtyRect, &r, &mDirtyRect );
	}
}






void WhiteCapWorld::RecordSample( float inT, ExprUserFcn* inFFT, float inBass ) {
	Sample* sample;

	// Know the widest we possibly have
	mNum_FFT_Bins = inFFT -> mNumFcnBins;
	if ( mNum_FFT_Bins > mMaxBinsRecorded ) {
		mMaxBinsRecorded = mNum_FFT_Bins;
		mPt = (ScrnPt*) sPtBuf.Dim( sizeof( ScrnPt ) * mMaxBinsRecorded );
	}

	// Get a free sample structure
	if ( mFreeList.FetchLast( (void**) &sample ) )
		mFreeList.RemoveLast();
	else
		sample = new Sample();

	// Maintain our list of samples
	sample -> mNext = nil;
	if ( mRecentSample )
		mRecentSample -> mNext = sample;
	else
		mSamples = sample;

	// Set the sample's data
	sample -> Assign( inT, inFFT -> mFcn, mNum_FFT_Bins, inBass );

	// Update "current" sample shortcuts
	mRecentSample = sample;
	mLastSampleTime = inT;
}




void WhiteCapWorld::discardExpiredRows() {
	float dur = mWave -> mSampleDuration;
	Sample* sample = mSamples;

	while ( sample ) {

		// Step from old to newer samples, discarding until we don't have old samples
		if ( sample -> TimeOfSample() + dur < mLastSampleTime ) {
			if ( sample == mRecentSample )
				mRecentSample = nil;
			mFreeList.Add( sample );
			sample = sample -> mNext;
			mSamples = sample; }
		else
			sample = nil;
	}
}







void WhiteCapWorld::ExpireSamples() {
	Sample* sample = mSamples;

	while ( sample ) {
		mFreeList.Add( sample );
		sample = sample -> mNext;
	}

	mSamples		= nil;
	mRecentSample	= nil;
}





