
#include "XLongList.h"

#include <stdlib.h>

#include "Eg Common.h"


long XLongList::sDummy = 0;

XLongList::XLongList( ListOrderingT inOrdering ) :
	XPtrList( cOrderNotImportant ) {

	SetCompFcn( sLongComparitor, nil );
	SetListOrdering( inOrdering );
}

int XLongList::sLongComparitor( const void* inA, const void* inB, const void* ) {

	return ((long) inB - (long) inA);
}

void XLongList::SubtractRange( long inStart, long inEnd ) {

	long x, i = 1;

	while ( Fetch( i, &x ) ) {
		if ( x >= inStart && x <= inEnd )
			Remove( x );
		else
			i++;
	}
}

void XLongList::ApplyMask( long inStart, long inEnd ) {

	long x, i = 1;

	while ( Fetch( i, &x ) ) {
		if ( x < inStart || x > inEnd )
			Remove( x );
		else
			i++;
	}
}

long& XLongList::operator[] ( const long inIndex ) {

	long i;

	if ( inIndex >= 0 ) {
		if ( inIndex >= mNumElements ) {
			Dim( inIndex + 2 );
			for ( i = mNumElements; i <= inIndex; i++ )
				mBuf[ i ] = 0;
			mNumElements = inIndex + 1;
		}
		return ( (long*) mBuf )[ inIndex ]; }
	else
		return sDummy;
}
