/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2001 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Based on xmms disualization plugin mechanism */


#ifndef __SINGIT_PLUGIN_DATA_H__
#define __SINGIT_PLUGIN_DATA_H__

#include <glib.h>
#include <pthread.h>

typedef struct _DisplayerPluginData
{
	GList *dis_list;
	GList *enabled_list;
	gboolean playback_started;
	gint attachments;
	gboolean initialized;
}
DisplayerPluginData;

DisplayerPluginData* dp_data_new();
void dp_data_free(DisplayerPluginData *timeout);

/* attach to a timeout */
/* result == attach succeed ? TRUE : FALSE */
inline gboolean dp_data_attach(DisplayerPluginData *dp_data);
/* detach your timeout- free it if there are no more attachments */
/* result == freed ? TRUE : FALSE */
inline gboolean dp_data_detach(DisplayerPluginData *dp_data, gboolean free);


#endif // __SINGIT_PLUGIN_DATA_H__
