/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_PRIVATE_H__
#define __SINGIT_CONFIG_PRIVATE_H__

/* creates new config data includes attachment */
void singit_config_new();

/* save config data */
gboolean singit_config_save();
/* load config data */
gboolean singit_config_load();

/* Just saves special data */
gboolean singit_config_save_editor();
gboolean singit_config_save_positions();
gboolean singit_config_save_plugins();

/* in use - control mechanism */
/* if you use a config attach it, if none is attached config will be freed */
/* this will prevent trouble with freeing the config */

/* attach to the config file */
/* result == attach succeed ? TRUE : FALSE */
inline gboolean singit_config_attach();
/* detach your config file - free it if there are no more attachments */
/* result == freed ? TRUE : FALSE */
void singit_config_detach();

#endif  // __SINGIT_CONFIG_PRIVATE_H__
