/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "singit_config.h"
#include "singit_config_private.h"

#include "singit_main.h"

#include "singit_tools.h"

/*
#define def_html_header g_strconcat("<HTML>\n<HEAD>\n  <TITLE>", _("SingIt generated Lyrics"), \
		"</TITLE>\n</HEAD>\n", "<BODY>\n<TABLE BORDER=\"0\" CELLSPACINNG=\"2\">\n", NULL)
#define def_html_tail "</TABLE>\n</BODY>\n</HTML>\n"
*/
#define def_lyric_line "<TR><TD>%t</TD><TD>%l</TD></TR>"

#define def_html_header g_strconcat("<HTML>\n<HEAD>\n  <TITLE>", _("SingIt generated Lyrics"), \
	"</TITLE>\n<STYLE TYPE=\"text/ccs\">\n<!--\nfont.lyrictag {\n  color:#CC0000;\n}\n//-->\n</STYLE>\n", \
	"</HEAD>\n<BODY>\n", NULL)
#define def_html_tail "\n</BODY>\n</HTML>\n"

#define CONFIG_FILENAME g_strconcat(g_get_home_dir(), "/.xmms/config-singit", NULL)

GtkObject *singit_config = NULL;

extern SingitStatus singit_status;

enum {
	SC_SAVE_EDITOR,
	SC_SAVE_POSITIONS,
	SC_SAVE_PLUGINS,
};

gpointer singit_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	SingitConfigData *singit_config_data = g_malloc(sizeof(SingitConfigData));

//	g_print("Init\n");

	singit_config_data->debugEnable = FALSE;
	singit_config_data->debugLevelExcl = FALSE;
	singit_config_data->debugLevel = 9;

	singit_config_data->basePath = NULL;
	singit_config_data->constructFilename = NULL;
	singit_config_data->lyricExtension = NULL;
	singit_config_data->lyricFontName = NULL;
	singit_config_data->activeColor = NULL;
	singit_config_data->backgroundColor = NULL;
	singit_config_data->textColor = NULL;

	singit_config_data->htmlHeader = NULL;
	singit_config_data->htmlTail = NULL;
	singit_config_data->lyricLine = NULL;
	singit_config_data->underscoreWhiteTransform = 0;

	singit_config_data->enabled_dplugins = NULL;

	singit_config_data->song = NULL;

	return singit_config_data;
}

void singit_config_free_event(SingitConfigGen *scg, SingitConfigData *cfg_data, gpointer user_data)
{
//	g_print("Free\n");

	if (cfg_data->basePath) { g_free(cfg_data->basePath); }
	if (cfg_data->constructFilename) { g_free(cfg_data->constructFilename); }
	if (cfg_data->lyricExtension) { g_free(cfg_data->lyricExtension); }
	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }
	if (cfg_data->activeColor) { g_free(cfg_data->activeColor); }
	if (cfg_data->backgroundColor) { g_free(cfg_data->backgroundColor); }
	if (cfg_data->textColor) { g_free(cfg_data->textColor); }

	if (cfg_data->htmlHeader) { g_free(cfg_data->htmlHeader); }
	if (cfg_data->htmlTail) { g_free(cfg_data->htmlTail); }
	if (cfg_data->lyricLine) { g_free(cfg_data->lyricLine); }
	if (cfg_data->enabled_dplugins) { g_free(cfg_data->enabled_dplugins); }

	g_free(cfg_data);
	cfg_data = NULL;
}

void singit_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gpointer user_data)
{
	gchar *tmp;

//	g_print("Load\n");
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "hideIfNotFound", &cfg_data->hideIfNotFound))
		{ cfg_data->hideIfNotFound = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "lyricPolling", &cfg_data->lyricPolling))
		{ cfg_data->lyricPolling = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "toggleYZ", &cfg_data->toggleYZ))
		{ cfg_data->toggleYZ = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "showEmpty", &cfg_data->showEmpty))
		{ cfg_data->showEmpty = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "autoResize", &cfg_data->autoResize))
		{ cfg_data->autoResize = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "guessSyncLyrics", &cfg_data->guessSyncLyrics))
		{ cfg_data->guessSyncLyrics = TRUE; }
#	ifdef CODEDEBUG
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "debugEnable", &cfg_data->debugEnable))
		{ cfg_data->debugEnable = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "debugLevelExcl", &cfg_data->debugLevelExcl))
		{ cfg_data->debugLevelExcl = FALSE; }
	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "debugLevel", &cfg_data->debugLevel)))
		{ cfg_data->debugLevel = 9; }
#	endif
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "findOptimalFont", &cfg_data->findOptimalFont))
		{ cfg_data->useXMMSuSleep = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "useXMMSuSleep", &cfg_data->useXMMSuSleep))
		{ cfg_data->useXMMSuSleep = FALSE; }

	if (!xmms_cfg_read_string(cfg_file, "SingIt", "basePath", &(cfg_data->basePath)))
		{ cfg_data->basePath = g_strdup("~/lyrics/,~~/lyrics"); }
	if (!xmms_cfg_read_string(cfg_file, "SingIt", "constructFilename", &(cfg_data->constructFilename)))
		{ cfg_data->constructFilename = g_strdup("%1"); }
	if (!xmms_cfg_read_string(cfg_file, "SingIt", "lyricExtension", &(cfg_data->lyricExtension)))
		{ cfg_data->lyricExtension = g_strdup("txt,tag"); }
	if (!xmms_cfg_read_string(cfg_file, "SingIt", "lyricFontName", &(cfg_data->lyricFontName)))
		{ cfg_data->lyricFontName = g_strdup("-adobe-helvetica-bold-r-*-*-14-*"); }
	if (!xmms_cfg_read_string(cfg_file, "SingIt", "enabled_dplugins", &(cfg_data->enabled_dplugins)))
		{ cfg_data->enabled_dplugins = g_strdup("libdisplayer_karaoke_window.so"); }

	if (!singit_config_gen_read_color(cfg_file, "SingIt", "activeColor", &(cfg_data->activeColor)))
		{ cfg_data->activeColor = g_strdup("lightblue"); }
	if (!singit_config_gen_read_color(cfg_file, "SingIt", "backgroundColor", &(cfg_data->backgroundColor)))
		{ cfg_data->backgroundColor = g_strdup("white"); }
	if (!singit_config_gen_read_color(cfg_file, "SingIt", "textColor", &(cfg_data->textColor)))
		{ cfg_data->textColor = g_strdup("black"); }

	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "editorWinPosX", &cfg_data->editorWinPosX)))
		{ cfg_data->editorWinPosX = -1; }
	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "editorWinPosY", &cfg_data->editorWinPosY)))
		{ cfg_data->editorWinPosY = -1; }
	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "configWinPosX", &cfg_data->configWinPosX)))
		{ cfg_data->configWinPosX = -1; }
	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "configWinPosY", &cfg_data->configWinPosY)))
		{ cfg_data->configWinPosY = -1; }

	/* From lyrics exporter */
	if (!(xmms_cfg_read_string(cfg_file, "SingIt", "htmlHeader", &cfg_data->htmlHeader))) {
		cfg_data->htmlHeader = g_strdup(def_html_header);
	}
	else {
		tmp = tools_replace_string(cfg_data->htmlHeader, "\\n", "\n");
		g_free(cfg_data->htmlHeader);
		cfg_data->htmlHeader = tmp;
	}

	if (!(xmms_cfg_read_string(cfg_file, "SingIt", "htmlTail", &cfg_data->htmlTail))) {
		cfg_data->htmlTail = g_strdup(def_html_tail);
	}
	else {
		tmp = tools_replace_string(cfg_data->htmlTail, "\\n", "\n");
		g_free(cfg_data->htmlTail);
		cfg_data->htmlTail = tmp;
	}
	if (!(xmms_cfg_read_string(cfg_file, "SingIt", "lyricLine", &cfg_data->lyricLine)))
		{ cfg_data->lyricLine = g_strdup(def_lyric_line); }
	if (!(xmms_cfg_read_int(cfg_file, "SingIt", "exportMode", &cfg_data->exportMode)))
		{ cfg_data->exportMode = 0; }

	/* From lyrics editor */
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "multiSelect", &cfg_data->multiSelect))
		{ cfg_data->multiSelect = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "showHints", &cfg_data->showHints))
		{ cfg_data->showHints = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "extendedLyrics", &cfg_data->extendedLyrics))
		{ cfg_data->extendedLyrics = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "checkSyncBeforeSave", &cfg_data->checkSyncBeforeSave))
		{ cfg_data->checkSyncBeforeSave = FALSE; }
	if (!xmms_cfg_read_int(cfg_file, "SingIt", "underscoreWhiteTransform", &cfg_data->underscoreWhiteTransform))
		{ cfg_data->underscoreWhiteTransform = 600; }
	if (!xmms_cfg_read_int(cfg_file, "SingIt", "reactionTime", &cfg_data->reactionTime))
		{ cfg_data->reactionTime = 600; }
	if (!xmms_cfg_read_int(cfg_file, "SingIt", "hideIfNotFound", &cfg_data->hideIfNotFound))
		{ cfg_data->hideIfNotFound = FALSE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "showJumpingBall", &cfg_data->showJumpingBall))
		{ cfg_data->showJumpingBall = TRUE; }
	if (!xmms_cfg_read_boolean(cfg_file, "SingIt", "guessSyncLyrics", &cfg_data->guessSyncLyrics))
		{ cfg_data->guessSyncLyrics = TRUE; }
}

void write_checked_string(ConfigFile *cfg, gchar *section, gchar* entry, gchar *value)
{
	if (!value) { xmms_cfg_remove_key(cfg, section, entry); }
	else { xmms_cfg_write_string(cfg, section, entry, value); }
}

void singit_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gpointer user_data)
{
//	g_print("Save\n");

	/* boolean values */
	xmms_cfg_write_boolean(cfg_file, "SingIt", "lyricPolling", cfg_data->lyricPolling);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "toggleYZ", cfg_data->toggleYZ);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "showEmpty", cfg_data->showEmpty);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "autoResize", cfg_data->autoResize);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "hideIfNotFound", cfg_data->hideIfNotFound);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "showJumpingBall", cfg_data->showJumpingBall);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "guessSyncLyrics", cfg_data->guessSyncLyrics);
#	ifdef CODEDEBUG
	xmms_cfg_write_boolean(cfg_file, "SingIt", "debugEnable", cfg_data->debugEnable);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "debugLevelExcl", cfg_data->debugLevelExcl);
	xmms_cfg_write_int(cfg_file, "SingIt", "debugLevel", cfg_data->debugLevel);
#	endif
	xmms_cfg_write_boolean(cfg_file, "SingIt", "findOptimalFont", cfg_data->findOptimalFont);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "useXMMSuSleep", cfg_data->useXMMSuSleep);

	xmms_cfg_write_boolean(cfg_file, "SingIt", "multiSelect", cfg_data->multiSelect);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "showHints", cfg_data->showHints);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "extendedLyrics", cfg_data->extendedLyrics);
	xmms_cfg_write_boolean(cfg_file, "SingIt", "checkSyncBeforeSave", cfg_data->checkSyncBeforeSave);

	/* string values */
	write_checked_string(cfg_file, "SingIt", "basePath", cfg_data->basePath);
	write_checked_string(cfg_file, "SingIt", "constructFilename", cfg_data->constructFilename);
	write_checked_string(cfg_file, "SingIt", "lyricExtension", cfg_data->lyricExtension);
	write_checked_string(cfg_file, "SingIt", "lyricFontName", cfg_data->lyricFontName);
	write_checked_string(cfg_file, "SingIt", "activeColor", cfg_data->activeColor);
	write_checked_string(cfg_file, "SingIt", "backgroundColor", cfg_data->backgroundColor);
	write_checked_string(cfg_file, "SingIt", "textColor", cfg_data->textColor);
	write_checked_string(cfg_file, "SingIt", "enabled_dplugins", cfg_data->enabled_dplugins);

	/* integer values */
	xmms_cfg_write_int(cfg_file, "SingIt", "underscoreWhiteTransform", cfg_data->underscoreWhiteTransform);
	xmms_cfg_write_int(cfg_file, "SingIt", "reactionTime", cfg_data->reactionTime);
	xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosX", cfg_data->editorWinPosX);
	xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosY", cfg_data->editorWinPosY);
	xmms_cfg_write_int(cfg_file, "SingIt", "configWinPosX", cfg_data->configWinPosX);
	xmms_cfg_write_int(cfg_file, "SingIt", "configWinPosY", cfg_data->configWinPosY);
}

void singit_config_update_event(SingitConfigGen *scg, gpointer user_data)
{
//	g_print("Update\n");

	singit_status.config_update = TRUE;
}

void singit_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
//	g_print("Destroy\n");

	singit_config = NULL;
}

void singit_config_save_part_event(SingitConfigGen *scg, ConfigFile* cfg_file, SingitConfigData *cfg_data, gint part, gpointer user_data)
{
	switch (part) {
	case SC_SAVE_EDITOR:
		xmms_cfg_write_boolean(cfg_file, "SingIt", "multiSelect", cfg_data->multiSelect);
		xmms_cfg_write_boolean(cfg_file, "SingIt", "showHints", cfg_data->showHints);
		xmms_cfg_write_boolean(cfg_file, "SingIt", "extendedLyrics", cfg_data->extendedLyrics);
		xmms_cfg_write_boolean(cfg_file, "SingIt", "checkSyncBeforeSave", cfg_data->checkSyncBeforeSave);

		xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosX", cfg_data->editorWinPosX);
		xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosY", cfg_data->editorWinPosY);
		xmms_cfg_write_int(cfg_file, "SingIt", "underscoreWhiteTransform", cfg_data->underscoreWhiteTransform);
		break;
	case SC_SAVE_POSITIONS:
		xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosX", cfg_data->editorWinPosX);
		xmms_cfg_write_int(cfg_file, "SingIt", "editorWinPosY", cfg_data->editorWinPosY);
		xmms_cfg_write_int(cfg_file, "SingIt", "configWinPosX", cfg_data->configWinPosX);
		xmms_cfg_write_int(cfg_file, "SingIt", "configWinPosY", cfg_data->configWinPosY);
		break;
	case SC_SAVE_PLUGINS:
		write_checked_string(cfg_file, "SingIt", "enabled_dplugins", cfg_data->enabled_dplugins);
		break;
	}
}

void singit_config_new(void)
{
	if (singit_config) { return; }

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_new]\n"), 9);
#	endif

	singit_config = singit_config_gen_new(NULL);

	gtk_signal_connect(GTK_OBJECT(singit_config), "init",
		GTK_SIGNAL_FUNC(singit_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "free",
		GTK_SIGNAL_FUNC(singit_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "load",
		GTK_SIGNAL_FUNC(singit_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "save",
		GTK_SIGNAL_FUNC(singit_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "save_part",
		GTK_SIGNAL_FUNC(singit_config_save_part_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "update",
		GTK_SIGNAL_FUNC(singit_config_update_event), NULL);
	gtk_signal_connect(GTK_OBJECT(singit_config), "destroy",
		GTK_SIGNAL_FUNC(singit_config_destroy_event), NULL);
}

gboolean singit_config_load()
{
	if (singit_config != NULL) {
		return singit_config_gen_load(SINGIT_CONFIG_GEN(singit_config));
	}
	return FALSE;
}

ConfigFile* singit_config_open()
{
	ConfigFile *cfg;
	gchar *filename;

	if (!singit_config_attach()) {
		#ifdef CODEDEBUG
		DEBUG(("Failed\n"), 9);
		#endif
		return FALSE;
	}

	filename = CONFIG_FILENAME;
	cfg = xmms_cfg_open_file(filename);
	if (!cfg)
		cfg = xmms_cfg_new();
	g_free(filename);

	return cfg;
}

gboolean singit_config_close(ConfigFile *cfg, gboolean save)
{
	gchar *filename;

	if (!cfg) {
		#ifdef CODEDEBUG
		DEBUG(("Failed\n"), 9);
		#endif
		return FALSE;
	}

	filename = CONFIG_FILENAME;
	if (save)
		xmms_cfg_write_file(cfg, filename);
	xmms_cfg_free(cfg);
	g_free(filename);

	singit_config_detach(TRUE);

	#ifdef CODEDEBUG
	DEBUG(("Ok\n"), 9);
	#endif

	return TRUE;
}

gboolean singit_config_save_editor()
{
	if (singit_config) {
#		ifdef CODEDEBUG
		DEBUG(("dlg_singit_config.c [singit_config_save_editor]\n"), 9);
#		endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_EDITOR);
	}
	return FALSE;
}

gboolean singit_config_save_positions()
{
	if (singit_config) {
#		ifdef CODEDEBUG
		DEBUG(("dlg_singit_config.c [singit_config_save_positions] : "), 9);
#		endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_POSITIONS);
	}
	return FALSE;
}

gboolean singit_config_save_plugins()
{
	if (singit_config) {
#		ifdef CODEDEBUG
		DEBUG(("dlg_singit_config.c [singit_config_save_plugins] : "), 9);
#		endif
		return singit_config_gen_save_part(SINGIT_CONFIG_GEN(singit_config), SC_SAVE_PLUGINS);
	}
	return FALSE;
}

gboolean singit_config_load_plugin_position(const gchar* plugin, gint *posX, gint *posY, gint *sizeX, gint *sizeY)
{
	ConfigFile *cfg;
	gboolean result = TRUE;
	gchar *load_str;

	cfg = singit_config_open();
	if (!(cfg && plugin)) { return FALSE; }

	if (posX && result) {
		load_str = g_strconcat("dp_", plugin, "_posX", NULL);
		if (!(xmms_cfg_read_int(cfg, "SingIt", load_str, posX)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (posY && result) {
		load_str = g_strconcat("dp_", plugin, "_posY", NULL);
		if (!(xmms_cfg_read_int(cfg, "SingIt", load_str, posY)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (sizeX && result) {
		load_str = g_strconcat("dp_", plugin, "_sizeX", NULL);
		if (!(xmms_cfg_read_int(cfg, "SingIt", load_str, sizeX)))
			{ result = FALSE; }
		g_free(load_str);
	}

	if (sizeY && result) {
		load_str = g_strconcat("dp_", plugin, "_sizeY", NULL);
		if (!(xmms_cfg_read_int(cfg, "SingIt", load_str, sizeY)))
			{ result = FALSE; }
		g_free(load_str);
	}

	singit_config_close(cfg, FALSE);
	return result;
}

gboolean singit_config_save_plugin_position(const gchar* plugin, gint posX, gint posY, gint sizeX, gint sizeY)
{
	ConfigFile *cfg;
	gchar *save_str;

#	ifdef CODEDEBUG
	DEBUG(("dlg_singit_config.c [singit_config_save_plugin_position] :\n"), 9);
#	endif

	if (!plugin) { return FALSE; }

	cfg = singit_config_open();
	if (!cfg) { return FALSE; }

	if (posX >= 0) {
		save_str = g_strconcat("dp_", plugin, "_posX", NULL);
		xmms_cfg_write_int(cfg, "SingIt", save_str, posX);
		g_free(save_str);
	}

	if (posY >= 0) {
		save_str = g_strconcat("dp_", plugin, "_posY", NULL);
		xmms_cfg_write_int(cfg, "SingIt", save_str, posY);
		g_free(save_str);
	}

	if (sizeX >= 0) {
		save_str = g_strconcat("dp_", plugin, "_sizeX", NULL);
		xmms_cfg_write_int(cfg, "SingIt", save_str, sizeX);
		g_free(save_str);
	}

	if (sizeY >= 0) {
		save_str = g_strconcat("dp_", plugin, "_sizeY", NULL);
		xmms_cfg_write_int(cfg, "SingIt", save_str, sizeY);
		g_free(save_str);
	}

	return singit_config_close(cfg, TRUE);
}

gboolean singit_config_attach()
{
	return (singit_config) ? singit_config_gen_attach(SINGIT_CONFIG_GEN(singit_config)) : FALSE;
}

void singit_config_detach()
{
	singit_config_gen_detach(SINGIT_CONFIG_GEN(singit_config));
}
