/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_MULTI_LINE_H__
#define __SINGIT_MULTI_LINE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_MULTI_LINE_DIALOG            (multi_line_dialog_get_type ())
#define MULTI_LINE_DIALOG(obj)            (GTK_CHECK_CAST ((obj), TYPE_MULTI_LINE_DIALOG, MultiLineDialog))
#define MULTI_LINE_DIALOG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_MULTI_LINE_DIALOG, MultiLineDialog))
#define IS_MULTI_LINE_DIALOG(obj)         (GTK_CHECK_TYPE ((obj), TYPE_MULTI_LINE_DIALOG))
#define IS_MULTI_LINE_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_LINE_DIALOG))

typedef struct _MultiLineDialog       MultiLineDialog;
typedef struct _MultiLineDialogClass  MultiLineDialogClass;

struct _MultiLineDialog
{
	GtkWindow  window;
	GtkText   *text;

	gboolean isVisible;
	gchar*   oldText;
	gchar*   delimiter;
};

struct _MultiLineDialogClass
{
	GtkWindowClass parent_class;

	void (* new_text) (MultiLineDialog *mldlg);
	void (* button_pressed) (MultiLineDialog *mldlg);
};

GtkType    multi_line_dialog_get_type        (void);
GtkWidget* multi_line_dialog_new             (gchar  *caption,
						gint    width,
						gint    height);
void       multi_line_dialog_show            (MultiLineDialog *dialog,
						GtkWindow *parent);
void       multi_line_dialog_hide            (MultiLineDialog *dialog);

gchar*     multi_line_dialog_get_text        (MultiLineDialog *dialog);
void       multi_line_dialog_set_text        (MultiLineDialog *dialog,
						gchar* text);
void       multi_line_dialog_set_delimiter   (MultiLineDialog *dialog,
						gchar* delimiter);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __SINGIT_MULTI_LINE_H__
