/*
 *  id3 Renamer
 *  genre.h - Header for music genres
 *  Copyright (C) 1998  Robert Alto (badcrc@tscnet.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 *  Renamed and reordered to use in SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 */


#ifndef __ID3_TABLES__
#define __ID3_TABLES__

#include <id3.h>

#define genre_count 148
static char *genre_list[] = {

	"(none)",
	"Blues",
	"Classic Rock",
	"Country",
	"Dance",
	"Disco",
	"Funk",
	"Grunge",
	"Hip-Hop",
	"Jazz",
	"Metal",
	"New Age",
	"Oldies",
	"Other",
	"Pop",
	"R&B",
	"Rap",
	"Reggae",
	"Rock",
	"Techno",
	"Industrial",
	"Alternative",
	"Ska",
	"Death Metal",
	"Pranks",
	"Soundtrack",
	"Euro-Techno",
	"Ambient",
	"Trip-Hop",
	"Vocal",
	"Jazz+Funk",
	"Fusion",
	"Trance",
	"Classical",
	"Instrumental",
	"Acid",
	"House",
	"Game",
	"Sound Clip",
	"Gospel",
	"Noise",
	"Alt. Rock",
	"Bass",
	"Soul",
	"Punk",
	"Space",
	"Meditative",
	"Instrum. Pop",
	"Instrum. Rock",
	"Ethnic",
	"Gothic",
	"Darkwave",
	"Techno-Indust.",
	"Electronic",
	"Pop-Folk",
	"Eurodance",
	"Dream",
	"Southern Rock",
	"Comedy",
	"Cult",
	"Gangsta",
	"Top 40",
	"Christian Rap",
	"Pop/Funk",
	"Jungle",
	"Native American",
	"Cabaret",
	"New Wave",
	"Psychadelic",
	"Rave",
	"Showtunes",
	"Trailer",
	"Lo-Fi",
	"Tribal",
	"Acid Punk",
	"Acid Jazz",
	"Polka",
	"Retro",
	"Musical",
	"Rock & Roll",
	"Hard Rock",
	"Folk",
	"Folk/Rock",
	"National Folk",
	"Swing",
	"Fusion",
	"Bebob",
	"Latin",
	"Revival",
	"Celtic",
	"Bluegrass",
	"Avantgarde",
	"Gothic Rock",
	"Progress. Rock",
	"Psychadel. Rock",
	"Symphonic Rock",
	"Slow Rock",
	"Big Band",
	"Chorus",
	"Easy Listening",
	"Acoustic",
	"Humour",
	"Speech",
	"Chanson",
	"Opera",
	"Chamber Music",
	"Sonata",
	"Symphony",
	"Booty Bass",
	"Primus",
	"Porn Groove",
	"Satire",
/*
 *  The following were added 1999 26 Apr by Ben Gertzfield <che@debian.org>
 *  as per the list at http://mp3.musichall.cz/id3master/faq.htm but with a
 *  few spell-checks confirmed by running 'strings' on the in_mp3.dll file
 *  from winamp 2.10 (sorry :)
 */
	"Slow Jam",
	"Club",
	"Tango",
	"Samba",
	"Folklore",
	"Ballad",
	"Power Ballad",
	"Rhythmic Soul",
	"Freestyle",
	"Duet",
	"Punk Rock",
	"Drum Solo",
	"A Capella",
	"Euro-House",
	"Dance Hall",
	"Goa",
	"Drum & Bass",
	"Club-House",
	"Hardcore",
	"Terror",
	"Indie",
	"BritPop",
	"Negerpunk",
	"Polsk Punk",
	"Beat",

/*  DJ JC in da house  */
	"Christian Gangsta Rap",
	"Heavy Metal",
	"Black Metal",
	"Crossover",
	"Contemporary Christian",
	"Christian Rock",

/*  WinAmp 1.91 genres  */
	"Merengue",
	"Salsa",
	"Thrash Metal",

/*  WinAmp 1.92 genres  */
	"Anime",
	"Jpop",
	"Synthpop",
	NULL
};

#if 0
typedef struct {

	char *frameName;
	ID3_FrameID frameID;
	char *frameLongName;
}
frameTbl;

#define frame_table_count 75
static frameTbl frame_table[] = {

	{ "AENC", ID3FID_AUDIOCRYPTO,  	    "Audio encryption" },
	{ "APIC", ID3FID_PICTURE,           "Attached picture" },
	{ "COMM", ID3FID_COMMENT,           "Comments" },
	{ "COMR", ID3FID_COMMERCIAL,        "Commercial frame" },
	{ "ENCR", ID3FID_CRYPTOREG,         "Encryption method registration" },
	{ "EQUA", ID3FID_EQUALIZATION, 	    "Equalization" },
	{ "ETCO", ID3FID_EVENTTIMING, 	    "Event timing codes" },
	{ "GEOB", ID3FID_GENERALOBJECT,	    "General encapsulated object" },
	{ "GRID", ID3FID_GROUPINGREG,       "Group identification registration" },
	{ "IPLS", ID3FID_INVOLVEDPEOPLE,    "Involved people list" },
	{ "LINK", ID3FID_LINKEDINFO,        "Linked information" },
	{ "MCDI", ID3FID_CDID,              "Music CD identifier" },
	{ "MLLT", ID3FID_MPEGLOOKUP,        "MPEG location lookup table" },
	{ "OWNE", ID3FID_OWNERSHIP,         "Ownership frame" },
	{ "PRIV", ID3FID_PRIVATE,           "Private frame" },
	{ "PCNT", ID3FID_PLAYCOUNTER,       "Play counter" },
	{ "POPM", ID3FID_POPULARIMETER,     "Popularimeter" },
	{ "POSS", ID3FID_POSITIONSYNC,      "Position synchronisation frame" },
	{ "RBUF", ID3FID_BUFFERSIZE,        "Recommended buffer size" },
	{ "RVAD", ID3FID_VOLUMEADJ,         "Relative volume adjustment" },
	{ "RVRB", ID3FID_REVERB,            "Reverb" },
	{ "SYLT", ID3FID_SYNCEDLYRICS,      "Synchronized lyric/text" },
	{ "SYTC", ID3FID_SYNCEDTEMPO,       "Synchronized tempo codes" },
	{ "TALB", ID3FID_ALBUM,             "Album/Movie/Show title" },
	{ "TBPM", ID3FID_BPM,               "BPM (beats per minute)" },
	{ "TCOM", ID3FID_COMPOSER,          "Composer" },
	{ "TCON", ID3FID_CONTENTTYPE,       "Content type" },
	{ "TCOP", ID3FID_COPYRIGHT,         "Copyright message" },
	{ "TDAT", ID3FID_DATE,              "Date" },
	{ "TDLY", ID3FID_PLAYLISTDELAY,     "Playlist delay" },
	{ "TENC", ID3FID_ENCODEDBY,         "Encoded by" },
	{ "TEXT", ID3FID_LYRICIST,          "Lyricist/Text writer" },
	{ "TFLT", ID3FID_FILETYPE,          "File type" },
	{ "TIME", ID3FID_TIME,              "Time" },
	{ "TIT1", ID3FID_CONTENTGROUP,      "Content group description" },
	{ "TIT2", ID3FID_TITLE,             "Title/songname/content description" },
	{ "TIT3", ID3FID_SUBTITLE,          "Subtitle/Description refinement" },
	{ "TKEY", ID3FID_INITIALKEY,        "Initial key" },
	{ "TLAN", ID3FID_LANGUAGE,          "Language(s)" },
	{ "TLEN", ID3FID_SONGLEN,           "Length" },
	{ "TMED", ID3FID_MEDIATYPE,         "Media type" },
	{ "TOAL", ID3FID_ORIGALBUM,         "Original album/movie/show title" },
	{ "TOFN", ID3FID_ORIGFILENAME,      "Original filename" },
	{ "TOLY", ID3FID_ORIGLYRICIST,      "Original lyricist(s)/text writer(s)" },
	{ "TOPE", ID3FID_ORIGARTIST,        "Original artist(s)/performer(s)" },
	{ "TORY", ID3FID_ORIGYEAR,          "Original release year" },
	{ "TOWN", ID3FID_FILEOWNER,         "File owner/licensee" },
	{ "TPE1", ID3FID_LEADARTIST,        "Lead performer(s)/Soloist(s)" },
	{ "TPE2", ID3FID_BAND,              "Band/orchestra/accompaniment" },
	{ "TPE3", ID3FID_CONDUCTOR,         "Conductor/performer refinement" },
	{ "TPE4", ID3FID_MIXARTIST,         "Interpreted, remixed, or otherwise modified by" },
	{ "TPOS", ID3FID_PARTINSET,         "Part of a set" },
	{ "TPUB", ID3FID_PUBLISHER,         "Publisher" },
	{ "TRCK", ID3FID_TRACKNUM,          "Track number/Position in set" },
	{ "TRDA", ID3FID_RECORDINGDATES,    "Recording dates" },
	{ "TRSN", ID3FID_NETRADIOSTATION,   "Internet radio station name" },
	{ "TRSO", ID3FID_NETRADIOOWNER,     "Internet radio station owner" },
	{ "TSIZ", ID3FID_SIZE,              "Size" },
	{ "TSRC", ID3FID_ISRC,              "ISRC (international standard recording code)" },
	{ "TSSE", ID3FID_ENCODERSETTINGS,   "Software/Hardware and settings used for encoding" },
	{ "TXXX", ID3FID_USERTEXT,          "User defined text information" },
	{ "TYER", ID3FID_YEAR,              "Year" },
	{ "UFID", ID3FID_UNIQUEFILEID,      "Unique file identifier" },
	{ "USER", ID3FID_TERMSOFUSE,        "Terms of use" },
	{ "USLT", ID3FID_UNSYNCEDLYRICS,    "Unsynchronized lyric/text transcription" },
	{ "WCOM", ID3FID_WWWCOMMERCIALINFO, "Commercial information" },
	{ "WCOP", ID3FID_WWWCOPYRIGHT,      "Copyright/Legal infromation" },
	{ "WOAF", ID3FID_WWWAUDIOFILE,      "Official audio file webpage" },
	{ "WOAR", ID3FID_WWWARTIST,         "Official artist/performer webpage" },
	{ "WOAS", ID3FID_WWWAUDIOSOURCE,    "Official audio source webpage" },
	{ "WORS", ID3FID_WWWRADIOPAGE,      "Official internet radio station homepage" },
	{ "WPAY", ID3FID_WWWPAYMENT,        "Payment" },
	{ "WPUB", ID3FID_WWWPUBLISHER,      "Official publisher webpage" },
	{ "WXXX", ID3FID_WWWUSER,           "User defined URL link" },
	{ "    ", ID3FID_METACRYPTO,        "Encrypted meta frame" },
	{ "????", ID3FID_NOFRAME,           "Error" },
	{ NULL }
};
#endif

typedef struct
{
	char *language_iso;
	char *language_string;
}
language_table_entry;

#define language_list_count 428
static language_table_entry language_table[] = {

	{ "   ", "(unknown)" },
	{ "aar", "Afar" },
	{ "abk", "Abkhazian" },
	{ "ace", "Achinese" },
	{ "ach", "Acoli" },
	{ "ada", "Adangme" },
	{ "afa", "Afro-Asiatic (Other)" },
	{ "afh", "Afrihili" },
	{ "afr", "Afrikaans" },
	{ "aka", "Akan" },
	{ "akk", "Akkadian" },
	{ "alb", "Albanian" },
	{ "ale", "Aleut" },
	{ "alg", "Algonquian Languages" },
	{ "amh", "Amharic" },
	{ "ang", "English, Old (ca. 450-1100)" },
	{ "apa", "Apache Languages" },
	{ "ara", "Arabic" },
	{ "arc", "Aramaic" },
	{ "arm", "Armenian" },
	{ "arn", "Araucanian" },
	{ "arp", "Arapaho" },
	{ "art", "Artificial (Other)" },
	{ "arw", "Arawak" },
	{ "asm", "Assamese" },
	{ "ath", "Athapascan Languages" },
	{ "ava", "Avaric" },
	{ "ave", "Avestan" },
	{ "awa", "Awadhi" },
	{ "aym", "Aymara" },
	{ "aze", "Azerbaijani" },
	{ "bad", "Banda" },
	{ "bai", "Bamileke Languages" },
	{ "bak", "Bashkir" },
	{ "bal", "Baluchi" },
	{ "bam", "Bambara" },
	{ "ban", "Balinese" },
	{ "baq", "Basque" },
	{ "bas", "Basa" },
	{ "bat", "Baltic (Other)" },
	{ "bej", "Beja" },
	{ "bel", "Byelorussian" },
	{ "bem", "Bemba" },
	{ "ben", "Bengali" },
	{ "ber", "Berber (Other)" },
	{ "bho", "Bhojpuri" },
	{ "bih", "Bihari" },
	{ "bik", "Bikol" },
	{ "bin", "Bini" },
	{ "bis", "Bislama" },
	{ "bla", "Siksika" },
	{ "bnt", "Bantu (Other)" },
	{ "bod", "Tibetan" },
	{ "bra", "Braj" },
	{ "bre", "Breton" },
	{ "bua", "Buriat" },
	{ "bug", "Buginese" },
	{ "bul", "Bulgarian" },
	{ "bur", "Burmese" },
	{ "cad", "Caddo" },
	{ "cai", "Central American Indian (Other)" },
	{ "car", "Carib" },
	{ "cat", "Catalan" },
	{ "cau", "Caucasian (Other)" },
	{ "ceb", "Cebuano" },
	{ "cel", "Celtic (Other)" },
	{ "ces", "Czech" },
	{ "cha", "Chamorro" },
	{ "chb", "Chibcha" },
	{ "che", "Chechen" },
	{ "chg", "Chagatai" },
	{ "chi", "Chinese" },
	{ "chm", "Mari" },
	{ "chn", "Chinook jargon" },
	{ "cho", "Choctaw" },
	{ "chr", "Cherokee" },
	{ "chu", "Church Slavic" },
	{ "chv", "Chuvash" },
	{ "chy", "Cheyenne" },
	{ "cop", "Coptic" },
	{ "cor", "Cornish" },
	{ "cos", "Corsican" },
	{ "cpe", "Creoles and Pidgins, English-based (Other)" },
	{ "cpf", "Creoles and Pidgins, French-based (Other)" },
	{ "cpp", "Creoles and Pidgins, Portuguese-based (Other)" },
	{ "cre", "Cree" },
	{ "crp", "Creoles and Pidgins (Other)" },
	{ "cus", "Cushitic (Other)" },
	{ "cym", "Welsh" },
	{ "cze", "Czech" },
	{ "dak", "Dakota" },
	{ "dan", "Danish" },
	{ "del", "Delaware" },
	{ "deu", "German" },
	{ "din", "Dinka" },
	{ "div", "Divehi" },
	{ "doi", "Dogri" },
	{ "dra", "Dravidian (Other)" },
	{ "dua", "Duala" },
	{ "dum", "Dutch, Middle (ca. 1050-1350)" },
	{ "dut", "Dutch" },
	{ "dyu", "Dyula" },
	{ "dzo", "Dzongkha" },
	{ "efi", "Efik" },
	{ "egy", "Egyptian (Ancient)" },
	{ "eka", "Ekajuk" },
	{ "ell", "Greek, Modern (1453-)" },
	{ "elx", "Elamite" },
	{ "eng", "English" },
	{ "enm", "English, Middle (ca. 1100-1500)" },
	{ "epo", "Esperanto" },
	{ "esk", "Eskimo (Other)" },
	{ "esl", "Spanish" },
	{ "est", "Estonian" },
	{ "eus", "Basque" },
	{ "ewe", "Ewe" },
	{ "ewo", "Ewondo" },
	{ "fan", "Fang" },
	{ "fao", "Faroese" },
	{ "fas", "Persian" },
	{ "fat", "Fanti" },
	{ "fij", "Fijian" },
	{ "fin", "Finnish" },
	{ "fiu", "Finno-Ugrian (Other)" },
	{ "fon", "Fon" },
	{ "fra", "French" },
	{ "fre", "French" },
	{ "frm", "French, Middle (ca. 1400-1600)" },
	{ "fro", "French, Old (842- ca. 1400)" },
	{ "fry", "Frisian" },
	{ "ful", "Fulah" },
	{ "gaa", "Ga" },
	{ "gae", "Gaelic (Scots)" },
	{ "gai", "Irish" },
	{ "gay", "Gayo" },
	{ "gdh", "Gaelic (Scots)" },
	{ "gem", "Germanic (Other)" },
	{ "geo", "Georgian" },
	{ "ger", "German" },
	{ "gez", "Geez" },
	{ "gil", "Gilbertese" },
	{ "glg", "Gallegan" },
	{ "gmh", "German, Middle High (ca. 1050-1500)" },
	{ "goh", "German, Old High (ca. 750-1050)" },
	{ "gon", "Gondi" },
	{ "got", "Gothic" },
	{ "grb", "Grebo" },
	{ "grc", "Greek, Ancient (to 1453)" },
	{ "gre", "Greek, Modern (1453-)" },
	{ "grn", "Guarani" },
	{ "guj", "Gujarati" },
	{ "hai", "Haida" },
	{ "hau", "Hausa" },
	{ "haw", "Hawaiian" },
	{ "heb", "Hebrew" },
	{ "her", "Herero" },
	{ "hil", "Hiligaynon" },
	{ "him", "Himachali" },
	{ "hin", "Hindi" },
	{ "hmo", "Hiri Motu" },
	{ "hun", "Hungarian" },
	{ "hup", "Hupa" },
	{ "hye", "Armenian" },
	{ "iba", "Iban" },
	{ "ibo", "Igbo" },
	{ "ice", "Icelandic" },
	{ "ijo", "Ijo" },
	{ "iku", "Inuktitut" },
	{ "ilo", "Iloko" },
	{ "ina", "Interlingua (International Auxiliary language Association)" },
	{ "inc", "Indic (Other)" },
	{ "ind", "Indonesian" },
	{ "ine", "Indo-European (Other)" },
	{ "ine", "Interlingue" },
	{ "ipk", "Inupiak" },
	{ "ira", "Iranian (Other)" },
	{ "iri", "Irish" },
	{ "iro", "Iroquoian uages" },
	{ "isl", "Icelandic" },
	{ "ita", "Italian" },
	{ "jav", "Javanese" },
	{ "jaw", "Javanese" },
	{ "jpn", "Japanese" },
	{ "jpr", "Judeo-Persian" },
	{ "jrb", "Judeo-Arabic" },
	{ "kaa", "Kara-Kalpak" },
	{ "kab", "Kabyle" },
	{ "kac", "Kachin" },
	{ "kal", "Greenlandic" },
	{ "kam", "Kamba" },
	{ "kan", "Kannada" },
	{ "kar", "Karen" },
	{ "kas", "Kashmiri" },
	{ "kat", "Georgian" },
	{ "kau", "Kanuri" },
	{ "kaw", "Kawi" },
	{ "kaz", "Kazakh" },
	{ "kha", "Khasi" },
	{ "khi", "Khoisan (Other)" },
	{ "khm", "Khmer" },
	{ "kho", "Khotanese" },
	{ "kik", "Kikuyu" },
	{ "kin", "Kinyarwanda" },
	{ "kir", "Kirghiz" },
	{ "kok", "Konkani" },
	{ "kom", "Komi" },
	{ "kon", "Kongo" },
	{ "kor", "Korean" },
	{ "kpe", "Kpelle" },
	{ "kro", "Kru" },
	{ "kru", "Kurukh" },
	{ "kua", "Kuanyama" },
	{ "kum", "Kumyk" },
	{ "kur", "Kurdish" },
	{ "kus", "Kusaie" },
	{ "kut", "Kutenai" },
	{ "lad", "Ladino" },
	{ "lah", "Lahnda" },
	{ "lam", "Lamba" },
	{ "lao", "Lao" },
	{ "lat", "Latin" },
	{ "lav", "Latvian" },
	{ "lez", "Lezghian" },
	{ "lin", "Lingala" },
	{ "lit", "Lithuanian" },
	{ "lol", "Mongo" },
	{ "loz", "Lozi" },
	{ "ltz", "Letzeburgesch" },
	{ "lub", "Luba-Katanga" },
	{ "lug", "Ganda" },
	{ "lui", "Luiseno" },
	{ "lun", "Lunda" },
	{ "luo", "Luo (Kenya and Tanzania)" },
	{ "mac", "Macedonian" },
	{ "mad", "Madurese" },
	{ "mag", "Magahi" },
	{ "mah", "Marshall" },
	{ "mai", "Maithili" },
	{ "mak", "Macedonian" },
	{ "mak", "Makasar" },
	{ "mal", "Malayalam" },
	{ "man", "Mandingo" },
	{ "mao", "Maori" },
	{ "map", "Austronesian (Other)" },
	{ "mar", "Marathi" },
	{ "mas", "Masai" },
	{ "max", "Manx" },
	{ "may", "Malay" },
	{ "men", "Mende" },
	{ "mga", "Irish, Middle (900 - 1200)" },
	{ "mic", "Micmac" },
	{ "min", "Minangkabau" },
	{ "mis", "Miscellaneous (Other)" },
	{ "mkh", "Mon-Kmer (Other)" },
	{ "mlg", "Malagasy" },
	{ "mlt", "Maltese" },
	{ "mni", "Manipuri" },
	{ "mno", "Manobo Languages" },
	{ "moh", "Mohawk" },
	{ "mol", "Moldavian" },
	{ "mon", "Mongolian" },
	{ "mos", "Mossi" },
	{ "mri", "Maori" },
	{ "msa", "Malay" },
	{ "mul", "Multiple Languages" },
	{ "mun", "Munda Languages" },
	{ "mus", "Creek" },
	{ "mwr", "Marwari" },
	{ "mya", "Burmese" },
	{ "myn", "Mayan Languages" },
	{ "nah", "Aztec" },
	{ "nai", "North American Indian (Other)" },
	{ "nau", "Nauru" },
	{ "nav", "Navajo" },
	{ "nbl", "Ndebele, South" },
	{ "nde", "Ndebele, North" },
	{ "ndo", "Ndongo" },
	{ "nep", "Nepali" },
	{ "new", "Newari" },
	{ "nic", "Niger-Kordofanian (Other)" },
	{ "niu", "Niuean" },
	{ "nla", "Dutch" },
	{ "nno", "Norwegian (Nynorsk)" },
	{ "non", "Norse, Old" },
	{ "nor", "Norwegian" },
	{ "nso", "Sotho, Northern" },
	{ "nub", "Nubian Languages" },
	{ "nya", "Nyanja" },
	{ "nym", "Nyamwezi" },
	{ "nyn", "Nyankole" },
	{ "nyo", "Nyoro" },
	{ "nzi", "Nzima" },
	{ "oci", "Langue d'Oc (post 1500)" },
	{ "oji", "Ojibwa" },
	{ "ori", "Oriya" },
	{ "orm", "Oromo" },
	{ "osa", "Osage" },
	{ "oss", "Ossetic" },
	{ "ota", "Turkish, Ottoman (1500 - 1928)" },
	{ "oto", "Otomian Languages" },
	{ "paa", "Papuan-Australian (Other)" },
	{ "pag", "Pangasinan" },
	{ "pal", "Pahlavi" },
	{ "pam", "Pampanga" },
	{ "pan", "Panjabi" },
	{ "pap", "Papiamento" },
	{ "pau", "Palauan" },
	{ "peo", "Persian, Old (ca 600 - 400 B.C.)" },
	{ "per", "Persian" },
	{ "phn", "Phoenician" },
	{ "pli", "Pali" },
	{ "pol", "Polish" },
	{ "pon", "Ponape" },
	{ "por", "Portuguese" },
	{ "pra", "Prakrit uages" },
	{ "pro", "Provencal, Old (to 1500)" },
	{ "pus", "Pushto" },
	{ "que", "Quechua" },
	{ "raj", "Rajasthani" },
	{ "rar", "Rarotongan" },
	{ "roa", "Romance (Other)" },
	{ "roh", "Rhaeto-Romance" },
	{ "rom", "Romany" },
	{ "ron", "Romanian" },
	{ "rum", "Romanian" },
	{ "run", "Rundi" },
	{ "rus", "Russian" },
	{ "sad", "Sandawe" },
	{ "sag", "Sango" },
	{ "sah", "Yakut" },
	{ "sai", "South American Indian (Other)" },
	{ "sal", "Salishan Languages" },
	{ "sam", "Samaritan Aramaic" },
	{ "san", "Sanskrit" },
	{ "sco", "Scots" },
	{ "scr", "Serbo-Croatian" },
	{ "sel", "Selkup" },
	{ "sem", "Semitic (Other)" },
	{ "sga", "Irish, Old (to 900)" },
	{ "shn", "Shan" },
	{ "sid", "Sidamo" },
	{ "sin", "Singhalese" },
	{ "sio", "Siouan Languages" },
	{ "sit", "Sino-Tibetan (Other)" },
	{ "sla", "Slavic (Other)" },
	{ "slk", "Slovak" },
	{ "slo", "Slovak" },
	{ "slv", "Slovenian" },
	{ "smi", "Sami Languages" },
	{ "smo", "Samoan" },
	{ "sna", "Shona" },
	{ "snd", "Sindhi" },
	{ "sog", "Sogdian" },
	{ "som", "Somali" },
	{ "son", "Songhai" },
	{ "sot", "Sotho, Southern" },
	{ "spa", "Spanish" },
	{ "sqi", "Albanian" },
	{ "srd", "Sardinian" },
	{ "srr", "Serer" },
	{ "ssa", "Nilo-Saharan (Other)" },
	{ "ssw", "Siswant" },
	{ "ssw", "Swazi" },
	{ "suk", "Sukuma" },
	{ "sun", "Sudanese" },
	{ "sus", "Susu" },
	{ "sux", "Sumerian" },
	{ "sve", "Swedish" },
	{ "swa", "Swahili" },
	{ "swe", "Swedish" },
	{ "syr", "Syriac" },
	{ "tah", "Tahitian" },
	{ "tam", "Tamil" },
	{ "tat", "Tatar" },
	{ "tel", "Telugu" },
	{ "tem", "Timne" },
	{ "ter", "Tereno" },
	{ "tgk", "Tajik" },
	{ "tgl", "Tagalog" },
	{ "tha", "Thai" },
	{ "tib", "Tibetan" },
	{ "tig", "Tigre" },
	{ "tir", "Tigrinya" },
	{ "tiv", "Tivi" },
	{ "tli", "Tlingit" },
	{ "tmh", "Tamashek" },
	{ "tog", "Tonga (Nyasa)" },
	{ "ton", "Tonga (Tonga Islands)" },
	{ "tru", "Truk" },
	{ "tsi", "Tsimshian" },
	{ "tsn", "Tswana" },
	{ "tso", "Tsonga" },
	{ "tuk", "Turkmen" },
	{ "tum", "Tumbuka" },
	{ "tur", "Turkish" },
	{ "tut", "Altaic (Other)" },
	{ "twi", "Twi" },
	{ "tyv", "Tuvinian" },
	{ "uga", "Ugaritic" },
	{ "uig", "Uighur" },
	{ "ukr", "Ukrainian" },
	{ "umb", "Umbundu" },
	{ "und", "Undetermined" },
	{ "urd", "Urdu" },
	{ "uzb", "Uzbek" },
	{ "vai", "Vai" },
	{ "ven", "Venda" },
	{ "vie", "Vietnamese" },
	{ "vol", "Volap&uuml;k" },
	{ "vot", "Votic" },
	{ "wak", "Wakashan Languages" },
	{ "wal", "Walamo" },
	{ "war", "Waray" },
	{ "was", "Washo" },
	{ "wel", "Welsh" },
	{ "wen", "Sorbian Languages" },
	{ "wol", "Wolof" },
	{ "xho", "Xhosa" },
	{ "yao", "Yao" },
	{ "yap", "Yap" },
	{ "yid", "Yiddish" },
	{ "yor", "Yoruba" },
	{ "zap", "Zapotec" },
	{ "zen", "Zenaga" },
	{ "zha", "Zhuang" },
	{ "zho", "Chinese" },
	{ "zul", "Zulu" },
	{ "zun", "Zuni" },
	{ NULL }
};

#endif // __ID3_TABLES__
