/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DLG_MESSAGEBOX_H__
#define __DLG_MESSAGEBOX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_MESSAGE_BOX_DIALOG            (message_box_dialog_get_type ())
#define MESSAGE_BOX_DIALOG(obj)            (GTK_CHECK_CAST ((obj), TYPE_MESSAGE_BOX_DIALOG, MessageBoxDialog))
#define MESSAGE_BOX_DIALOG_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_MESSAGE_BOX_DIALOG, MessageBoxDialog))
#define IS_MESSAGE_BOX_DIALOG(obj)         (GTK_CHECK_TYPE ((obj), TYPE_MESSAGE_BOX_DIALOG))
#define IS_MESSAGE_BOX_DIALOG_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_MESSAGE_BOX_DIALOG))

typedef struct _MessageBoxDialog       MessageBoxDialog;
typedef struct _MessageBoxDialogClass  MessageBoxDialogClass;

struct _MessageBoxDialog {

	GtkWindow  window;

	GtkWidget *vbox;
	GtkWidget *action_area;
	GtkWidget *button_hbox;
	GtkWidget *std_button;
	GtkWidget *label;

	gint       button_counter;
	gint       result_button;
	gboolean   isVisible;
};

struct _MessageBoxDialogClass {

	GtkWindowClass parent_class;

	void (* button_pressed) (MessageBoxDialog *mdlg, gint buttonNr);
};


GtkType    message_box_dialog_get_type        (void);
GtkWidget *message_box_dialog_new             (gchar  *title,
						gchar  *text,
						gchar  *buttonText,
						gint    width,
						gint    height);
guint      message_box_dialog_append_button   (MessageBoxDialog *dialog,
						gchar  *title,
						GtkSignalFunc func);
guint      message_box_dialog_prepend_button  (MessageBoxDialog *dialog,
						gchar  *title,
						GtkSignalFunc func);
void       message_box_dialog_show            (MessageBoxDialog *dialog, GtkWindow *parent);
void       message_box_dialog_hide            (MessageBoxDialog *dialog);

void       message_box_dialog_set_text        (MessageBoxDialog *dialog, gchar *text);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  // __DLG_MESSAGEBOX_H__
