/*
    xmms-rplay is an output plugin for xmms that talks to rplay
    Copyright (C) 2002-2003 lmoore@tump.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    thanks to esdout for guidance.
 */
#ifndef _rplayout_h_
#define _rplayout_h_

#include <xmms/plugin.h>

typedef struct {
  char  *server;
  int   port;
  int   buffer_size;
} RPlayOutConfig;

extern RPlayOutConfig   rp_config;
extern OutputPlugin     rp_op;

void rp_init();
void rp_about();
void rp_configure();
void rp_get_volume(int *, int *);
void rp_set_volume(int, int);
int rp_open_audio(AFormat, int, int);
void rp_close_audio();
void rp_write_audio(void*, int);
void rp_flush(int);
void rp_pause(short);
int rp_buffer_free();
int rp_buffer_playing();
int rp_output_time();
int rp_written_time();

#endif
