#ifndef PARSER_H
#define PARSER_H

#include <qregexp.h>
#include <qxml.h>
#include <qobject.h>

#include <vector>

#include "lyricsentry.h"

using namespace std;

class Parser : public QObject, public QXmlDefaultHandler {

public:
  Parser();
  ~Parser();

  virtual bool startDocument() { return false; }
  virtual bool endDocument() { return false; }

  virtual bool startElement(const QString & ns, const QString & local,
			      const QString & qName, const QXmlAttributes & a) { return false; }
  virtual bool endElement(const QString & ns, const QString & local,
			  const QString & qName) { return false; }
  virtual bool characters(const QString & ch) { return false; }
};

class SongParser : public Parser {

  enum { NONE = 0, TEXT };

 public:

  SongParser(QString a, QString t);

  virtual bool startDocument();
  virtual bool endDocument();
  virtual bool startElement(const QString & ns, const QString & local,
		    const QString & qName, const QXmlAttributes & a);
  virtual bool endElement(const QString & ns, const QString & local,
		  const QString & qName);
  virtual bool characters(const QString & ch);

  QString *getText();

  QString getArtist() {
    return artist;
  }

  QString getTitle() {
    return title;
  }

 signals:

 private:

  QString *text;
  int mode;

  QString artist;
  QString title;
};


class ResultParser : public Parser {

  enum { NONE = 0, NAME, TITLE };

 public:

  ResultParser(QString artist, QString title);
  ~ResultParser();

  virtual bool startDocument();
  virtual bool endDocument();
  virtual bool startElement(const QString & ns, const QString & local,
		    const QString & qName, const QXmlAttributes & a);
  virtual bool endElement(const QString & ns, const QString & local,
		  const QString & qName);
  virtual bool characters(const QString & ch);

  Entry *getEntry();

 signals:

 private:

  Entry *entry;
  Entry *result;

  int mode;

  QString artist;
  QString title;

  QRegExp ar;
  QRegExp tr;  
};


#endif
