/*
 * Copyright 2001 Computing Research Labs, New Mexico State University
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COMPUTING RESEARCH LAB OR NEW MEXICO STATE UNIVERSITY BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _h_XmuttGEditToolbarBitmaps
#define _h_XmuttGEditToolbarBitmaps

/*
 * $Id: bitmaps.h,v 1.4 2001/09/19 21:00:43 mleisher Exp $
 */

 /**************************************************************************
  *
  * Bitmaps for the glyph editor toolbar.
  *
  **************************************************************************/

/*
 * Define the width and height of all the bitmaps used in the toolbar.
 */
#define _GETB_WIDTH  16
#define _GETB_HEIGHT 16

static unsigned char copy_bits[] = {
   0xff, 0x3f, 0x01, 0x20, 0xfd, 0xff, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0xa0,
   0x05, 0xa0, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0xa0, 0x05, 0xa0,
   0x05, 0xa0, 0xff, 0xbf, 0x04, 0x80, 0xfc, 0xff};

#if 0
static unsigned char crop_bits[] = {
   0x80, 0x01, 0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0x00, 0x00, 0xe0, 0x07,
   0x24, 0x24, 0x2f, 0xf4, 0x2f, 0xf4, 0x24, 0x24, 0xe0, 0x07, 0x00, 0x00,
   0x80, 0x01, 0xc0, 0x03, 0x80, 0x01, 0x80, 0x01};
#endif

static unsigned char dleft_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x03, 0xc0, 0x07, 0xec, 0x0f,
   0xfc, 0x1f, 0xfc, 0x3f, 0xfc, 0x1f, 0xfc, 0x0f, 0xfc, 0x07, 0xfc, 0x03,
   0xfc, 0x07, 0xfc, 0x07, 0x00, 0x00, 0x00, 0x00};

static unsigned char down_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0xe0, 0x07, 0xe0, 0x07, 0xe0, 0x07,
   0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f, 0xe0, 0x07,
   0xc0, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00};

static unsigned char draw_bits[] = {
   0x00, 0x0e, 0x00, 0x1e, 0x00, 0x09, 0x00, 0x09, 0x80, 0x04, 0x80, 0x04,
   0x40, 0x02, 0x40, 0x02, 0x20, 0x01, 0x20, 0x01, 0x90, 0x00, 0x90, 0x00,
   0x48, 0x00, 0x48, 0x00, 0x38, 0x00, 0x18, 0x00};

static unsigned char dright_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xc0, 0x01, 0xe0, 0x03, 0xf0, 0x37,
   0xf8, 0x3f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf0, 0x3f, 0xe0, 0x3f, 0xc0, 0x3f,
   0xe0, 0x3f, 0xe0, 0x3f, 0x00, 0x00, 0x00, 0x00};

static unsigned char fliph_bits[] = {
   0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xfe, 0x6d, 0x82, 0x41,
   0x82, 0x01, 0x82, 0x41, 0x82, 0x41, 0x82, 0x01, 0x82, 0x41, 0xfe, 0x6d,
   0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00};

static unsigned char flipv_bits[] = {
   0x00, 0x00, 0xf0, 0x0f, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x08,
   0x10, 0x08, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00, 0x10, 0x08, 0x10, 0x08,
   0x00, 0x00, 0x10, 0x08, 0xb0, 0x0d, 0x00, 0x00};

static unsigned char left_bits[] = {
   0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0xc0, 0x03, 0xe0, 0x03, 0xf0, 0x3f,
   0xf8, 0x3f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf0, 0x3f, 0xe0, 0x03,
   0xc0, 0x03, 0x80, 0x03, 0x00, 0x03, 0x00, 0x00};

static unsigned char move_bits[] = {
   0x33, 0x33, 0x01, 0x20, 0xfc, 0xff, 0x04, 0x80, 0x05, 0xa0, 0x05, 0xa0,
   0x04, 0x80, 0x04, 0x80, 0x05, 0xa0, 0x05, 0xa0, 0x04, 0x80, 0x04, 0x80,
   0x05, 0xa0, 0x37, 0xb3, 0x04, 0x80, 0xfc, 0xff};

#if 0
static unsigned char origin_bits[] = {
   0x30, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00,
   0x30, 0x00, 0x00, 0x00, 0x30, 0x00, 0x30, 0x00, 0xdb, 0xb6, 0xdb, 0xb6,
   0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x30, 0x00};
#endif

static unsigned char right_bits[] = {
   0x00, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0, 0x03, 0xc0, 0x07, 0xfc, 0x0f,
   0xfc, 0x1f, 0xfc, 0x3f, 0xfc, 0x3f, 0xfc, 0x1f, 0xfc, 0x0f, 0xc0, 0x07,
   0xc0, 0x03, 0xc0, 0x01, 0xc0, 0x00, 0x00, 0x00};

static unsigned char rleft_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x70, 0x00, 0x78, 0x00, 0xfc, 0x3f,
   0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x7f, 0x78, 0x78, 0x70, 0x78, 0x60, 0x78,
   0x00, 0x78, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00};

static unsigned char rotate_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x07, 0xf8, 0x1f, 0xf8, 0x1f, 0x3c, 0x3c,
   0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x39, 0x1c, 0x3f, 0x1c, 0x3f, 0x3c, 0x1f,
   0x78, 0x1f, 0x70, 0x3f, 0x00, 0x00, 0x00, 0x00};

static unsigned char rright_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x0e, 0x00, 0x1e, 0xfc, 0x3f,
   0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x3f, 0x1e, 0x1e, 0x1e, 0x0e, 0x1e, 0x06,
   0x1e, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00};

static unsigned char shear_bits[] = {
   0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x78, 0x40, 0x88, 0x22, 0x08, 0x13,
   0x88, 0x0b, 0x08, 0x04, 0x08, 0x02, 0x08, 0x01, 0x88, 0x00, 0x48, 0x00,
   0xfe, 0x7f, 0x08, 0x00, 0x08, 0x00, 0x00, 0x00};

#if 0
static unsigned char select_bits[] = {
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00, 0x00, 0x00, 0x06, 0x60,
   0x06, 0x60, 0x00, 0x00, 0x00, 0x00, 0x06, 0x60, 0x06, 0x60, 0x00, 0x00,
   0x00, 0x00, 0x66, 0x66, 0x66, 0x66, 0x00, 0x00};
#endif

static unsigned char uleft_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x07, 0xfc, 0x07, 0xfc, 0x03, 0xfc, 0x07,
   0xfc, 0x0f, 0xfc, 0x1f, 0xfc, 0x3f, 0xfc, 0x1f, 0xec, 0x0f, 0xc0, 0x07,
   0x80, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00};

static unsigned char up_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xc0, 0x03, 0xe0, 0x07, 0xf0, 0x0f,
   0xf8, 0x1f, 0xfc, 0x3f, 0xfe, 0x7f, 0xfe, 0x7f, 0xe0, 0x07, 0xe0, 0x07,
   0xe0, 0x07, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00};

static unsigned char uright_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f, 0xe0, 0x3f, 0xc0, 0x3f, 0xe0, 0x3f,
   0xf0, 0x3f, 0xf8, 0x3f, 0xfc, 0x3f, 0xf8, 0x3f, 0xf0, 0x37, 0xe0, 0x03,
   0xc0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00};

#endif /* _h_XmuttGEditToolbarBitmaps */
