package xm::pfe::expandxrefwordrefsfcode;
use strict;
use xm::o;

sub DESC
{"
  get all ITEMFCODEs, make a database with the key to the contained
  <FORTHHEADER>..<XDEF>key</XDEF>. Then get to the remainings
  being a flattened wordset-table and expand XREFWORDREF with
  the ITEMFCODE. That's it.
  see xm::pfe::fcodesortnspill and xm::pfe::flattenwordrefs
"}

sub ARGS { return xm::o::args_stdin(@_,DESC); }


sub getxdef 
{
    my $in = shift;
    if ($in =~ m{ <FORTHHEADER>
		      ((?:.(?!</?FORTHHEADER\b))*.) 
			  <XDEF>
			      ((?:.(?!</?XDEF\b))*.) 
				  </XDEF> 
				  }sx) 
    { return $2; }
    return "";
}	


sub DO
{
    my $in = shift;
    my $xdef;
    my $item; # hashref;
    my $out;

    # pass 1 : cut out all ITEMFCODEs and store them by their XDEF

    $in =~ s{ (<ITEMFCODE\b[^<>]*>) 
		  ((?:.(?!</?ITEMFCODE\b))*.) (</ITEMFCODE\b[^<>]*>)
		  }
    { 
	$out = $1.$2.$3;
	$xdef = getxdef ($2);
	if (length $xdef)
	{
	    $out =~  s{ <XDEF> ((?:.(?!</?XDEF\b))*.)  </XDEF> }
	    { "<XREFWORDREF>".$1."</XREFWORDREF>" }gsex;
	    $$item{$xdef} = $out;
	};
	""
    }gsex;

    # pass 2 : look for XREFWORDREF and push the text in there.
    
    $in =~ s{ (<XREFWORDREF\b[^<>]*>) 
		  ((?:.(?!</?XREFWORDREF\b))*.) (</XREFWORDREF\b[^<>]*>)
		  }
    { 
	exists $$item{$2} 
	? $$item{$2} 
	: $1.$2.$3
	    ."<XREFWORDREFINFO>"
		." no special info, see general notes "
		    ."</XREFWORDREFINFO>"
    }gsex;

    return $in;
}

1;

