#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdkkeysyms.h>

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "cfg.h"
#include "widgets.h"
#include "interface_glob.h"
#include "runtime.h"
#include "netio.h"
#include "proc_lcp3.h"
#include "activities.h"
#include "askname.h"

#define SET_ENABLED(widget, state)	gtk_widget_set_sensitive(GTK_WIDGET(widget), state);

void
on_mn_file_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_wnd_acitivity_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GdkEventMask events;
	widgets_load_wdg_activity();
	gdk_window_set_decorations(wnd_activity->window, 0);
	events = gdk_window_get_events(wnd_activity->window);
	gdk_window_set_events(wnd_activity->window, events |
			GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
	gdk_window_move(wnd_activity->window, config->wnd_activity_x, config->wnd_activity_y);
}


void
on_wnd_acitivity_unrealize             (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_activity->realized = FALSE;
	wnd_activity = NULL;
}


void
on_mn_file_configuration_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	wnd_config = create_wnd_config ();
	gtk_window_set_modal(GTK_WINDOW(wnd_config), TRUE);
	gtk_widget_show (wnd_config);
}


void
on_mn_server_connect_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	activity_connect();
}


void
on_mn_server_shutdown_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_send(CMD3_SHUTDOWN, NULL, 0);
}


void
on_mn_line_online_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( runtime->client_status != CLT_OFFLINE ) return;
	cmd_send(CMD3_ONLINE, NULL, 0);
}


void
on_mn_line_isdnchannels_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	static gboolean inproc = FALSE;
	gboolean state = wdg_linemaster->mn_line_isdnchannels->active;
	if ( inproc ) return;
	inproc = TRUE;
	if ( ((runtime->selected_line->channels == 2) && state)
		|| ((runtime->selected_line->channels == 1) && (!state)) )
	{
		inproc = FALSE;
		return;
	}
	if ( runtime->selected_line->channels > 2 )
	{
		gtk_check_menu_item_set_active(wdg_linemaster->mn_line_isdnchannels, TRUE);
		inproc = FALSE;
		return;
	}
	if ( (runtime->selected_line->channels == 1) && state )
	{
		gtk_check_menu_item_set_active(wdg_linemaster->mn_line_isdnchannels, FALSE);
		#ifdef DEBUG
			g_print("requesting to add an isdnchannel...\n");
		#endif
		cmd_send(CMD3_CHANADD, NULL, 0);
	}
	else if ( (runtime->selected_line->channels == 2) && (!state) )
	{
		gtk_check_menu_item_set_active(wdg_linemaster->mn_line_isdnchannels, TRUE);
		#ifdef DEBUG
			g_print("requesting to remove an isdnchannel...\n");
		#endif
		cmd_send(CMD3_CHANRM, NULL, 0);
	}
	while ( gtk_events_pending() ) gtk_main_iteration();
	inproc = FALSE;
	return;
}


void
on_mn_line_autohangup_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	wnd_autohup = create_wnd_autohup();
	gtk_widget_show(wnd_autohup);
}


void
on_mn_line_reset_mmtput_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( !runtime->selected_line ) return;
	runtime->selected_line->ahup->cap_up = 0;
	runtime->selected_line->ahup->cap_down = 0;
	runtime->selected_line->ahup->max_up = 0;
	runtime->selected_line->ahup->max_down = 0;
	interface_propagate_line_data(runtime->selected_line);
}


void
on_cl_lines_select_row                 (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	struct tline * line = runtime_get_line_clid(++row);
	if ( runtime->selected_line == line ) return;
	#ifdef DEBUG
		g_print("selecting line %d '%s'\n", row, line->name);
	#endif
	runtime->selected_line = line;
	netio_set_line_id(line->num);
	config->default_line = line->num;
	proc_status_tracker(runtime->client_status, line->num, line->status, line->channels, TRUE);
	cmd_send(CMD3_LINESEL, NULL, 0);
	interface_propagate_line_data(line);
}


void
on_wnd_linemaster_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
	mn_file_exit_activate(NULL, NULL);
}


void
on_wnd_config_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_config();
	interface_load_into_wnd_config();
}


void
mn_file_exit_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( runtime->client_status != CLT_DISCON )
	{
		cmd_send(CMD3_UNREG, NULL, 0);
		runtime->terminate = TRUE;
	}
	else
		gtk_main_quit();
}


void
on_wnd_linemaster_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_linemaster();
	gdk_window_resize(wnd_linemaster->window, config->wnd_linemaster_w, config->wnd_linemaster_h);
	if ( config->wnd_activity_show && (!wnd_activity) )
		gtk_check_menu_item_set_active(wdg_linemaster->mn_line_wnd_activity, TRUE);
	if ( config->misc_event_window )
		on_mn_server_show_message_window_activate(NULL, NULL);
	if ( config->server_connect_on_startup )
		activity_connect();
}

void
on_wnd_linemaster_unrealize            (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_linemaster->realized = FALSE;
//	gdk_window_get_deskrelative_origin(wnd_linemaster->window, &config->wnd_linemaster_x, &config->wnd_linemaster_y);
	gdk_window_get_position(wnd_linemaster->window, &config->wnd_linemaster_x, &config->wnd_linemaster_y);
	gdk_window_get_size(wnd_linemaster->window, &config->wnd_linemaster_w, &config->wnd_linemaster_h);
	wnd_linemaster = NULL;
}

void
on_mn_line_wnd_activity_toggled        (GtkCheckMenuItem *checkmenuitem,
                                        gpointer         user_data)
{
	if ( checkmenuitem->active )
	{
//		g_print("creating wnd_activity\n");
		wnd_activity = create_wnd_activity ();
//	GTK_WIDGET_UNSET_FLAGS(GTK_WIDGET(wnd_config), GTK_TOPLEVEL);
//		gtk_widget_unparent(GTK_WIDGET(wnd_activity));
		gtk_widget_hide_on_delete(GTK_WIDGET(wnd_activity));
		gtk_widget_show(wnd_activity);
		config->wnd_activity_show = TRUE;
	}
	else
	{
		gtk_widget_destroy(GTK_WIDGET(wnd_activity));
		wnd_config = NULL;
		config->wnd_activity_show = FALSE;
	}
}

void
on_wnd_config_unrealize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_config->realized = FALSE;
	wnd_config = NULL;
}

void
on_wnd_messages_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GList * cur = wdg_messages->msgs;
	gdk_window_resize(wnd_messages->window, config->wnd_messages_w, config->wnd_messages_h);
	widgets_load_wdg_messages();
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_linemaster->mn_server_show_message_window), FALSE);
	while ( cur )
	{
	g_print(".\n");
		gtk_clist_append(wdg_messages->cl_messages, ((struct tmsg*)cur->data)->row);
		cur = g_list_next(cur);
	}
}


void wnd_messages_cl_messages_clear()
{
	int i;
	GList * cur = wdg_messages->msgs;
	#ifdef DEBUG
		g_print("deleting messages...\n");
	#endif
	gtk_clist_clear(GTK_CLIST(wdg_messages->cl_messages));
	while ( cur )
	{
		for (i=0; i<2; i++)
			g_free(((struct tmsg*)cur->data)->row[i]);
		g_free(cur->data);
		cur = g_list_next(cur);
	}
	g_list_free(wdg_messages->msgs);
	wdg_messages->msgs = NULL;
}

void
on_wnd_messages_unrealize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
//	wnd_messages_cl_messages_clear();
	config->wnd_messages_w = wnd_messages->allocation.width;
	config->wnd_messages_h = wnd_messages->allocation.height;
	wdg_messages->realized = FALSE;
	wnd_messages = NULL;
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_linemaster->mn_server_show_message_window), TRUE);
}


void
on_mn_server_show_message_window_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if ( !wnd_messages )
	{
		wnd_messages = create_wnd_messages();
		gtk_widget_show(wnd_messages);
	}
	else
		gtk_window_activate_focus(GTK_WINDOW(wnd_messages));
}

void
on_bt_close_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(wnd_messages);
}


void
on_bt_clear_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	wnd_messages_cl_messages_clear();
}

void
on_wnd_conserver_realize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_conserver();
}


void
on_wnd_conserver_unrealize             (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_conserver->realized = FALSE;
	wnd_conserver = NULL;
}


void
on_bt_wnd_conserver_close_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	proc_lcp3_cleanup();
	gtk_widget_destroy(wnd_conserver);
}

gint timeout_wnd_activity_move( gpointer data )
{
#define SNAP_RANGE	6
	gint px, py;
	GdkModifierType modf;
	static gint bottom, right, scrw = 0, scrh = 0;
	if ( !scrw )
	{
		gint w, h;
		scrw = gdk_screen_width();
		scrh = gdk_screen_height();
		gdk_window_get_size(wnd_activity->window, &w, &h);
		bottom = scrh - h;
		right = scrw - w;
	}
	gdk_window_get_pointer(wnd_activity->window, &px, &py, &modf);
	move_delta_activity->x = px - move_delta_activity->dx + move_delta_activity->x;
	move_delta_activity->y = py - move_delta_activity->dy + move_delta_activity->y;
	if ( abs(move_delta_activity->y - bottom) <= SNAP_RANGE )
		move_delta_activity->y = bottom;
	if ( abs(move_delta_activity->x - right) <= SNAP_RANGE )
		move_delta_activity->x = right;
	if ( abs(move_delta_activity->y) <= SNAP_RANGE )
		move_delta_activity->y = 0;
	if ( abs(move_delta_activity->x) <= SNAP_RANGE )
		move_delta_activity->x = 0;
	gdk_window_move(wnd_activity->window, move_delta_activity->x, move_delta_activity->y);
	return 1;
}

gboolean
on_wnd_activity_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	gint x, y;
	gint px, py;
	GdkModifierType modf;

	if ( event->button != 1 ) return FALSE;
	if ( event->type == GDK_2BUTTON_PRESS )
	{
		gtk_timeout_remove(move_delta_activity->timeout);
		g_free(move_delta_activity);
		move_delta_activity = NULL;
//		gtk_widget_show(wnd_linemaster);
		return FALSE;
	}

	gdk_window_get_position(wnd_activity->window, &x, &y);
	gdk_window_get_pointer(wnd_activity->window, &px, &py, &modf);

	move_delta_activity = g_malloc(sizeof(struct tMoveData));
	move_delta_activity->x = x;
	move_delta_activity->y = y;
	move_delta_activity->dx = px;
	move_delta_activity->dy = py;
	move_delta_activity->timeout = gtk_timeout_add(40, timeout_wnd_activity_move, NULL);
  return FALSE;
}


gboolean
on_wnd_activity_button_release_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if ( event->button != 1 ) return FALSE;
	if ( !move_delta_activity ) return FALSE;

	gtk_timeout_remove(move_delta_activity->timeout);
	timeout_wnd_activity_move(NULL);

	config->wnd_activity_x = move_delta_activity->x;
	config->wnd_activity_y = move_delta_activity->y;

	g_free(move_delta_activity);
	move_delta_activity = NULL;
  return FALSE;
}

void
on_bt_config_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(wnd_config);
}


void
on_bt_config_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	interface_save_from_wnd_config();
	gtk_widget_destroy(wnd_config);
}

void
on_wnd_autohup_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
	GSList * lcur = lines;
	wdg_autohup->linenames = NULL;
	widgets_load_wdg_autohup();
	// now load the data...
	while ( lcur )
	{
		wdg_autohup->linenames = g_list_append(wdg_autohup->linenames,
								((struct tline*)(lcur->data))->name);
		lcur = g_slist_next(lcur);
	}
	if ( lines )
	{
		gtk_combo_set_popdown_strings(wdg_autohup->cb_ahup_lines, wdg_autohup->linenames);
		gtk_entry_set_text(GTK_ENTRY(wdg_autohup->cb_ahup_lines->entry), runtime->selected_line->name);
		interface_glob_line_2_wdg_autohangup(runtime->selected_line->num);
	}
}


void
on_wnd_autohup_unrealize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	interface_glob_wdg_autohangup_2_line(wdg_autohup->selected_line->num);
	g_list_free(wdg_autohup->linenames);
	wdg_autohup->realized = FALSE;
}

void
on_bt_ahup_done_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(wnd_autohup);
}

void
on_chk_ahup_time_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_autohup->sp_ahup_time),
			!GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_time)));
	if ( GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_time)) )
		gtk_widget_grab_focus(GTK_WIDGET(wdg_autohup->sp_ahup_time));
}


void
on_chk_ahup_up_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_autohup->sp_ahup_up),
			!GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_up)));
	if ( GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_up)) )
		gtk_widget_grab_focus(GTK_WIDGET(wdg_autohup->sp_ahup_up));
}


void
on_chk_ahup_down_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_autohup->sp_ahup_down),
			!GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_down)));
	if ( GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_down)) )
		gtk_widget_grab_focus(GTK_WIDGET(wdg_autohup->sp_ahup_down));
}


void
on_chk_ahup_total_up_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_autohup->sp_ahup_total_up),
			!GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_total_up)));
	if ( GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_total_up)) )
		gtk_widget_grab_focus(GTK_WIDGET(wdg_autohup->sp_ahup_total_up));
}


void
on_chk_ahup_total_down_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(wdg_autohup->sp_ahup_total_down),
			!GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_total_down)));
	if ( GTK_WIDGET_SENSITIVE(GTK_WIDGET(wdg_autohup->sp_ahup_total_down)) )
		gtk_widget_grab_focus(GTK_WIDGET(wdg_autohup->sp_ahup_total_down));
}

void
on_bt_passwd_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	char * text;
	text = gtk_editable_get_chars(GTK_EDITABLE(wdg_passwd->ent_passwd_name), 0, -1);
	if ( config->user_name )
	{
		g_free(config->user_name);
		config->user_name = NULL;
	}
	if ( strlen(text) ) config->user_name = text;
	else g_free(text);
	text = gtk_editable_get_chars(GTK_EDITABLE(wdg_passwd->ent_passwd_passwd), 0, -1);
	if ( config->user_passwd )
	{
		g_free(config->user_passwd);
		config->user_passwd = NULL;
	}
	if ( strlen(text) ) config->user_passwd = text;
	else g_free(text);
	gtk_widget_destroy(wnd_passwd);
	wnd_passwd = NULL;
}


gboolean
on_ent_passwd_passwd_key_press_event   (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if ( event->keyval != GDK_Return ) return FALSE;
	on_bt_passwd_ok_clicked(NULL, NULL);
  return FALSE;
}


void
on_wnd_passwd_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_passwd();
	gtk_entry_set_text(wdg_passwd->ent_passwd_name, config->user_name);
	if ( config->user_passwd )
		gtk_entry_set_text(wdg_passwd->ent_passwd_passwd, config->user_passwd);
}


void
on_wnd_passwd_unrealize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_passwd->realized = FALSE;
}


gboolean
on_wnd_conserver_key_press_event       (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if ( (event->keyval == GDK_Escape) || (event->keyval == GDK_Return) )
		on_bt_wnd_conserver_close_clicked(NULL, NULL);
  return FALSE;
}


void
on_mn_server_disconnect_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_send(CMD3_UNREG, NULL, 0);
}


void
on_mn_line_offline_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_send(CMD3_OFFLINE, NULL, 0);
}


void
on_chk_ahup_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gboolean state = gtk_toggle_button_get_active(togglebutton);
	proc_autohangup_reset(0);
	if ( state != runtime->selected_line->ahup->activated )
	{
		runtime->selected_line->ahup->activated = state;
		if ( wdg_autohup->realized && (wdg_autohup->selected_line == runtime->selected_line) )
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_autohup->chk_ahup_activated), state);
	}
}

void
on_chk_ahup_activated_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
/*
	gboolean state = gtk_toggle_button_get_active(togglebutton);
	if ( wdg_linemaster->realized && (wdg_autohup->selected_line == runtime->selected_line) )
	{
		if ( state != runtime->selected_line->ahup->activated )
		{
			runtime->selected_line->ahup->activated = state;
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wdg_linemaster->chk_ahup), state);
		}
	}
	else wdg_autohup->selected_line->ahup->activated = state;
*/
}

void
on_ed_ahup_lines_changed               (GtkEditable     *editable,
                                        gpointer         user_data)
{
	const char * linename = gtk_editable_get_chars(editable, 0, -1);
	struct tline * line = runtime_get_line_by_name(linename);
	if ( !line ) return;
	interface_glob_line_2_wdg_autohangup(line->num);
}

void
on_chk_enable_mysql_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gboolean state = gtk_toggle_button_get_active(togglebutton);
	SET_ENABLED(wdg_config->ent_mysql_host, state)
	SET_ENABLED(wdg_config->lb_mysql_host, state)
	SET_ENABLED(wdg_config->ent_mysql_user, state)
	SET_ENABLED(wdg_config->lb_mysql_user, state)
	SET_ENABLED(wdg_config->ent_mysql_pass, state)
	SET_ENABLED(wdg_config->lb_mysql_pass, state)
	SET_ENABLED(wdg_config->ent_mysql_db, state)
	SET_ENABLED(wdg_config->lb_mysql_db, state)
	SET_ENABLED(wdg_config->chk_addrbook_ask, state)
}

void
on_bt_asknum_cancel_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
#if HAVE_LIBMYSQL
	an_cancel();
#endif
}


void
on_bt_asknum_ok_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
#if HAVE_LIBMYSQL
	an_ok();
#endif
}


void
on_wnd_askname_unrealize               (GtkWidget       *widget,
                                        gpointer         user_data)
{
	wdg_askname->realized = 0;
}


void
on_wnd_askname_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
	widgets_load_wdg_askname();
}
